/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.AnnotationInsertion;
import annotator.find.Criteria;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.TreeFinder;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.plumelib.util.Pair;
import scenelib.annotations.io.ASTPath;
import scenelib.type.ArrayType;
import scenelib.type.BoundedType;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public abstract class Insertion {
    private final Criteria criteria;
    private final boolean separateLine;
    private boolean inserted;
    protected Set<String> packageNames;
    protected static Set<String> alwaysQualify = new LinkedHashSet<String>();

    public Insertion(Criteria criteria, boolean separateLine) {
        this.criteria = criteria;
        this.separateLine = separateLine;
        this.packageNames = new LinkedHashSet<String>();
        this.inserted = false;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public String getText() {
        return this.getText(false, false, true, 0, '\u0000');
    }

    public String getText(boolean comments, boolean abbreviate, boolean gotSeparateLine, int pos, char precedingChar) {
        String toInsert = this.getText(comments, abbreviate);
        if (!toInsert.isEmpty()) {
            if (this.addLeadingSpace(gotSeparateLine, pos, precedingChar)) {
                toInsert = " " + toInsert;
            }
            if (this.addTrailingSpace(gotSeparateLine)) {
                toInsert = toInsert + " ";
            }
        }
        return toInsert;
    }

    protected abstract String getText(boolean var1, boolean var2);

    protected boolean addLeadingSpace(boolean gotSeparateLine, int pos, char precedingChar) {
        return !gotSeparateLine && pos != 0 && !Character.isWhitespace(precedingChar) && precedingChar != '(' && precedingChar != '<';
    }

    protected boolean addTrailingSpace(boolean gotSeparateLine) {
        return !gotSeparateLine;
    }

    public Set<String> getPackageNames() {
        return this.packageNames;
    }

    public static Set<String> getAlwaysQualify() {
        return alwaysQualify;
    }

    public static void setAlwaysQualify(Set<String> set) {
        alwaysQualify = set;
    }

    public boolean isSeparateLine() {
        return this.separateLine;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public void setInserted(boolean inserted) {
        if (Main.temporaryDebug) {
            System.out.printf("setInserted(%s) (previously %s) for %s%n", inserted, this.inserted, this);
            new Error().printStackTrace();
        }
        this.inserted = inserted;
    }

    public String toString() {
        return String.format("(nl=%b) @ %s", this.separateLine, this.criteria);
    }

    public abstract Kind getKind();

    public static Pair<String, String> removePackage(String s2) {
        String basename;
        int dotIndex;
        int nameEnd = s2.indexOf("(");
        if (nameEnd == -1) {
            nameEnd = s2.length();
        }
        if ((dotIndex = s2.lastIndexOf(".", nameEnd)) != -1 && !alwaysQualify.contains(basename = s2.substring(dotIndex + 1))) {
            String packageName = s2.substring(0, nameEnd);
            if (packageName.startsWith("@")) {
                return Pair.of(packageName.substring(1), "@" + basename);
            }
            return Pair.of(packageName, basename);
        }
        return Pair.of(null, s2);
    }

    public String typeToString(Type type, boolean comments, boolean abbreviate) {
        StringBuilder result = new StringBuilder();
        switch (type.getKind()) {
            case DECLARED: {
                DeclaredType innerType;
                DeclaredType declaredType = (DeclaredType)type;
                String typeName = declaredType.getName();
                int sep = typeName.lastIndexOf(46) + 1;
                if (abbreviate) {
                    typeName = typeName.substring(sep);
                } else if (sep > 0) {
                    result.append(typeName.substring(0, sep));
                    typeName = typeName.substring(sep);
                }
                this.writeAnnotations(type, result, comments, abbreviate);
                result.append(typeName);
                if (declaredType.isWildcard()) break;
                List<Type> typeArguments = declaredType.getTypeParameters();
                if (!typeArguments.isEmpty()) {
                    result.append('<');
                    result.append(this.typeToString(typeArguments.get(0), comments, abbreviate));
                    for (int i = 1; i < typeArguments.size(); ++i) {
                        result.append(", ");
                        result.append(this.typeToString(typeArguments.get(i), comments, abbreviate));
                    }
                    result.append('>');
                }
                if ((innerType = declaredType.getInnerType()) == null) break;
                result.append('.');
                result.append(this.typeToString(innerType, comments, abbreviate));
                break;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                result.append(this.typeToString(arrayType.getComponentType(), comments, abbreviate));
                if (!arrayType.getAnnotations().isEmpty()) {
                    result.append(' ');
                }
                this.writeAnnotations(type, result, comments, abbreviate);
                result.append("[]");
                break;
            }
            case BOUNDED: {
                BoundedType boundedType = (BoundedType)type;
                result.append(this.typeToString(boundedType.getName(), comments, abbreviate));
                result.append(' ');
                result.append((Object)boundedType.getBoundKind());
                result.append(' ');
                result.append(this.typeToString(boundedType.getBound(), comments, abbreviate));
                break;
            }
            default: {
                throw new RuntimeException("Illegal kind: " + (Object)((Object)type.getKind()));
            }
        }
        return result.toString().trim();
    }

    private void writeAnnotations(Type type, StringBuilder result, boolean comments, boolean abbreviate) {
        for (String annotation2 : type.getAnnotations()) {
            AnnotationInsertion ins = new AnnotationInsertion(annotation2);
            result.append(ins.getText(comments, abbreviate));
            result.append(" ");
            if (!abbreviate) continue;
            this.packageNames.addAll(ins.getPackageNames());
        }
    }

    public static void decorateType(List<Insertion> innerTypeInsertions, Type outerType) {
        Insertion.decorateType(innerTypeInsertions, outerType, null);
    }

    public static void decorateType(List<Insertion> innerTypeInsertions, Type outerType, ASTPath outerPath) {
        for (Insertion innerInsertion : innerTypeInsertions) {
            innerInsertion.setInserted(true);
            try {
                if (innerInsertion.getKind() != Kind.ANNOTATION) {
                    throw new RuntimeException("Expected 'ANNOTATION' insertion kind, got '" + (Object)((Object)innerInsertion.getKind()) + "'.");
                }
                GenericArrayLocationCriterion c = innerInsertion.getCriteria().getGenericArrayLocation();
                String annos = ((AnnotationInsertion)innerInsertion).getAnnotation();
                if (c == null) {
                    ASTPath astPath = innerInsertion.getCriteria().getASTPath();
                    if (outerPath != null && astPath != null) {
                        Insertion.decorateType(astPath, annos, outerType, outerPath);
                        continue;
                    }
                    throw new RuntimeException("Missing type path.");
                }
                List<TypeAnnotationPosition.TypePathEntry> location = c.getLocation();
                Type type = outerType;
                for (TypeAnnotationPosition.TypePathEntry tpe : location) {
                    switch (tpe.tag) {
                        case ARRAY: {
                            if (type.getKind() == Type.Kind.ARRAY) {
                                type = ((ArrayType)type).getComponentType();
                                break;
                            }
                            throw new RuntimeException("Incorrect type path.");
                        }
                        case INNER_TYPE: {
                            DeclaredType declaredType;
                            if (type.getKind() == Type.Kind.DECLARED) {
                                declaredType = (DeclaredType)type;
                                if (declaredType.getInnerType() == null) {
                                    throw new RuntimeException("Incorrect type path: expected inner type but none exists.");
                                }
                                type = declaredType.getInnerType();
                                break;
                            }
                            throw new RuntimeException("Incorrect type path.");
                        }
                        case WILDCARD: {
                            if (type.getKind() == Type.Kind.BOUNDED) {
                                BoundedType boundedType = (BoundedType)type;
                                if (boundedType.getBound() == null) {
                                    throw new RuntimeException("Incorrect type path: expected type bound but none exists.");
                                }
                                type = boundedType.getBound();
                                break;
                            }
                            throw new RuntimeException("Incorrect type path.");
                        }
                        case TYPE_ARGUMENT: {
                            DeclaredType declaredType;
                            if (type.getKind() == Type.Kind.DECLARED) {
                                declaredType = (DeclaredType)type;
                                if (0 <= tpe.arg && tpe.arg < declaredType.getTypeParameters().size()) {
                                    type = declaredType.getTypeParameter(tpe.arg);
                                    break;
                                }
                                throw new RuntimeException("Incorrect type argument index: " + tpe.arg);
                            }
                            throw new RuntimeException("Incorrect type path.");
                        }
                        default: {
                            throw new RuntimeException("Illegal TypePathEntryKind: " + (Object)((Object)tpe.tag));
                        }
                    }
                }
                if (type.getKind() == Type.Kind.BOUNDED) {
                    type = ((BoundedType)type).getName();
                }
                type.addAnnotation(annos);
            }
            catch (Throwable e) {
                TreeFinder.reportInsertionError(innerInsertion, e);
            }
        }
    }

    private static void decorateType(ASTPath astPath, String annos, Type type, ASTPath outerPath) {
        Iterator<ASTPath.ASTEntry> ii = astPath.iterator();
        Iterator<ASTPath.ASTEntry> oi = outerPath.iterator();
        while (oi.hasNext()) {
            if (ii.hasNext() && oi.next().equals(ii.next())) continue;
            throw new RuntimeException("Incorrect AST path.");
        }
        while (ii.hasNext()) {
            ASTPath.ASTEntry entry = ii.next();
            Tree.Kind kind = entry.getTreeKind();
            switch (kind) {
                case ARRAY_TYPE: {
                    if (type.getKind() == Type.Kind.ARRAY) {
                        type = ((ArrayType)type).getComponentType();
                        break;
                    }
                    throw new RuntimeException("Incorrect type path.");
                }
                case MEMBER_SELECT: {
                    if (type.getKind() == Type.Kind.DECLARED) {
                        DeclaredType declaredType = (DeclaredType)type;
                        if (declaredType.getInnerType() == null) {
                            throw new RuntimeException("Incorrect type path: expected inner type but none exists.");
                        }
                        type = declaredType.getInnerType();
                        break;
                    }
                    throw new RuntimeException("Incorrect type path.");
                }
                case PARAMETERIZED_TYPE: {
                    if (type.getKind() == Type.Kind.DECLARED) {
                        int arg = entry.getArgument();
                        DeclaredType declaredType = (DeclaredType)type;
                        if (0 <= arg && arg < declaredType.getTypeParameters().size()) {
                            type = declaredType.getTypeParameter(arg);
                            break;
                        }
                        throw new RuntimeException("Incorrect type argument index: " + arg);
                    }
                    throw new RuntimeException("Incorrect type path.");
                }
                case UNBOUNDED_WILDCARD: {
                    if (type.getKind() == Type.Kind.BOUNDED) {
                        BoundedType boundedType = (BoundedType)type;
                        if (boundedType.getBound() == null) {
                            throw new RuntimeException("Incorrect type path: expected type bound but none exists.");
                        }
                        type = boundedType.getBound();
                        break;
                    }
                    throw new RuntimeException("Incorrect type path.");
                }
                default: {
                    throw new RuntimeException("Illegal TreeKind: " + (Object)((Object)kind));
                }
            }
        }
        if (type.getKind() == Type.Kind.BOUNDED) {
            type = ((BoundedType)type).getName();
        }
        type.addAnnotation(annos);
    }

    public static enum Kind {
        ANNOTATION,
        CAST,
        CONSTRUCTOR,
        METHOD,
        NEW,
        RECEIVER,
        CLOSE_PARENTHESIS;

    }
}

