/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import org.checkerframework.qualframework.base.QualifiedTypeVisitor;
import org.checkerframework.qualframework.util.ExtendedArrayType;
import org.checkerframework.qualframework.util.ExtendedDeclaredType;
import org.checkerframework.qualframework.util.ExtendedExecutableType;
import org.checkerframework.qualframework.util.ExtendedIntersectionType;
import org.checkerframework.qualframework.util.ExtendedNoType;
import org.checkerframework.qualframework.util.ExtendedNullType;
import org.checkerframework.qualframework.util.ExtendedParameterDeclaration;
import org.checkerframework.qualframework.util.ExtendedPrimitiveType;
import org.checkerframework.qualframework.util.ExtendedTypeDeclaration;
import org.checkerframework.qualframework.util.ExtendedTypeMirror;
import org.checkerframework.qualframework.util.ExtendedTypeVariable;
import org.checkerframework.qualframework.util.ExtendedUnionType;
import org.checkerframework.qualframework.util.ExtendedWildcardType;

public abstract class QualifiedTypeMirror<Q> {
    private final ExtendedTypeMirror underlying;
    private final Q qualifier;

    private QualifiedTypeMirror(ExtendedTypeMirror underlying) {
        this.underlying = underlying;
        this.qualifier = null;
    }

    private QualifiedTypeMirror(ExtendedTypeMirror underlying, Q qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException("cannot construct QualifiedTypeMirror with null qualifier");
        }
        this.underlying = underlying;
        this.qualifier = qualifier;
    }

    public abstract <R, P> R accept(QualifiedTypeVisitor<Q, R, P> var1, P var2);

    public ExtendedTypeMirror getUnderlyingType() {
        return this.underlying;
    }

    public final TypeKind getKind() {
        return this.underlying.getKind();
    }

    public final Q getQualifier() {
        return this.qualifier;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        QualifiedTypeMirror other = (QualifiedTypeMirror)obj;
        return this.qualifier.equals(other.qualifier) && this.underlying.equals(other.underlying);
    }

    public int hashCode() {
        return this.qualifier.hashCode() * 17 + this.underlying.hashCode() * 37;
    }

    private static void checkUnderlyingKind(ExtendedTypeMirror underlying, TypeKind expectedKind, boolean expectedDeclaration) {
        TypeKind actualKind = underlying.getKind();
        boolean actualDeclaration = underlying.isDeclaration();
        if (actualKind != expectedKind || actualDeclaration != expectedDeclaration) {
            String actualKindName = (Object)((Object)actualKind) + (actualDeclaration ? " DECLARATION" : "");
            String expectedKindName = (Object)((Object)expectedKind) + (expectedDeclaration ? " DECLARATION" : "");
            throw new IllegalArgumentException("underlying ExtendedTypeMirror must have kind " + expectedKindName + ", not " + actualKindName);
        }
    }

    private static void checkUnderlyingKind(ExtendedTypeMirror underlying, TypeKind expectedKind) {
        QualifiedTypeMirror.checkUnderlyingKind(underlying, expectedKind, false);
    }

    private static void checkUnderlyingKindIsOneOf(ExtendedTypeMirror underlying, TypeKind ... validKinds) {
        TypeKind actualKind = underlying.getKind();
        if (underlying.isDeclaration()) {
            throw new IllegalArgumentException("underlying ExtendedTypeMirror must have one of the kinds " + Arrays.toString((Object[])validKinds) + ", not " + (Object)((Object)actualKind) + " DECLARATION");
        }
        for (TypeKind kind : validKinds) {
            if (actualKind != kind) continue;
            return;
        }
        throw new IllegalArgumentException("underlying ExtendedTypeMirror must have one of the kinds " + Arrays.toString((Object[])validKinds) + ", not " + (Object)((Object)actualKind));
    }

    private static void checkUnderlyingKindIsPrimitive(ExtendedTypeMirror underlying) {
        TypeKind actualKind = underlying.getKind();
        if (!actualKind.isPrimitive()) {
            throw new IllegalArgumentException("underlying ExtendedTypeMirror must have primitive kind, not " + (Object)((Object)actualKind));
        }
    }

    private static <Q> void checkTypeMirrorsMatch(String description, QualifiedTypeMirror<Q> qualified, ExtendedTypeMirror unqualified) {
        if (!QualifiedTypeMirror.typeMirrorsMatch(qualified, unqualified)) {
            throw new IllegalArgumentException("qualified and unqualified " + description + " TypeMirrors must be identical");
        }
    }

    private static <Q> void checkTypeMirrorListsMatch(String description, List<? extends QualifiedTypeMirror<Q>> qualified, List<? extends ExtendedTypeMirror> unqualified) {
        if (!QualifiedTypeMirror.typeMirrorListsMatch(qualified, unqualified)) {
            throw new IllegalArgumentException("qualified and unqualified " + description + " TypeMirrors must be identical");
        }
    }

    private static <Q> boolean typeMirrorsMatch(QualifiedTypeMirror<Q> qualified, ExtendedTypeMirror unqualified) {
        if (qualified == null && unqualified == null) {
            return true;
        }
        return qualified != null && unqualified != null && qualified.getUnderlyingType().equals(unqualified);
    }

    private static <Q> boolean typeMirrorListsMatch(List<? extends QualifiedTypeMirror<Q>> qualified, List<? extends ExtendedTypeMirror> unqualified) {
        if (qualified == null && unqualified == null) {
            return true;
        }
        if (qualified == null || unqualified == null) {
            return false;
        }
        if (unqualified.size() != qualified.size()) {
            return false;
        }
        for (int i = 0; i < qualified.size(); ++i) {
            if (QualifiedTypeMirror.typeMirrorsMatch(qualified.get(i), unqualified.get(i))) continue;
            return false;
        }
        return true;
    }

    private static String punctuatedList(String punct, List<? extends Object> objs) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object object : objs) {
            if (!first) {
                sb.append(punct);
            } else {
                first = false;
            }
            sb.append(object);
        }
        return sb.toString();
    }

    private static String commaSeparatedList(List<? extends Object> objs) {
        return QualifiedTypeMirror.punctuatedList(", ", objs);
    }

    public static final class QualifiedParameterDeclaration<Q>
    extends QualifiedTypeMirror<Q> {
        public QualifiedParameterDeclaration(ExtendedTypeMirror underlying) {
            super(underlying);
            QualifiedTypeMirror.checkUnderlyingKind(underlying, TypeKind.TYPEVAR, true);
            if (this.getUnderlyingType().asElement().getKind() != ElementKind.TYPE_PARAMETER) {
                throw new IllegalArgumentException("underlying type's asElement() must have kind TYPE_PARAMETER");
            }
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitParameterDeclaration(this, p);
        }

        @Override
        public ExtendedParameterDeclaration getUnderlyingType() {
            return (ExtendedParameterDeclaration)super.getUnderlyingType();
        }

        public TypeParameterElement asElement() {
            return (TypeParameterElement)this.getUnderlyingType().asElement();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getQualifier()).append(" ").append(this.getUnderlyingType().asElement().getSimpleName());
            return sb.toString();
        }
    }

    public static final class QualifiedTypeDeclaration<Q>
    extends QualifiedTypeMirror<Q> {
        private final List<? extends QualifiedParameterDeclaration<Q>> typeParameters;

        public QualifiedTypeDeclaration(ExtendedTypeMirror underlying, Q qualifier, List<? extends QualifiedParameterDeclaration<Q>> typeParameters) {
            super(underlying, qualifier);
            QualifiedTypeMirror.checkUnderlyingKind(underlying, TypeKind.DECLARED, true);
            QualifiedTypeMirror.checkTypeMirrorListsMatch("parameter", typeParameters, this.getUnderlyingType().getTypeParameters());
            this.typeParameters = new ArrayList<QualifiedParameterDeclaration<Q>>(typeParameters);
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitTypeDeclaration(this, p);
        }

        @Override
        public ExtendedTypeDeclaration getUnderlyingType() {
            return (ExtendedTypeDeclaration)super.getUnderlyingType();
        }

        public List<? extends QualifiedParameterDeclaration<Q>> getTypeParameters() {
            return this.typeParameters;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getQualifier());
            sb.append(" ");
            sb.append(this.getUnderlyingType());
            if (this.typeParameters.size() > 0) {
                sb.append("<").append(QualifiedTypeMirror.commaSeparatedList(this.typeParameters)).append(">");
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            QualifiedTypeDeclaration other = (QualifiedTypeDeclaration)obj;
            return this.typeParameters.equals(other.typeParameters);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.typeParameters.hashCode() * 43;
        }
    }

    public static final class QualifiedWildcardType<Q>
    extends QualifiedTypeMirror<Q> {
        private final QualifiedTypeMirror<Q> extendsBound;
        private final QualifiedTypeMirror<Q> superBound;

        public QualifiedWildcardType(ExtendedTypeMirror underlying, QualifiedTypeMirror<Q> extendsBound, QualifiedTypeMirror<Q> superBound) {
            super(underlying);
            QualifiedTypeMirror.checkUnderlyingKind(underlying, TypeKind.WILDCARD);
            QualifiedTypeMirror.checkTypeMirrorsMatch("extends bound", (QualifiedTypeMirror)extendsBound, this.getUnderlyingType().getExtendsBound());
            QualifiedTypeMirror.checkTypeMirrorsMatch("super bound", (QualifiedTypeMirror)superBound, this.getUnderlyingType().getSuperBound());
            this.extendsBound = extendsBound;
            this.superBound = superBound;
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitWildcard(this, p);
        }

        @Override
        public ExtendedWildcardType getUnderlyingType() {
            return (ExtendedWildcardType)super.getUnderlyingType();
        }

        public QualifiedTypeMirror<Q> getExtendsBound() {
            return this.extendsBound;
        }

        public QualifiedTypeMirror<Q> getSuperBound() {
            return this.superBound;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getQualifier()).append(" ?").append(" extends ").append(this.extendsBound).append(" super ").append(this.superBound);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            QualifiedWildcardType other = (QualifiedWildcardType)obj;
            return this.extendsBound.equals(other.extendsBound) && (this.superBound == null ? other.superBound == null : this.superBound.equals(other.superBound));
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.extendsBound.hashCode() * 43 + (this.superBound == null ? 0 : this.superBound.hashCode() * 67);
        }
    }

    public static final class QualifiedUnionType<Q>
    extends QualifiedTypeMirror<Q> {
        private final List<? extends QualifiedTypeMirror<Q>> alternatives;

        public QualifiedUnionType(ExtendedTypeMirror underlying, Q qualifier, List<? extends QualifiedTypeMirror<Q>> alternatives) {
            super(underlying, qualifier);
            QualifiedTypeMirror.checkUnderlyingKind(underlying, TypeKind.UNION);
            QualifiedTypeMirror.checkTypeMirrorListsMatch("alternative", alternatives, this.getUnderlyingType().getAlternatives());
            this.alternatives = new ArrayList<QualifiedTypeMirror<Q>>(alternatives);
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitUnion(this, p);
        }

        @Override
        public ExtendedUnionType getUnderlyingType() {
            return (ExtendedUnionType)super.getUnderlyingType();
        }

        public List<? extends QualifiedTypeMirror<Q>> getAlternatives() {
            return this.alternatives;
        }

        public String toString() {
            return QualifiedTypeMirror.punctuatedList(" | ", this.alternatives);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            QualifiedUnionType other = (QualifiedUnionType)obj;
            return this.alternatives.equals(other.alternatives);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.alternatives.hashCode() * 43;
        }
    }

    public static final class QualifiedTypeVariable<Q>
    extends QualifiedTypeMirror<Q> {
        public QualifiedTypeVariable(ExtendedTypeMirror underlying, Q qualifier) {
            super(underlying, qualifier);
            QualifiedTypeMirror.checkUnderlyingKind(underlying, TypeKind.TYPEVAR);
            if (this.getUnderlyingType().asElement().getKind() != ElementKind.TYPE_PARAMETER) {
                throw new IllegalArgumentException("underlying type's asElement() must have kind TYPE_PARAMETER");
            }
        }

        public boolean isPrimaryQualifierValid() {
            return this.getUnderlyingType().getAnnotationMirrors().size() > 0;
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitTypeVariable(this, p);
        }

        @Override
        public ExtendedTypeVariable getUnderlyingType() {
            return (ExtendedTypeVariable)super.getUnderlyingType();
        }

        public TypeParameterElement asElement() {
            return (TypeParameterElement)this.getUnderlyingType().asElement();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getQualifier()).append(" ").append(this.getUnderlyingType().asElement().getSimpleName());
            return sb.toString();
        }

        public QualifiedParameterDeclaration<Q> getDeclaration() {
            return new QualifiedParameterDeclaration(this.getUnderlyingType().getDeclaration());
        }
    }

    public static final class QualifiedPrimitiveType<Q>
    extends QualifiedTypeMirror<Q> {
        public QualifiedPrimitiveType(ExtendedTypeMirror underlying, Q qualifier) {
            super(underlying, qualifier);
            QualifiedTypeMirror.checkUnderlyingKindIsPrimitive(underlying);
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitPrimitive(this, p);
        }

        @Override
        public ExtendedPrimitiveType getUnderlyingType() {
            return (ExtendedPrimitiveType)super.getUnderlyingType();
        }

        public String toString() {
            return this.getQualifier() + " " + this.getUnderlyingType();
        }
    }

    public static final class QualifiedNullType<Q>
    extends QualifiedTypeMirror<Q> {
        public QualifiedNullType(ExtendedTypeMirror underlying, Q qualifier) {
            super(underlying, qualifier);
            QualifiedTypeMirror.checkUnderlyingKind(underlying, TypeKind.NULL);
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitNull(this, p);
        }

        @Override
        public ExtendedNullType getUnderlyingType() {
            return (ExtendedNullType)super.getUnderlyingType();
        }

        public String toString() {
            return this.getQualifier() + " " + this.getUnderlyingType();
        }
    }

    public static final class QualifiedNoType<Q>
    extends QualifiedTypeMirror<Q> {
        public QualifiedNoType(ExtendedTypeMirror underlying, Q qualifier) {
            super(underlying, qualifier);
            QualifiedTypeMirror.checkUnderlyingKindIsOneOf(underlying, new TypeKind[]{TypeKind.NONE, TypeKind.PACKAGE, TypeKind.VOID});
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitNoType(this, p);
        }

        @Override
        public ExtendedNoType getUnderlyingType() {
            return (ExtendedNoType)super.getUnderlyingType();
        }

        public String toString() {
            return this.getQualifier() + " " + this.getUnderlyingType();
        }
    }

    public static final class QualifiedIntersectionType<Q>
    extends QualifiedTypeMirror<Q> {
        private final List<? extends QualifiedTypeMirror<Q>> bounds;

        public QualifiedIntersectionType(ExtendedTypeMirror underlying, Q qualifier, List<? extends QualifiedTypeMirror<Q>> bounds) {
            super(underlying, qualifier);
            QualifiedTypeMirror.checkUnderlyingKind(underlying, TypeKind.INTERSECTION);
            QualifiedTypeMirror.checkTypeMirrorListsMatch("bounds", bounds, this.getUnderlyingType().getBounds());
            this.bounds = new ArrayList<QualifiedTypeMirror<Q>>(bounds);
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitIntersection(this, p);
        }

        @Override
        public ExtendedIntersectionType getUnderlyingType() {
            return (ExtendedIntersectionType)super.getUnderlyingType();
        }

        public List<? extends QualifiedTypeMirror<Q>> getBounds() {
            return this.bounds;
        }

        public String toString() {
            return QualifiedTypeMirror.punctuatedList(" & ", this.bounds);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            QualifiedIntersectionType other = (QualifiedIntersectionType)obj;
            return this.bounds.equals(other.bounds);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.bounds.hashCode() * 43;
        }
    }

    public static final class QualifiedExecutableType<Q>
    extends QualifiedTypeMirror<Q> {
        private final List<? extends QualifiedTypeMirror<Q>> parameterTypes;
        private final QualifiedTypeMirror<Q> receiverType;
        private final QualifiedTypeMirror<Q> returnType;
        private final List<? extends QualifiedTypeMirror<Q>> thrownTypes;
        private final List<? extends QualifiedParameterDeclaration<Q>> typeParameters;

        public QualifiedExecutableType(ExtendedTypeMirror underlying, List<? extends QualifiedTypeMirror<Q>> parameterTypes, QualifiedTypeMirror<Q> receiverType, QualifiedTypeMirror<Q> returnType, List<? extends QualifiedTypeMirror<Q>> thrownTypes, List<? extends QualifiedParameterDeclaration<Q>> typeParameters) {
            super(underlying);
            QualifiedTypeMirror.checkUnderlyingKind(underlying, TypeKind.EXECUTABLE);
            QualifiedTypeMirror.checkTypeMirrorListsMatch("parameter", parameterTypes, this.getUnderlyingType().getParameterTypes());
            QualifiedTypeMirror.checkTypeMirrorsMatch("receiver", (QualifiedTypeMirror)receiverType, this.getUnderlyingType().getReceiverType());
            QualifiedTypeMirror.checkTypeMirrorsMatch("return", (QualifiedTypeMirror)returnType, this.getUnderlyingType().getReturnType());
            QualifiedTypeMirror.checkTypeMirrorListsMatch("thrown", thrownTypes, this.getUnderlyingType().getThrownTypes());
            QualifiedTypeMirror.checkTypeMirrorListsMatch("type parameter", typeParameters, this.getUnderlyingType().getTypeParameters());
            this.parameterTypes = new ArrayList<QualifiedTypeMirror<Q>>(parameterTypes);
            this.receiverType = receiverType;
            this.returnType = returnType;
            this.thrownTypes = new ArrayList<QualifiedTypeMirror<Q>>(thrownTypes);
            this.typeParameters = new ArrayList<QualifiedParameterDeclaration<Q>>(typeParameters);
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitExecutable(this, p);
        }

        @Override
        public ExtendedExecutableType getUnderlyingType() {
            return (ExtendedExecutableType)super.getUnderlyingType();
        }

        public List<? extends QualifiedTypeMirror<Q>> getParameterTypes() {
            return this.parameterTypes;
        }

        public QualifiedTypeMirror<Q> getReceiverType() {
            return this.receiverType;
        }

        public QualifiedTypeMirror<Q> getReturnType() {
            return this.returnType;
        }

        public List<? extends QualifiedTypeMirror<Q>> getThrownTypes() {
            return this.thrownTypes;
        }

        public List<? extends QualifiedParameterDeclaration<Q>> getTypeParameters() {
            return this.typeParameters;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getQualifier()).append(" : ");
            if (this.typeParameters.size() > 0) {
                sb.append("<").append(QualifiedTypeMirror.commaSeparatedList(this.typeParameters)).append(">");
            }
            sb.append(this.returnType);
            sb.append("((");
            if (this.receiverType != null) {
                sb.append(this.receiverType).append(" this, ");
            }
            sb.append(QualifiedTypeMirror.commaSeparatedList(this.parameterTypes));
            sb.append("))");
            if (this.thrownTypes.size() > 0) {
                sb.append(" throws ").append(QualifiedTypeMirror.commaSeparatedList(this.thrownTypes));
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            QualifiedExecutableType other = (QualifiedExecutableType)obj;
            return this.parameterTypes.equals(other.parameterTypes) && (this.receiverType == null ? other.receiverType == null : this.receiverType.equals(other.receiverType)) && (this.returnType == null ? other.returnType == null : this.returnType.equals(other.returnType)) && this.thrownTypes.equals(other.thrownTypes) && this.typeParameters.equals(other.typeParameters);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.parameterTypes.hashCode() * 43 + (this.receiverType == null ? 0 : this.receiverType.hashCode() * 67) + (this.returnType == null ? 0 : this.returnType.hashCode() * 83) + this.thrownTypes.hashCode() * 109 + this.typeParameters.hashCode() * 127;
        }
    }

    public static final class QualifiedDeclaredType<Q>
    extends QualifiedTypeMirror<Q> {
        private final List<? extends QualifiedTypeMirror<Q>> typeArguments;

        public QualifiedDeclaredType(ExtendedTypeMirror underlying, Q qualifier, List<? extends QualifiedTypeMirror<Q>> typeArguments) {
            super(underlying, qualifier);
            QualifiedTypeMirror.checkUnderlyingKind(underlying, TypeKind.DECLARED);
            QualifiedTypeMirror.checkTypeMirrorListsMatch("argument", typeArguments, this.getUnderlyingType().getTypeArguments());
            this.typeArguments = new ArrayList<QualifiedTypeMirror<Q>>(typeArguments);
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitDeclared(this, p);
        }

        @Override
        public ExtendedDeclaredType getUnderlyingType() {
            return (ExtendedDeclaredType)super.getUnderlyingType();
        }

        public List<? extends QualifiedTypeMirror<Q>> getTypeArguments() {
            return this.typeArguments;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getQualifier());
            sb.append(" ");
            sb.append(this.getUnderlyingType());
            if (this.typeArguments.size() > 0) {
                sb.append("<").append(QualifiedTypeMirror.commaSeparatedList(this.typeArguments)).append(">");
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            QualifiedDeclaredType other = (QualifiedDeclaredType)obj;
            return this.typeArguments.equals(other.typeArguments);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.typeArguments.hashCode() * 43;
        }
    }

    public static final class QualifiedArrayType<Q>
    extends QualifiedTypeMirror<Q> {
        private final QualifiedTypeMirror<Q> componentType;

        public QualifiedArrayType(ExtendedTypeMirror underlying, Q qualifier, QualifiedTypeMirror<Q> componentType) {
            super(underlying, qualifier);
            QualifiedTypeMirror.checkUnderlyingKind(underlying, TypeKind.ARRAY);
            QualifiedTypeMirror.checkTypeMirrorsMatch("component", (QualifiedTypeMirror)componentType, this.getUnderlyingType().getComponentType());
            this.componentType = componentType;
        }

        @Override
        public <R, P> R accept(QualifiedTypeVisitor<Q, R, P> visitor, P p) {
            return visitor.visitArray(this, p);
        }

        @Override
        public ExtendedArrayType getUnderlyingType() {
            return (ExtendedArrayType)super.getUnderlyingType();
        }

        public QualifiedTypeMirror<Q> getComponentType() {
            return this.componentType;
        }

        public String toString() {
            return this.getComponentType() + " " + this.getQualifier() + " []";
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            QualifiedArrayType other = (QualifiedArrayType)obj;
            return this.componentType.equals(other.componentType);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.componentType.hashCode() * 43;
        }
    }
}

