/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.flow.util.LubTypeVariableAnnotator;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.SyntheticArrays;
import org.checkerframework.framework.type.visitor.SimpleAnnotatedTypeVisitor;
import org.checkerframework.framework.util.QualifierPolymorphism;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TypesUtils;

public class AnnotatedTypes {
    private static AsSuperTypeVisitor asSuper;
    private static Set<TypeMirror> wildcards;
    private static Map<TypeElement, Boolean> isTypeAnnotationCache;
    private static String annotationClassName;

    private AnnotatedTypes() {
        throw new AssertionError((Object)"Class AnnotatedTypes cannot be instantiated.");
    }

    public static AnnotatedTypeMirror asSuper(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, AnnotatedTypeMirror superType) {
        if (asSuper == null || asSuper.types != types || asSuper.atypeFactory != atypeFactory) {
            asSuper = new AsSuperTypeVisitor(types, atypeFactory);
        }
        AnnotatedTypeMirror result = (AnnotatedTypeMirror)asSuper.visit(t, superType);
        return result;
    }

    public static boolean hasNoExplicitBound(AnnotatedTypeMirror wildcard) {
        return ((Type.WildcardType)wildcard.getUnderlyingType()).isUnbound();
    }

    public static boolean hasExplicitSuperBound(AnnotatedTypeMirror wildcard) {
        Type.WildcardType wildcardType = (Type.WildcardType)wildcard.getUnderlyingType();
        return wildcardType.isSuperBound() && !((Type.WildcardType)wildcard.getUnderlyingType()).isUnbound();
    }

    public static boolean hasExplicitExtendsBound(AnnotatedTypeMirror wildcard) {
        Type.WildcardType wildcardType = (Type.WildcardType)wildcard.getUnderlyingType();
        return wildcardType.isExtendsBound() && !((Type.WildcardType)wildcard.getUnderlyingType()).isUnbound();
    }

    private static AnnotatedTypeMirror asOuterSuper(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, AnnotatedTypeMirror elem) {
        switch (t.getKind()) {
            case DECLARED: {
                AnnotatedTypeMirror.AnnotatedDeclaredType dt = (AnnotatedTypeMirror.AnnotatedDeclaredType)t;
                do {
                    AnnotatedTypeMirror s2;
                    if ((s2 = AnnotatedTypes.asSuper(types, atypeFactory, dt, elem)) == null) continue;
                    return s2;
                } while ((dt = dt.getEnclosingType()) != null);
                return null;
            }
            case ARRAY: 
            case TYPEVAR: 
            case WILDCARD: {
                return AnnotatedTypes.asSuper(types, atypeFactory, t, elem);
            }
        }
        return null;
    }

    private static boolean shouldStop(AnnotatedTypeMirror sup, AnnotatedTypeMirror sub) {
        if (sup.getKind().isPrimitive() && !sub.getKind().isPrimitive()) {
            return true;
        }
        if (sup.getKind().isPrimitive() && sub.getKind().isPrimitive()) {
            return sup.getKind() == sub.getKind();
        }
        if (sup.getKind() == TypeKind.DECLARED && sub.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType supdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)sup;
            AnnotatedTypeMirror.AnnotatedDeclaredType subdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)sub;
            return supdt.getUnderlyingType().asElement().equals(subdt.getUnderlyingType().asElement());
        }
        if (sup.getKind() == TypeKind.ARRAY && sub.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType supat = (AnnotatedTypeMirror.AnnotatedArrayType)sup;
            AnnotatedTypeMirror.AnnotatedArrayType subat = (AnnotatedTypeMirror.AnnotatedArrayType)sub;
            return AnnotatedTypes.shouldStop(supat.getComponentType(), subat.getComponentType());
        }
        return sup.getUnderlyingType().toString().equals(sub.getUnderlyingType().toString());
    }

    private static boolean isErased(Types types, AnnotatedTypeMirror t1, AnnotatedTypeMirror t2) {
        return types.isSameType(types.erasure(t1.getUnderlyingType()), t2.getUnderlyingType());
    }

    public static AnnotatedTypeMirror.AnnotatedExecutableType asMemberOf(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, ExecutableElement elem) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)AnnotatedTypes.asMemberOf(types, atypeFactory, t, (Element)elem);
    }

    public static AnnotatedTypeMirror asMemberOf(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, Element elem) {
        switch (elem.getKind()) {
            case PACKAGE: 
            case INSTANCE_INIT: 
            case OTHER: 
            case STATIC_INIT: 
            case TYPE_PARAMETER: {
                return atypeFactory.fromElement(elem);
            }
        }
        AnnotatedTypeMirror type = AnnotatedTypes.asMemberOfImpl(types, atypeFactory, t, elem);
        if (!ElementUtils.isStatic(elem)) {
            atypeFactory.postAsMemberOf(type, t, elem);
        }
        return type;
    }

    private static AnnotatedTypeMirror asMemberOfImpl(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, Element elem) {
        if (ElementUtils.isStatic(elem)) {
            return atypeFactory.getAnnotatedType(elem);
        }
        if (t.getKind() == TypeKind.TYPEVAR) {
            return AnnotatedTypes.asMemberOf(types, atypeFactory, ((AnnotatedTypeMirror.AnnotatedTypeVariable)t).getUpperBound(), elem);
        }
        if (t.getKind() == TypeKind.WILDCARD) {
            return AnnotatedTypes.asMemberOf(types, atypeFactory, ((AnnotatedTypeMirror.AnnotatedWildcardType)t).getExtendsBound().deepCopy(), elem);
        }
        if (SyntheticArrays.isArrayClone(t, elem)) {
            return SyntheticArrays.replaceReturnType(elem, (AnnotatedTypeMirror.AnnotatedArrayType)t);
        }
        AnnotatedTypeMirror elemType = atypeFactory.getAnnotatedType(elem);
        if (t.getKind() != TypeKind.DECLARED) {
            return elemType;
        }
        TypeElement owner = ElementUtils.enclosingClass(elem);
        boolean ownerGeneric = false;
        TypeElement encl = owner;
        while (encl != null) {
            if (!encl.getTypeParameters().isEmpty()) {
                ownerGeneric = true;
                break;
            }
            encl = ElementUtils.enclosingClass(encl.getEnclosingElement());
        }
        if (!ownerGeneric) {
            return elemType;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType ownerType = atypeFactory.getAnnotatedType(owner);
        AnnotatedTypeMirror.AnnotatedDeclaredType base = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asOuterSuper(types, atypeFactory, t, ownerType);
        if (base == null) {
            return elemType;
        }
        ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable> ownerParams = new ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable>(ownerType.getTypeArguments().size());
        for (AnnotatedTypeMirror typeParam : ownerType.getTypeArguments()) {
            if (typeParam.getKind() != TypeKind.TYPEVAR) {
                ErrorReporter.errorAbort("Type arguments of a declaration should be type variables\nowner=" + owner + "\n" + "ownerType=" + ownerType + "\n" + "typeMirror=" + t + "\n" + "element=" + elem);
            }
            ownerParams.add((AnnotatedTypeMirror.AnnotatedTypeVariable)typeParam);
        }
        List<AnnotatedTypeMirror> baseParams = base.getTypeArguments();
        if (!ownerParams.isEmpty()) {
            if (baseParams.isEmpty()) {
                ArrayList<AnnotatedTypeMirror> baseParamsEr = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror annotatedTypeMirror : ownerParams) {
                    baseParamsEr.add(annotatedTypeMirror.getErased());
                }
                return AnnotatedTypes.subst(atypeFactory, elemType, ownerParams, baseParamsEr);
            }
            return AnnotatedTypes.subst(atypeFactory, elemType, ownerParams, baseParams);
        }
        return elemType;
    }

    private static AnnotatedTypeMirror subst(AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, List<? extends AnnotatedTypeMirror.AnnotatedTypeVariable> from, List<? extends AnnotatedTypeMirror> to) {
        HashMap<TypeVariable, AnnotatedTypeMirror> mappings = new HashMap<TypeVariable, AnnotatedTypeMirror>();
        for (int i = 0; i < from.size(); ++i) {
            mappings.put(from.get(i).getUnderlyingType(), to.get(i));
        }
        return atypeFactory.getTypeVarSubstitutor().substitute(mappings, t);
    }

    public static AnnotatedTypeMirror getIteratedType(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror iterableType) {
        if (iterableType.getKind() == TypeKind.ARRAY) {
            return ((AnnotatedTypeMirror.AnnotatedArrayType)iterableType).getComponentType();
        }
        if (iterableType.getKind() == TypeKind.WILDCARD) {
            return AnnotatedTypes.getIteratedType(processingEnv, atypeFactory, ((AnnotatedTypeMirror.AnnotatedWildcardType)iterableType).getExtendsBound().deepCopy());
        }
        if (iterableType.getKind() == TypeKind.TYPEVAR) {
            return AnnotatedTypes.getIteratedType(processingEnv, atypeFactory, ((AnnotatedTypeMirror.AnnotatedTypeVariable)iterableType).getUpperBound());
        }
        if (iterableType.getKind() != TypeKind.DECLARED) {
            ErrorReporter.errorAbort("AnnotatedTypes.getIteratedType: not iterable type: " + iterableType);
            return null;
        }
        TypeElement iterableElement = processingEnv.getElementUtils().getTypeElement("java.lang.Iterable");
        AnnotatedTypeMirror.AnnotatedDeclaredType iterableElmType = atypeFactory.getAnnotatedType(iterableElement);
        AnnotatedTypeMirror.AnnotatedDeclaredType dt = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asSuper(processingEnv.getTypeUtils(), atypeFactory, iterableType, iterableElmType);
        if (dt == null) {
            ErrorReporter.errorAbort("AnnotatedTypes.getIteratedType: not an iterable type: " + iterableType);
            return null;
        }
        if (dt.getTypeArguments().isEmpty()) {
            TypeElement e = processingEnv.getElementUtils().getTypeElement("java.lang.Object");
            AnnotatedTypeMirror.AnnotatedDeclaredType t = atypeFactory.getAnnotatedType(e);
            return t;
        }
        return dt.getTypeArguments().get(0);
    }

    public static Set<AnnotatedTypeMirror.AnnotatedDeclaredType> getSuperTypes(AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        LinkedHashSet<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = new LinkedHashSet<AnnotatedTypeMirror.AnnotatedDeclaredType>();
        if (type == null) {
            return supertypes;
        }
        ArrayDeque<AnnotatedTypeMirror.AnnotatedDeclaredType> stack = new ArrayDeque<AnnotatedTypeMirror.AnnotatedDeclaredType>();
        stack.push(type);
        while (!stack.isEmpty()) {
            AnnotatedTypeMirror.AnnotatedDeclaredType current = (AnnotatedTypeMirror.AnnotatedDeclaredType)stack.pop();
            for (AnnotatedTypeMirror.AnnotatedDeclaredType supertype : current.directSuperTypes()) {
                if (supertypes.contains(supertype)) continue;
                stack.push(supertype);
                supertypes.add(supertype);
            }
        }
        return Collections.unmodifiableSet(supertypes);
    }

    public static Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods(Elements elements, AnnotatedTypeFactory atypeFactory, ExecutableElement method) {
        TypeElement elem = (TypeElement)method.getEnclosingElement();
        AnnotatedTypeMirror.AnnotatedDeclaredType type = atypeFactory.getAnnotatedType(elem);
        Set<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = AnnotatedTypes.getSuperTypes(type);
        return AnnotatedTypes.overriddenMethods(elements, method, supertypes);
    }

    public static Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods(Elements elements, ExecutableElement method, Collection<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes) {
        LinkedHashMap<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overrides = new LinkedHashMap<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement>();
        block0: for (AnnotatedTypeMirror.AnnotatedDeclaredType supertype : supertypes) {
            @Nullable TypeElement superElement = (TypeElement)supertype.getUnderlyingType().asElement();
            assert (superElement != null);
            for (ExecutableElement supermethod : ElementFilter.methodsIn(superElement.getEnclosedElements())) {
                if (!elements.overrides(method, supermethod, superElement)) continue;
                overrides.put(supertype, supermethod);
                continue block0;
            }
        }
        return Collections.unmodifiableMap(overrides);
    }

    public static Map<TypeVariable, AnnotatedTypeMirror> findTypeArguments(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, ExpressionTree expr, ExecutableElement elt, AnnotatedTypeMirror.AnnotatedExecutableType preType) {
        List<? extends Tree> targs;
        atypeFactory.getTypeArgumentInference().adaptMethodType(atypeFactory, expr, preType);
        if (elt.getTypeParameters().isEmpty()) {
            return Collections.emptyMap();
        }
        if (expr instanceof MethodInvocationTree) {
            targs = ((MethodInvocationTree)expr).getTypeArguments();
        } else if (expr instanceof NewClassTree) {
            targs = ((NewClassTree)expr).getTypeArguments();
        } else if (expr instanceof MemberReferenceTree) {
            targs = ((MemberReferenceTree)expr).getTypeArguments();
            if (targs == null) {
                return new HashMap<TypeVariable, AnnotatedTypeMirror>();
            }
        } else {
            ErrorReporter.errorAbort("AnnotatedTypes.findTypeArguments: unexpected tree: " + expr);
            return null;
        }
        if (!targs.isEmpty()) {
            List<AnnotatedTypeMirror.AnnotatedTypeVariable> tvars = preType.getTypeVariables();
            HashMap<TypeVariable, AnnotatedTypeMirror> typeArguments = new HashMap<TypeVariable, AnnotatedTypeMirror>();
            for (int i = 0; i < elt.getTypeParameters().size(); ++i) {
                AnnotatedTypeMirror.AnnotatedTypeVariable typeVar = tvars.get(i);
                AnnotatedTypeMirror typeArg = atypeFactory.getAnnotatedTypeFromTypeTree(targs.get(i));
                typeArguments.put(typeVar.getUnderlyingType(), typeArg);
            }
            return typeArguments;
        }
        return atypeFactory.getTypeArgumentInference().inferTypeArgs(atypeFactory, expr, elt, preType);
    }

    public static AnnotatedTypeMirror leastUpperBound(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror a, AnnotatedTypeMirror b) {
        ArrayList<AnnotatedTypeMirror> list = new ArrayList<AnnotatedTypeMirror>(2);
        list.add(a);
        list.add(b);
        TypeMirror lubType = InternalUtils.leastUpperBound(processingEnv, a.getUnderlyingType(), b.getUnderlyingType());
        AnnotatedTypeMirror res = AnnotatedTypeMirror.createType(lubType, atypeFactory, false);
        wildcards.clear();
        AnnotatedTypes.annotateAsLub(processingEnv, atypeFactory, res, list);
        wildcards.clear();
        return res;
    }

    public static void annotateAsLub(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror lub, Collection<AnnotatedTypeMirror> types) {
        Types typeutils = processingEnv.getTypeUtils();
        Elements elements = processingEnv.getElementUtils();
        if (lub.getKind() == TypeKind.INTERSECTION) {
            AnnotatedTypeMirror.AnnotatedIntersectionType adt = (AnnotatedTypeMirror.AnnotatedIntersectionType)lub;
            for (AnnotatedTypeMirror.AnnotatedDeclaredType adts : adt.directSuperTypes()) {
                ArrayList<AnnotatedTypeMirror> subtypes = new ArrayList<AnnotatedTypeMirror>(types.size());
                for (AnnotatedTypeMirror type : types) {
                    AnnotatedTypeMirror sup = AnnotatedTypes.asSuper(typeutils, atypeFactory, type, adts);
                    if (sup == null) continue;
                    subtypes.add(sup);
                }
                if (subtypes.size() > 0) {
                    adts.clearAnnotations();
                }
                AnnotatedTypes.addAnnotations(elements, atypeFactory, adts, subtypes);
                ArrayList<AnnotatedTypeMirror> adtslist = new ArrayList<AnnotatedTypeMirror>();
                adtslist.add(adts);
                AnnotatedTypes.addAnnotations(elements, atypeFactory, lub, adtslist);
            }
        } else {
            ArrayList<AnnotatedTypeMirror> subtypes = new ArrayList<AnnotatedTypeMirror>(types.size());
            if (lub.getKind() == TypeKind.WILDCARD) {
                subtypes.add(lub.deepCopy());
            } else {
                for (AnnotatedTypeMirror type : types) {
                    if (type == null) continue;
                    AnnotatedTypeMirror ass = AnnotatedTypes.asSuper(typeutils, atypeFactory, type, lub);
                    if (ass == null) {
                        subtypes.add(type.deepCopy());
                        continue;
                    }
                    subtypes.add(ass);
                }
            }
            if (subtypes.size() > 0 && !AnnotatedTypes.findEffectiveAnnotations(atypeFactory.getQualifierHierarchy(), lub).isEmpty()) {
                return;
            }
            if (lub.getKind() == TypeKind.TYPEVAR) {
                AnnotatedTypeMirror.AnnotatedTypeVariable lubAtv = (AnnotatedTypeMirror.AnnotatedTypeVariable)lub;
                List<AnnotatedTypeMirror.AnnotatedTypeVariable> subtypesAsTvs = LubTypeVariableAnnotator.getSubtypesAsTypevars(lubAtv, subtypes);
                if (subtypesAsTvs != null) {
                    LubTypeVariableAnnotator.annotateTypeVarAsLub(lubAtv, subtypesAsTvs, atypeFactory);
                } else {
                    AnnotatedTypes.addAnnotations(elements, atypeFactory, lub, subtypes);
                }
            } else {
                AnnotatedTypes.addAnnotations(elements, atypeFactory, lub, subtypes);
            }
        }
    }

    private static void addAnnotations(Elements elements, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror alub, ArrayList<AnnotatedTypeMirror> types) {
        Set<AnnotatedTypeMirror> visited = Collections.newSetFromMap(new IdentityHashMap());
        AnnotatedTypes.addAnnotationsImpl(elements, atypeFactory, alub, visited, types);
    }

    private static void addAnnotationsImpl(Elements elements, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror alub, Set<AnnotatedTypeMirror> visited, ArrayList<AnnotatedTypeMirror> types) {
        AnnotatedTypeMirror origalub = alub;
        boolean shouldAnnoOrig = false;
        Set<AnnotationMirror> putOnOrig = AnnotationUtils.createAnnotationSet();
        if (alub.getKind() == TypeKind.WILDCARD) {
            QualifierHierarchy qualifierHierarchy = atypeFactory.getQualifierHierarchy();
            Set<Object> lowerBounds = new HashSet(qualifierHierarchy.getTopAnnotations().size());
            for (AnnotatedTypeMirror type : types) {
                Set<AnnotationMirror> annos = AnnotatedTypes.findEffectiveLowerBoundAnnotations(qualifierHierarchy, type);
                if (lowerBounds.isEmpty()) {
                    lowerBounds = annos;
                    continue;
                }
                if (annos.isEmpty()) continue;
                lowerBounds = qualifierHierarchy.greatestLowerBounds(lowerBounds, annos);
            }
            ((AnnotatedTypeMirror.AnnotatedWildcardType)alub).getSuperBound().replaceAnnotations(lowerBounds);
            boolean allWildcards = true;
            for (int i = 0; i < types.size() && allWildcards; ++i) {
                if (types.get(i).getKind() == TypeKind.WILDCARD) continue;
                allWildcards = false;
            }
            if (allWildcards) {
                if (wildcards.contains(alub.getUnderlyingType())) {
                    return;
                }
                wildcards.add(alub.getUnderlyingType());
                ArrayList<AnnotatedTypeMirror> upperBounds = new ArrayList<AnnotatedTypeMirror>(types.size());
                for (AnnotatedTypeMirror type : types) {
                    upperBounds.add(((AnnotatedTypeMirror.AnnotatedWildcardType)type).getExtendsBound());
                }
                alub = ((AnnotatedTypeMirror.AnnotatedWildcardType)alub).getExtendsBound();
                AnnotatedTypes.annotateAsLub(atypeFactory.getProcessingEnv(), atypeFactory, alub, upperBounds);
                return;
            }
            alub = ((AnnotatedTypeMirror.AnnotatedWildcardType)alub).getExtendsBound();
        }
        while (alub.getKind() == TypeKind.TYPEVAR) {
            Set<? extends AnnotationMirror> glb = AnnotatedTypes.glbAll(atypeFactory.getQualifierHierarchy(), types);
            ((AnnotatedTypeMirror.AnnotatedTypeVariable)alub).getLowerBound().replaceAnnotations(glb);
            alub = ((AnnotatedTypeMirror.AnnotatedTypeVariable)alub).getUpperBound();
        }
        if (visited.contains(alub)) {
            return;
        }
        visited.add(alub);
        for (int i = 0; i < types.size(); ++i) {
            AnnotatedTypeMirror typei = types.get(i);
            if (!typei.getAnnotations().isEmpty() && !AnnotatedTypes.bottomsOnly(elements, atypeFactory, typei.getAnnotations())) {
                shouldAnnoOrig = true;
            }
            if (typei.getKind() == TypeKind.WILDCARD) {
                putOnOrig.addAll(typei.getAnnotations());
                AnnotatedTypeMirror.AnnotatedWildcardType wildcard = (AnnotatedTypeMirror.AnnotatedWildcardType)typei;
                if (wildcard.getExtendsBound() != null) {
                    types.set(i, wildcard.getExtendsBound().deepCopy());
                } else if (wildcard.getSuperBound() != null) {
                    types.set(i, wildcard.getSuperBound().deepCopy());
                }
            }
            if (typei.getKind() != TypeKind.TYPEVAR) continue;
            putOnOrig.addAll(typei.getAnnotations());
            AnnotatedTypeMirror.AnnotatedTypeVariable typevar = (AnnotatedTypeMirror.AnnotatedTypeVariable)types.get(i);
            if (typevar.getUpperBound() != null) {
                types.set(i, typevar.getUpperBound());
                continue;
            }
            if (typevar.getLowerBound() == null) continue;
            types.set(i, typevar.getLowerBound());
        }
        Set<Object> unification = Collections.emptySet();
        boolean isFirst = true;
        for (AnnotatedTypeMirror type : types) {
            if (type.getAnnotations().isEmpty()) continue;
            unification = isFirst ? type.getAnnotations() : atypeFactory.getQualifierHierarchy().leastUpperBounds(unification, type.getAnnotations());
            isFirst = false;
        }
        alub.replaceAnnotations(unification);
        if (alub.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType adt = (AnnotatedTypeMirror.AnnotatedDeclaredType)alub;
            for (int i = 0; i < adt.getTypeArguments().size(); ++i) {
                AnnotatedTypeMirror adtArg = adt.getTypeArguments().get(i);
                ArrayList<AnnotatedTypeMirror> dTypesArg = new ArrayList<AnnotatedTypeMirror>();
                for (int j = 0; j < types.size(); ++j) {
                    AnnotatedTypeMirror.AnnotatedDeclaredType adtypej;
                    if (types.get(j).getKind() != TypeKind.DECLARED || (adtypej = (AnnotatedTypeMirror.AnnotatedDeclaredType)types.get(j)).getTypeArguments().size() != adt.getTypeArguments().size()) continue;
                    dTypesArg.add(adtypej.getTypeArguments().get(i));
                }
                if (dTypesArg.isEmpty()) continue;
                AnnotatedTypes.addAnnotationsImpl(elements, atypeFactory, adtArg, visited, dTypesArg);
            }
        } else if (alub.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType aat = (AnnotatedTypeMirror.AnnotatedArrayType)alub;
            ArrayList<AnnotatedTypeMirror> compTypes = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror atype : types) {
                if (atype.getKind() != TypeKind.ARRAY) continue;
                compTypes.add(((AnnotatedTypeMirror.AnnotatedArrayType)atype).getComponentType());
            }
            if (aat.getComponentType().getKind() == TypeKind.TYPEVAR) {
                AnnotatedTypeMirror.AnnotatedTypeVariable lubAtv = (AnnotatedTypeMirror.AnnotatedTypeVariable)aat.getComponentType();
                List<AnnotatedTypeMirror.AnnotatedTypeVariable> subtypesAsTvs = LubTypeVariableAnnotator.getSubtypesAsTypevars(lubAtv, compTypes);
                if (subtypesAsTvs != null) {
                    LubTypeVariableAnnotator.annotateTypeVarAsLub(lubAtv, subtypesAsTvs, atypeFactory);
                } else {
                    AnnotatedTypes.addAnnotationsImpl(elements, atypeFactory, aat.getComponentType(), visited, compTypes);
                }
            } else {
                AnnotatedTypes.addAnnotationsImpl(elements, atypeFactory, aat.getComponentType(), visited, compTypes);
            }
        }
        if (alub != origalub && shouldAnnoOrig) {
            origalub.replaceAnnotations(putOnOrig);
        }
    }

    private static boolean bottomsOnly(Elements elements, AnnotatedTypeFactory atypeFactory, Set<AnnotationMirror> annotations) {
        Set<AnnotationMirror> bots = AnnotationUtils.createAnnotationSet();
        bots.addAll(atypeFactory.getQualifierHierarchy().getBottomAnnotations());
        for (AnnotationMirror am : annotations) {
            if (bots.remove(am)) continue;
            return false;
        }
        return true;
    }

    public static List<AnnotatedTypeMirror> expandVarArgs(AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror.AnnotatedExecutableType method, List<? extends ExpressionTree> args) {
        AnnotatedTypeMirror lastArg;
        List<AnnotatedTypeMirror> parameters = method.getParameterTypes();
        if (!method.getElement().isVarArgs()) {
            return parameters;
        }
        AnnotatedTypeMirror.AnnotatedArrayType varargs = (AnnotatedTypeMirror.AnnotatedArrayType)parameters.get(parameters.size() - 1);
        if (parameters.size() == args.size() && (lastArg = atypeFactory.getAnnotatedType(args.get(args.size() - 1))).getKind() == TypeKind.ARRAY && AnnotatedTypes.getArrayDepth(varargs) == AnnotatedTypes.getArrayDepth((AnnotatedTypeMirror.AnnotatedArrayType)lastArg)) {
            return parameters;
        }
        parameters = new ArrayList<AnnotatedTypeMirror>(parameters.subList(0, parameters.size() - 1));
        for (int i = args.size() - parameters.size(); i > 0; --i) {
            parameters.add(varargs.getComponentType());
        }
        return parameters;
    }

    public static List<AnnotatedTypeMirror> expandVarArgsFromTypes(AnnotatedTypeMirror.AnnotatedExecutableType method, List<AnnotatedTypeMirror> args) {
        AnnotatedTypeMirror lastArg;
        List<AnnotatedTypeMirror> parameters = method.getParameterTypes();
        if (!method.getElement().isVarArgs()) {
            return parameters;
        }
        AnnotatedTypeMirror.AnnotatedArrayType varargs = (AnnotatedTypeMirror.AnnotatedArrayType)parameters.get(parameters.size() - 1);
        if (parameters.size() == args.size() && (lastArg = args.get(args.size() - 1)).getKind() == TypeKind.ARRAY && AnnotatedTypes.getArrayDepth(varargs) == AnnotatedTypes.getArrayDepth((AnnotatedTypeMirror.AnnotatedArrayType)lastArg)) {
            return parameters;
        }
        parameters = new ArrayList<AnnotatedTypeMirror>(parameters.subList(0, parameters.size() - 1));
        for (int i = args.size() - parameters.size(); i > 0; --i) {
            parameters.add(varargs.getComponentType());
        }
        return parameters;
    }

    public static AnnotatedTypeMirror unwrapVarargs(List<AnnotatedTypeMirror> parameterTypes, int index) {
        AnnotatedTypeMirror.AnnotatedArrayType arrayType;
        Type.ArrayType underlyingType;
        boolean parameterBeforeVarargs;
        int lastIndex = parameterTypes.size() - 1;
        AnnotatedTypeMirror lastType = parameterTypes.get(lastIndex);
        boolean bl = parameterBeforeVarargs = index < lastIndex;
        if (!parameterBeforeVarargs && lastType instanceof AnnotatedTypeMirror.AnnotatedArrayType && (underlyingType = (Type.ArrayType)(arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)lastType).getUnderlyingType()).isVarargs()) {
            return arrayType.getComponentType();
        }
        return parameterTypes.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AnnotatedTypeMirror> getAnnotatedTypes(AnnotatedTypeFactory atypeFactory, List<AnnotatedTypeMirror> paramTypes, List<? extends ExpressionTree> trees) {
        assert (paramTypes.size() == trees.size()) : "AnnotatedTypes.getAnnotatedTypes: size mismatch! Parameter types: " + paramTypes + " Arguments: " + trees;
        ArrayList<AnnotatedTypeMirror> types = new ArrayList<AnnotatedTypeMirror>();
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = atypeFactory.getVisitorState().getAssignmentContext();
        try {
            for (int i = 0; i < trees.size(); ++i) {
                AnnotatedTypeMirror param = paramTypes.get(i);
                atypeFactory.getVisitorState().setAssignmentContext(Pair.of(null, param));
                ExpressionTree arg = trees.get(i);
                types.add(atypeFactory.getAnnotatedType(arg));
            }
        }
        finally {
            atypeFactory.getVisitorState().setAssignmentContext(preAssCtxt);
        }
        return types;
    }

    public static boolean areSame(AnnotatedTypeMirror t1, AnnotatedTypeMirror t2) {
        return t1.toString().equals(t2.toString());
    }

    public static int getArrayDepth(AnnotatedTypeMirror.AnnotatedArrayType array) {
        int counter = 0;
        AnnotatedTypeMirror type = array;
        while (type.getKind() == TypeKind.ARRAY) {
            ++counter;
            type = type.getComponentType();
        }
        return counter;
    }

    public static AnnotatedTypeMirror innerMostType(AnnotatedTypeMirror t) {
        AnnotatedTypeMirror inner = t;
        while (inner.getKind() == TypeKind.ARRAY) {
            inner = ((AnnotatedTypeMirror.AnnotatedArrayType)inner).getComponentType();
        }
        return inner;
    }

    public static boolean containsModifier(AnnotatedTypeMirror type, AnnotationMirror modifier) {
        return AnnotatedTypes.containsModifierImpl(type, modifier, new LinkedList<AnnotatedTypeMirror>());
    }

    private static boolean containsModifierImpl(AnnotatedTypeMirror type, AnnotationMirror modifier, List<AnnotatedTypeMirror> visited) {
        boolean found = type.hasAnnotation(modifier);
        boolean vis = visited.contains(type);
        visited.add(type);
        if (!found && !vis) {
            if (type.getKind() == TypeKind.DECLARED) {
                AnnotatedTypeMirror.AnnotatedDeclaredType declaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)type;
                for (AnnotatedTypeMirror typeMirror : declaredType.getTypeArguments()) {
                    if (found |= AnnotatedTypes.containsModifierImpl(typeMirror, modifier, visited)) break;
                }
            } else if (type.getKind() == TypeKind.ARRAY) {
                AnnotatedTypeMirror.AnnotatedArrayType arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)type;
                found = AnnotatedTypes.containsModifierImpl(arrayType.getComponentType(), modifier, visited);
            } else if (type.getKind() == TypeKind.TYPEVAR) {
                AnnotatedTypeMirror.AnnotatedTypeVariable atv = (AnnotatedTypeMirror.AnnotatedTypeVariable)type;
                if (atv.getUpperBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(atv.getUpperBound(), modifier, visited);
                }
                if (!found && atv.getLowerBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(atv.getLowerBound(), modifier, visited);
                }
            } else if (type.getKind() == TypeKind.WILDCARD) {
                AnnotatedTypeMirror.AnnotatedWildcardType awc = (AnnotatedTypeMirror.AnnotatedWildcardType)type;
                if (awc.getExtendsBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(awc.getExtendsBound(), modifier, visited);
                }
                if (!found && awc.getSuperBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(awc.getSuperBound(), modifier, visited);
                }
            }
        }
        return found;
    }

    public static boolean isTypeAnnotation(AnnotationMirror anno) {
        TypeElement elem = (TypeElement)anno.getAnnotationType().asElement();
        if (isTypeAnnotationCache.containsKey(elem)) {
            return isTypeAnnotationCache.get(elem);
        }
        boolean result = AnnotatedTypes.hasTypeQualifierElementTypes(elem.getAnnotation(Target.class).value());
        isTypeAnnotationCache.put(elem, result);
        return result;
    }

    public static boolean hasTypeQualifierElementTypes(ElementType[] elements) {
        boolean hasTypeUse = false;
        boolean hasOtherElementTypes = false;
        for (ElementType element : elements) {
            if (element.equals((Object)ElementType.TYPE_USE)) {
                hasTypeUse = true;
                continue;
            }
            if (element.equals((Object)ElementType.TYPE_PARAMETER)) continue;
            hasOtherElementTypes = true;
        }
        return hasTypeUse && !hasOtherElementTypes;
    }

    public static boolean containsTypeAnnotation(Collection<? extends AnnotationMirror> annos) {
        for (AnnotationMirror annotationMirror : annos) {
            if (!AnnotatedTypes.isTypeAnnotation(annotationMirror)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidType(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror type) {
        boolean res = AnnotatedTypes.isValidType(qualifierHierarchy, type, Collections.emptySet());
        return res;
    }

    private static boolean isValidType(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror type, Set<AnnotatedTypeMirror> v) {
        boolean canHaveEmptyAnnotationSet;
        if (type == null) {
            return false;
        }
        HashSet<AnnotatedTypeMirror> visited = new HashSet<AnnotatedTypeMirror>(v);
        if (visited.contains(type)) {
            return true;
        }
        visited.add(type);
        Set<AnnotationMirror> annotations = type.getAnnotations();
        Set<AnnotationMirror> seenTops = AnnotationUtils.createAnnotationSet();
        int n = 0;
        for (AnnotationMirror anno : annotations) {
            if (QualifierPolymorphism.isPolyAll(anno)) continue;
            ++n;
            AnnotationMirror top = qualifierHierarchy.getTopAnnotation(anno);
            if (seenTops.contains(top)) {
                return false;
            }
            seenTops.add(top);
        }
        int expectedN = qualifierHierarchy.getWidth();
        if (n > expectedN) {
            return false;
        }
        boolean hasPolyAll = type.hasAnnotation(PolyAll.class);
        boolean bl = canHaveEmptyAnnotationSet = QualifierHierarchy.canHaveEmptyAnnotationSet(type) || hasPolyAll;
        if (!canHaveEmptyAnnotationSet && n != expectedN) {
            return false;
        }
        if (type instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
            AnnotatedTypeMirror.AnnotatedArrayType at = (AnnotatedTypeMirror.AnnotatedArrayType)type;
            if (!AnnotatedTypes.isValidType(qualifierHierarchy, at.getComponentType(), visited)) {
                return false;
            }
        } else if (type instanceof AnnotatedTypeMirror.AnnotatedTypeVariable) {
            AnnotatedTypeMirror.AnnotatedTypeVariable at = (AnnotatedTypeMirror.AnnotatedTypeVariable)type;
            AnnotatedTypeMirror lowerBound = at.getLowerBound();
            AnnotatedTypeMirror upperBound = at.getUpperBound();
            if (lowerBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, lowerBound, visited)) {
                return false;
            }
            if (upperBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, upperBound, visited)) {
                return false;
            }
        } else if (type instanceof AnnotatedTypeMirror.AnnotatedWildcardType) {
            AnnotatedTypeMirror.AnnotatedWildcardType at = (AnnotatedTypeMirror.AnnotatedWildcardType)type;
            AnnotatedTypeMirror extendsBound = at.getExtendsBound();
            AnnotatedTypeMirror superBound = at.getSuperBound();
            if (extendsBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, extendsBound, visited)) {
                return false;
            }
            if (superBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, superBound, visited)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isJavaLangAnnotation(AnnotatedTypeMirror atm) {
        return TypesUtils.isDeclaredOfName(atm.getUnderlyingType(), annotationClassName);
    }

    public static boolean implementsAnnotation(AnnotatedTypeMirror atm) {
        if (atm.getKind() != TypeKind.DECLARED) {
            return false;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType declaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)atm;
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)declaredType.getUnderlyingType().asElement();
        for (Type iface : classSymbol.getInterfaces()) {
            if (!TypesUtils.isDeclaredOfName(iface, annotationClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnum(AnnotatedTypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType adt = (AnnotatedTypeMirror.AnnotatedDeclaredType)typeMirror;
            return TypesUtils.isDeclaredOfName(adt.getUnderlyingType(), Enum.class.getName());
        }
        return false;
    }

    public static boolean isDeclarationOfJavaLangEnum(Types types, Elements elements, AnnotatedTypeMirror typeMirror) {
        if (AnnotatedTypes.isEnum(typeMirror)) {
            return elements.getTypeElement("java.lang.Enum").equals(((AnnotatedTypeMirror.AnnotatedDeclaredType)typeMirror).getUnderlyingType().asElement());
        }
        return false;
    }

    public static boolean haveSameDeclaration(Types types, AnnotatedTypeMirror.AnnotatedTypeVariable typeVar1, AnnotatedTypeMirror.AnnotatedTypeVariable typeVar2) {
        return types.isSameType(typeVar1.getUnderlyingType(), typeVar2.getUnderlyingType());
    }

    public static boolean areCorrespondingTypeVariables(Elements elements, AnnotatedTypeMirror.AnnotatedTypeVariable type1, AnnotatedTypeMirror.AnnotatedTypeVariable type2) {
        TypeParameterElement type1ParamElem = (TypeParameterElement)type1.getUnderlyingType().asElement();
        TypeParameterElement type2ParamElem = (TypeParameterElement)type2.getUnderlyingType().asElement();
        if (type1ParamElem.getGenericElement() instanceof ExecutableElement && type2ParamElem.getGenericElement() instanceof ExecutableElement) {
            boolean methodIsOverriden;
            ExecutableElement type1Executable = (ExecutableElement)type1ParamElem.getGenericElement();
            ExecutableElement type2Executable = (ExecutableElement)type2ParamElem.getGenericElement();
            TypeElement type1Class = (TypeElement)type1Executable.getEnclosingElement();
            TypeElement type2Class = (TypeElement)type2Executable.getEnclosingElement();
            boolean bl = methodIsOverriden = elements.overrides(type1Executable, type2Executable, type1Class) || elements.overrides(type2Executable, type1Executable, type2Class);
            if (methodIsOverriden) {
                boolean haveSameIndex = type1Executable.getTypeParameters().indexOf(type1ParamElem) == type2Executable.getTypeParameters().indexOf(type2ParamElem);
                return haveSameIndex;
            }
        }
        return false;
    }

    public static AnnotationMirror findEffectiveAnnotationInHierarchy(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror toSearch, AnnotationMirror top) {
        return AnnotatedTypes.findEffectiveAnnotationInHierarchy(qualifierHierarchy, toSearch, top, false);
    }

    public static AnnotationMirror findEffectiveAnnotationInHierarchy(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror toSearch, AnnotationMirror top, boolean canBeEmpty) {
        AnnotatedTypeMirror source = toSearch;
        block5: while (source.getAnnotationInHierarchy(top) == null) {
            switch (source.getKind()) {
                case TYPEVAR: {
                    source = ((AnnotatedTypeMirror.AnnotatedTypeVariable)source).getUpperBound();
                    continue block5;
                }
                case WILDCARD: {
                    source = ((AnnotatedTypeMirror.AnnotatedWildcardType)source).getExtendsBound();
                    continue block5;
                }
                case INTERSECTION: {
                    AnnotationMirror glb = AnnotatedTypes.glbOfBoundsInHierarchy((AnnotatedTypeMirror.AnnotatedIntersectionType)source, top, qualifierHierarchy);
                    if (glb == null) {
                        ErrorReporter.errorAbort("AnnotatedIntersectionType has no annotation in hierarchy on any of its supertypes!\nintersectionType=" + source);
                    }
                    return glb;
                }
            }
            if (canBeEmpty) {
                return null;
            }
            ErrorReporter.errorAbort("Unexpected AnnotatedTypeMirror with no primary annotation!\ntoSearch=" + toSearch + "\n" + "top=" + top + "\n" + "source=" + source);
            return null;
        }
        return source.getAnnotationInHierarchy(top);
    }

    public static Set<AnnotationMirror> findEffectiveLowerBoundAnnotations(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror toSearch) {
        AnnotatedTypeMirror source = toSearch;
        TypeKind kind = source.getKind();
        while (kind == TypeKind.TYPEVAR || kind == TypeKind.WILDCARD || kind == TypeKind.INTERSECTION) {
            switch (source.getKind()) {
                case TYPEVAR: {
                    source = ((AnnotatedTypeMirror.AnnotatedTypeVariable)source).getLowerBound();
                    break;
                }
                case WILDCARD: {
                    source = ((AnnotatedTypeMirror.AnnotatedWildcardType)source).getSuperBound();
                    break;
                }
                case INTERSECTION: {
                    Set<AnnotationMirror> glb = AnnotatedTypes.glbOfBounds((AnnotatedTypeMirror.AnnotatedIntersectionType)source, qualifierHierarchy);
                    return glb;
                }
                default: {
                    ErrorReporter.errorAbort("Unexpected AnnotatedTypeMirror with no primary annotation!toSearch=" + toSearch + "source=" + source);
                }
            }
            kind = source.getKind();
        }
        return source.getAnnotations();
    }

    public static Set<AnnotationMirror> findEffectiveAnnotations(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror toSearch) {
        AnnotatedTypeMirror source = toSearch;
        TypeKind kind = source.getKind();
        while (kind == TypeKind.TYPEVAR || kind == TypeKind.WILDCARD || kind == TypeKind.INTERSECTION) {
            switch (source.getKind()) {
                case TYPEVAR: {
                    source = ((AnnotatedTypeMirror.AnnotatedTypeVariable)source).getUpperBound();
                    break;
                }
                case WILDCARD: {
                    source = ((AnnotatedTypeMirror.AnnotatedWildcardType)source).getExtendsBound();
                    break;
                }
                case INTERSECTION: {
                    Set<AnnotationMirror> glb = AnnotatedTypes.glbOfBounds((AnnotatedTypeMirror.AnnotatedIntersectionType)source, qualifierHierarchy);
                    return glb;
                }
                default: {
                    ErrorReporter.errorAbort("Unexpected AnnotatedTypeMirror with no primary annotation!toSearch=" + toSearch + "source=" + source);
                }
            }
            kind = source.getKind();
        }
        return source.getAnnotations();
    }

    private static Set<? extends AnnotationMirror> glbAll(QualifierHierarchy qualifierHierarchy, Collection<AnnotatedTypeMirror> types) {
        Set<AnnotationMirror> result = AnnotationUtils.createAnnotationSet();
        Map<AnnotationMirror, AnnotationMirror> intermediate = AnnotationUtils.createAnnotationMap();
        if (types.size() == 0) {
            return result;
        }
        Set<? extends AnnotationMirror> tops = qualifierHierarchy.getTopAnnotations();
        for (AnnotatedTypeMirror type : types) {
            for (AnnotationMirror annotationMirror : tops) {
                AnnotationMirror newAnno = type.getAnnotationInHierarchy(annotationMirror);
                AnnotationMirror prevGlb = (AnnotationMirror)intermediate.get(annotationMirror);
                if (newAnno == null) continue;
                if (prevGlb == null) {
                    intermediate.put(annotationMirror, newAnno);
                    continue;
                }
                intermediate.put(annotationMirror, qualifierHierarchy.greatestLowerBound(newAnno, prevGlb));
            }
        }
        result.addAll(intermediate.values());
        return result;
    }

    private static AnnotationMirror glbOfBoundsInHierarchy(AnnotatedTypeMirror.AnnotatedIntersectionType isect, AnnotationMirror top, QualifierHierarchy qualifierHierarchy) {
        AnnotationMirror anno = isect.getAnnotationInHierarchy(top);
        for (AnnotatedTypeMirror annotatedTypeMirror : isect.directSuperTypes()) {
            AnnotationMirror superAnno = annotatedTypeMirror.getAnnotationInHierarchy(top);
            if (superAnno == null || anno != null && !qualifierHierarchy.isSubtype(superAnno, anno)) continue;
            anno = superAnno;
        }
        return anno;
    }

    public static Set<AnnotationMirror> glbOfBounds(AnnotatedTypeMirror.AnnotatedIntersectionType isect, QualifierHierarchy qualifierHierarchy) {
        Set<AnnotationMirror> result = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror annotationMirror : qualifierHierarchy.getTopAnnotations()) {
            AnnotationMirror glbAnno = AnnotatedTypes.glbOfBoundsInHierarchy(isect, annotationMirror, qualifierHierarchy);
            if (glbAnno == null) continue;
            result.add(glbAnno);
        }
        return result;
    }

    public static boolean isExplicitlySuperBounded(AnnotatedTypeMirror.AnnotatedWildcardType wildcardType) {
        return ((Type.WildcardType)wildcardType.getUnderlyingType()).isSuperBound() && !((Type.WildcardType)wildcardType.getUnderlyingType()).isUnbound();
    }

    public static boolean isExplicitlyExtendsBounded(AnnotatedTypeMirror.AnnotatedWildcardType wildcardType) {
        return ((Type.WildcardType)wildcardType.getUnderlyingType()).isExtendsBound() && !((Type.WildcardType)wildcardType.getUnderlyingType()).isUnbound();
    }

    public static boolean isUnboundedOrSuperBounded(AnnotatedTypeMirror.AnnotatedWildcardType wildcardType) {
        return ((Type.WildcardType)wildcardType.getUnderlyingType()).isSuperBound();
    }

    public static boolean isUnboundedOrExtendsBounded(AnnotatedTypeMirror.AnnotatedWildcardType wildcardType) {
        return ((Type.WildcardType)wildcardType.getUnderlyingType()).isExtendsBound();
    }

    static {
        wildcards = Collections.newSetFromMap(new IdentityHashMap());
        isTypeAnnotationCache = new IdentityHashMap<TypeElement, Boolean>();
        annotationClassName = Annotation.class.getCanonicalName();
    }

    private static class AsSuperTypeVisitor
    extends SimpleAnnotatedTypeVisitor<AnnotatedTypeMirror, AnnotatedTypeMirror> {
        private final Types types;
        private final AnnotatedTypeFactory atypeFactory;

        AsSuperTypeVisitor(Types types, AnnotatedTypeFactory atypeFactory) {
            this.types = types;
            this.atypeFactory = atypeFactory;
        }

        @Override
        protected AnnotatedTypeMirror defaultAction(AnnotatedTypeMirror type, AnnotatedTypeMirror p) {
            return type;
        }

        @Override
        public AnnotatedTypeMirror visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, AnnotatedTypeMirror p) {
            if (!p.getKind().isPrimitive()) {
                return (AnnotatedTypeMirror)this.visit(this.atypeFactory.getBoxedType(type), p);
            }
            AnnotatedTypeMirror.AnnotatedPrimitiveType pt = (AnnotatedTypeMirror.AnnotatedPrimitiveType)p;
            AnnotatedTypeMirror.AnnotatedPrimitiveType st = pt.shallowCopy(false);
            st.addAnnotations(type.getAnnotations());
            return st;
        }

        @Override
        public AnnotatedTypeMirror visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror p) {
            if (p.getKind() == TypeKind.TYPEVAR) {
                return type;
            }
            AnnotatedTypeMirror res = AnnotatedTypes.asSuper(this.types, this.atypeFactory, type.getUpperBound(), p);
            if (res != null) {
                res.addMissingAnnotations(this.atypeFactory.getQualifierHierarchy().getTopAnnotations());
            }
            return res;
        }

        @Override
        public AnnotatedTypeMirror visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror p) {
            if (p.getKind() == TypeKind.WILDCARD) {
                return type;
            }
            return AnnotatedTypes.asSuper(this.types, this.atypeFactory, type.getExtendsBound(), p);
        }

        @Override
        public AnnotatedTypeMirror visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror p) {
            if (AnnotatedTypes.shouldStop(p, type)) {
                return type;
            }
            for (AnnotatedTypeMirror annotatedTypeMirror : type.directSuperTypes()) {
                AnnotatedTypeMirror x = AnnotatedTypes.asSuper(this.types, this.atypeFactory, annotatedTypeMirror, p);
                if (x == null) continue;
                return AnnotatedTypes.isErased(this.types, x, p) ? x.getErased() : x;
            }
            return null;
        }

        @Override
        public AnnotatedTypeMirror visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror p) {
            if (p.getKind().isPrimitive()) {
                if (TypesUtils.isBoxedPrimitive(type.getUnderlyingType())) {
                    return (AnnotatedTypeMirror)this.visit(this.atypeFactory.getUnboxedType(type), p);
                }
                return null;
            }
            if (AnnotatedTypes.shouldStop(p, type)) {
                return type;
            }
            for (AnnotatedTypeMirror.AnnotatedDeclaredType st : type.directSuperTypes()) {
                AnnotatedTypeMirror.AnnotatedDeclaredType x;
                if (st.getKind() != TypeKind.DECLARED || (x = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asSuper(this.types, this.atypeFactory, st, p)) == null) continue;
                return x;
            }
            if (p.getKind() == TypeKind.TYPEVAR) {
                return AnnotatedTypes.asSuper(this.types, this.atypeFactory, type, ((AnnotatedTypeMirror.AnnotatedTypeVariable)p).getUpperBound());
            }
            if (p.getKind() == TypeKind.WILDCARD) {
                return AnnotatedTypes.asSuper(this.types, this.atypeFactory, type, ((AnnotatedTypeMirror.AnnotatedWildcardType)p).getExtendsBound().deepCopy());
            }
            return null;
        }

        @Override
        public AnnotatedTypeMirror visitIntersection(AnnotatedTypeMirror.AnnotatedIntersectionType type, AnnotatedTypeMirror p) {
            if (AnnotatedTypes.shouldStop(p, type)) {
                return type;
            }
            for (AnnotatedTypeMirror.AnnotatedDeclaredType st : type.directSuperTypes()) {
                AnnotatedTypeMirror.AnnotatedDeclaredType x = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asSuper(this.types, this.atypeFactory, st, p);
                if (x == null) continue;
                return x;
            }
            return null;
        }
    }
}

