/*
 * Decompiled with CFR 0.152.
 */
package org.chartistjsf.model.chart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chartistjsf.model.chart.Axis;
import org.chartistjsf.model.chart.AxisType;
import org.chartistjsf.model.chart.ChartModel;
import org.chartistjsf.model.chart.ChartSeries;
import org.chartistjsf.model.chart.LinearAxis;

public class CartesianChartModel
extends ChartModel {
    private static final long serialVersionUID = 6182574506516748699L;
    private List<ChartSeries> series;
    protected Map<AxisType, Axis> axes;
    private int high;
    private int low;

    public CartesianChartModel() {
        this.series = new ArrayList<ChartSeries>();
        this.createAxes();
    }

    protected CartesianChartModel(CartesianChartModel cartesianChartModel) {
        super(cartesianChartModel);
        this.series = cartesianChartModel.series;
        this.axes = cartesianChartModel.axes;
        this.high = cartesianChartModel.high;
        this.low = cartesianChartModel.low;
    }

    protected void createAxes() {
        this.axes = new HashMap<AxisType, Axis>();
        this.axes.put(AxisType.X, new LinearAxis());
        this.axes.put(AxisType.Y, new LinearAxis());
    }

    public List<ChartSeries> getSeries() {
        return this.series;
    }

    public void addSeries(ChartSeries chartSeries) {
        this.series.add(chartSeries);
    }

    public void clear() {
        this.series.clear();
    }

    public Map<AxisType, Axis> getAxes() {
        return this.axes;
    }

    public Axis getAxis(AxisType type) {
        return this.axes.get((Object)type);
    }

    public int getHigh() {
        return this.high;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public int getLow() {
        return this.low;
    }

    public void setLow(int low) {
        this.low = low;
    }
}

