package org.cdk8s.plus20;

/**
 * A service account provides an identity for processes that run in a Pod.
 * <p>
 * When you (a human) access the cluster (for example, using kubectl), you are
 * authenticated by the apiserver as a particular User Account (currently this
 * is usually admin, unless your cluster administrator has customized your
 * cluster). Processes in containers inside pods can also contact the apiserver.
 * When they do, they are authenticated as a particular Service Account (for
 * example, default).
 * <p>
 * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.59.0 (build eb02c92)", date = "2022-05-18T23:02:53.497Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.ServiceAccount")
public class ServiceAccount extends org.cdk8s.plus20.Resource implements org.cdk8s.plus20.IServiceAccount, org.cdk8s.plus20.ISubject {

    protected ServiceAccount(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServiceAccount(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServiceAccount(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.ServiceAccountProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServiceAccount(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a service account from the cluster as a reference.
     * <p>
     * @param name The name of the service account resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IServiceAccount fromServiceAccountName(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus20.ServiceAccount.class, "fromServiceAccountName", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IServiceAccount.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Allow a secret to be accessed by pods using this service account.
     * <p>
     * @param secr The secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecret(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.ISecret secr) {
        software.amazon.jsii.Kernel.call(this, "addSecret", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(secr, "secr is required") });
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * Whether or not a token is automatically mounted for this service account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getAutomountToken() {
        return software.amazon.jsii.Kernel.get(this, "automountToken", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The name of a resource type as it appears in the relevant API endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * List of secrets allowed to be used by pods running using this service account.
     * <p>
     * Returns a copy. To add a secret, use <code>addSecret()</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.ISecret> getSecrets() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ISecret.class))));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus20.ServiceAccount}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus20.ServiceAccount> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus20.ServiceAccountProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * Indicates whether pods running as this service account should have an API token automatically mounted.
         * <p>
         * Can be overridden at the pod level.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
         * @param automountToken Indicates whether pods running as this service account should have an API token automatically mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automountToken(final java.lang.Boolean automountToken) {
            this.props().automountToken(automountToken);
            return this;
        }

        /**
         * List of secrets allowed to be used by pods running using this ServiceAccount.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/configuration/secret
         * @param secrets List of secrets allowed to be used by pods running using this ServiceAccount. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secrets(final java.util.List<? extends org.cdk8s.plus20.ISecret> secrets) {
            this.props().secrets(secrets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus20.ServiceAccount}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus20.ServiceAccount build() {
            return new org.cdk8s.plus20.ServiceAccount(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus20.ServiceAccountProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus20.ServiceAccountProps.Builder();
            }
            return this.props;
        }
    }
}
