/*
 * Decompiled with CFR 0.152.
 */
package org.cdk8s.plus20;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.cdk8s.plus20.$Module;
import org.cdk8s.plus20.ContainerProps;
import org.cdk8s.plus20.EnvValue;
import org.cdk8s.plus20.ImagePullPolicy;
import org.cdk8s.plus20.MountOptions;
import org.cdk8s.plus20.Probe;
import org.cdk8s.plus20.Volume;
import org.cdk8s.plus20.VolumeMount;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="cdk8s-plus-20.Container")
public class Container
extends JsiiObject {
    protected Container(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Container(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Container(@NotNull ContainerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addEnv(@NotNull String name, @NotNull EnvValue value) {
        Kernel.call((Object)((Object)this), (String)"addEnv", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(value, "value is required")});
    }

    public void mount(@NotNull String path, @NotNull Volume volume, @Nullable MountOptions options) {
        Kernel.call((Object)((Object)this), (String)"mount", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(volume, "volume is required"), options});
    }

    public void mount(@NotNull String path, @NotNull Volume volume) {
        Kernel.call((Object)((Object)this), (String)"mount", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(volume, "volume is required")});
    }

    @NotNull
    public Map<String, EnvValue> getEnv() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"env", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(EnvValue.class))));
    }

    @NotNull
    public String getImage() {
        return (String)Kernel.get((Object)((Object)this), (String)"image", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public ImagePullPolicy getImagePullPolicy() {
        return (ImagePullPolicy)((Object)Kernel.get((Object)((Object)this), (String)"imagePullPolicy", (NativeType)NativeType.forClass(ImagePullPolicy.class)));
    }

    @NotNull
    public List<VolumeMount> getMounts() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"mounts", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(VolumeMount.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public List<String> getArgs() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"args", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public List<String> getCommand() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"command", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public Number getPort() {
        return (Number)Kernel.get((Object)((Object)this), (String)"port", (NativeType)NativeType.forClass(Number.class));
    }

    @Nullable
    public String getWorkingDir() {
        return (String)Kernel.get((Object)((Object)this), (String)"workingDir", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Container> {
        private final ContainerProps.Builder props = new ContainerProps.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder image(String image) {
            this.props.image(image);
            return this;
        }

        public Builder args(List<String> args) {
            this.props.args(args);
            return this;
        }

        public Builder command(List<String> command) {
            this.props.command(command);
            return this;
        }

        public Builder env(Map<String, ? extends EnvValue> env) {
            this.props.env(env);
            return this;
        }

        public Builder imagePullPolicy(ImagePullPolicy imagePullPolicy) {
            this.props.imagePullPolicy(imagePullPolicy);
            return this;
        }

        public Builder liveness(Probe liveness) {
            this.props.liveness(liveness);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder readiness(Probe readiness) {
            this.props.readiness(readiness);
            return this;
        }

        public Builder startup(Probe startup) {
            this.props.startup(startup);
            return this;
        }

        public Builder volumeMounts(List<? extends VolumeMount> volumeMounts) {
            this.props.volumeMounts(volumeMounts);
            return this;
        }

        public Builder workingDir(String workingDir) {
            this.props.workingDir(workingDir);
            return this;
        }

        public Container build() {
            return new Container(this.props.build());
        }
    }
}

