package org.cdk8s.plus20;

/**
 * ConfigMap holds configuration data for pods to consume.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-03T09:09:28.003Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.ConfigMap")
public class ConfigMap extends org.cdk8s.plus20.Resource implements org.cdk8s.plus20.IConfigMap {

    protected ConfigMap(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConfigMap(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ConfigMap(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.ConfigMapProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ConfigMap(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Represents a ConfigMap created elsewhere.
     * <p>
     * @param name The name of the config map to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IConfigMap fromConfigMapName(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus20.ConfigMap.class, "fromConfigMapName", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IConfigMap.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Adds a binary data entry to the config map.
     * <p>
     * BinaryData can contain byte
     * sequences that are not in the UTF-8 range.
     * <p>
     * @param key The key. This parameter is required.
     * @param value The value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addBinaryData(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.call(this, "addBinaryData", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Adds a data entry to the config map.
     * <p>
     * @param key The key. This parameter is required.
     * @param value The value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addData(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.call(this, "addData", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Adds a directory to the ConfigMap.
     * <p>
     * @param localDir A path to a local directory. This parameter is required.
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDirectory(final @org.jetbrains.annotations.NotNull java.lang.String localDir, final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.AddDirectoryOptions options) {
        software.amazon.jsii.Kernel.call(this, "addDirectory", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(localDir, "localDir is required"), options });
    }

    /**
     * Adds a directory to the ConfigMap.
     * <p>
     * @param localDir A path to a local directory. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDirectory(final @org.jetbrains.annotations.NotNull java.lang.String localDir) {
        software.amazon.jsii.Kernel.call(this, "addDirectory", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(localDir, "localDir is required") });
    }

    /**
     * Adds a file to the ConfigMap.
     * <p>
     * @param localFile The path to the local file. This parameter is required.
     * @param key The ConfigMap key (default to the file name).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addFile(final @org.jetbrains.annotations.NotNull java.lang.String localFile, final @org.jetbrains.annotations.Nullable java.lang.String key) {
        software.amazon.jsii.Kernel.call(this, "addFile", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(localFile, "localFile is required"), key });
    }

    /**
     * Adds a file to the ConfigMap.
     * <p>
     * @param localFile The path to the local file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addFile(final @org.jetbrains.annotations.NotNull java.lang.String localFile) {
        software.amazon.jsii.Kernel.call(this, "addFile", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(localFile, "localFile is required") });
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * The binary data associated with this config map.
     * <p>
     * Returns a copy. To add data records, use <code>addBinaryData()</code> or <code>addData()</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getBinaryData() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "binaryData", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The data associated with this config map.
     * <p>
     * Returns an copy. To add data records, use <code>addData()</code> or <code>addBinaryData()</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getData() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "data", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus20.ConfigMap}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus20.ConfigMap> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus20.ConfigMapProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * BinaryData contains the binary data.
         * <p>
         * Each key must consist of alphanumeric characters, '-', '_' or '.'.
         * BinaryData can contain byte sequences that are not in the UTF-8 range. The
         * keys stored in BinaryData must not overlap with the ones in the Data field,
         * this is enforced during validation process. Using this field will require
         * 1.10+ apiserver and kubelet.
         * <p>
         * You can also add binary data using <code>configMap.addBinaryData()</code>.
         * <p>
         * @return {@code this}
         * @param binaryData BinaryData contains the binary data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder binaryData(final java.util.Map<java.lang.String, java.lang.String> binaryData) {
            this.props().binaryData(binaryData);
            return this;
        }

        /**
         * Data contains the configuration data.
         * <p>
         * Each key must consist of alphanumeric characters, '-', '_' or '.'. Values
         * with non-UTF-8 byte sequences must use the BinaryData field. The keys
         * stored in Data must not overlap with the keys in the BinaryData field, this
         * is enforced during validation process.
         * <p>
         * You can also add data using <code>configMap.addData()</code>.
         * <p>
         * @return {@code this}
         * @param data Data contains the configuration data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder data(final java.util.Map<java.lang.String, java.lang.String> data) {
            this.props().data(data);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus20.ConfigMap}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus20.ConfigMap build() {
            return new org.cdk8s.plus20.ConfigMap(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus20.ConfigMapProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus20.ConfigMapProps.Builder();
            }
            return this.props;
        }
    }
}
