package org.cdk8s.plus20;

/**
 * Options for mounts.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-24T02:12:24.258Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.MountOptions")
@software.amazon.jsii.Jsii.Proxy(MountOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MountOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Determines how mounts are propagated from the host to container and the other way around.
     * <p>
     * When not set, MountPropagationNone is used.
     * <p>
     * Mount propagation allows for sharing volumes mounted by a Container to
     * other Containers in the same Pod, or even to other Pods on the same node.
     * <p>
     * This field is beta in 1.10.
     * <p>
     * Default: MountPropagation.NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.MountPropagation getPropagation() {
        return null;
    }

    /**
     * Mounted read-only if true, read-write otherwise (false or unspecified).
     * <p>
     * Defaults to false.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReadOnly() {
        return null;
    }

    /**
     * Path within the volume from which the container's volume should be mounted.).
     * <p>
     * Default: "" the volume's root
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubPath() {
        return null;
    }

    /**
     * Expanded path within the volume from which the container's volume should be mounted.
     * <p>
     * Behaves similarly to SubPath but environment variable references
     * $(VAR_NAME) are expanded using the container's environment. Defaults to ""
     * (volume's root). SubPathExpr and SubPath are mutually exclusive. This field
     * is beta in 1.15.
     * <p>
     * <code>subPathExpr</code> and <code>subPath</code> are mutually exclusive. This field is beta in
     * 1.15.
     * <p>
     * Default: "" volume's root.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubPathExpr() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MountOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MountOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MountOptions> {
        private org.cdk8s.plus20.MountPropagation propagation;
        private java.lang.Boolean readOnly;
        private java.lang.String subPath;
        private java.lang.String subPathExpr;

        /**
         * Sets the value of {@link MountOptions#getPropagation}
         * @param propagation Determines how mounts are propagated from the host to container and the other way around.
         *                    When not set, MountPropagationNone is used.
         *                    <p>
         *                    Mount propagation allows for sharing volumes mounted by a Container to
         *                    other Containers in the same Pod, or even to other Pods on the same node.
         *                    <p>
         *                    This field is beta in 1.10.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagation(org.cdk8s.plus20.MountPropagation propagation) {
            this.propagation = propagation;
            return this;
        }

        /**
         * Sets the value of {@link MountOptions#getReadOnly}
         * @param readOnly Mounted read-only if true, read-write otherwise (false or unspecified).
         *                 Defaults to false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnly(java.lang.Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        /**
         * Sets the value of {@link MountOptions#getSubPath}
         * @param subPath Path within the volume from which the container's volume should be mounted.).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subPath(java.lang.String subPath) {
            this.subPath = subPath;
            return this;
        }

        /**
         * Sets the value of {@link MountOptions#getSubPathExpr}
         * @param subPathExpr Expanded path within the volume from which the container's volume should be mounted.
         *                    Behaves similarly to SubPath but environment variable references
         *                    $(VAR_NAME) are expanded using the container's environment. Defaults to ""
         *                    (volume's root). SubPathExpr and SubPath are mutually exclusive. This field
         *                    is beta in 1.15.
         *                    <p>
         *                    <code>subPathExpr</code> and <code>subPath</code> are mutually exclusive. This field is beta in
         *                    1.15.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subPathExpr(java.lang.String subPathExpr) {
            this.subPathExpr = subPathExpr;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MountOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MountOptions build() {
            return new Jsii$Proxy(propagation, readOnly, subPath, subPathExpr);
        }
    }

    /**
     * An implementation for {@link MountOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MountOptions {
        private final org.cdk8s.plus20.MountPropagation propagation;
        private final java.lang.Boolean readOnly;
        private final java.lang.String subPath;
        private final java.lang.String subPathExpr;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.propagation = software.amazon.jsii.Kernel.get(this, "propagation", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.MountPropagation.class));
            this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.subPath = software.amazon.jsii.Kernel.get(this, "subPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subPathExpr = software.amazon.jsii.Kernel.get(this, "subPathExpr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final org.cdk8s.plus20.MountPropagation propagation, final java.lang.Boolean readOnly, final java.lang.String subPath, final java.lang.String subPathExpr) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.propagation = propagation;
            this.readOnly = readOnly;
            this.subPath = subPath;
            this.subPathExpr = subPathExpr;
        }

        @Override
        public final org.cdk8s.plus20.MountPropagation getPropagation() {
            return this.propagation;
        }

        @Override
        public final java.lang.Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public final java.lang.String getSubPath() {
            return this.subPath;
        }

        @Override
        public final java.lang.String getSubPathExpr() {
            return this.subPathExpr;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPropagation() != null) {
                data.set("propagation", om.valueToTree(this.getPropagation()));
            }
            if (this.getReadOnly() != null) {
                data.set("readOnly", om.valueToTree(this.getReadOnly()));
            }
            if (this.getSubPath() != null) {
                data.set("subPath", om.valueToTree(this.getSubPath()));
            }
            if (this.getSubPathExpr() != null) {
                data.set("subPathExpr", om.valueToTree(this.getSubPathExpr()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.MountOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MountOptions.Jsii$Proxy that = (MountOptions.Jsii$Proxy) o;

            if (this.propagation != null ? !this.propagation.equals(that.propagation) : that.propagation != null) return false;
            if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
            if (this.subPath != null ? !this.subPath.equals(that.subPath) : that.subPath != null) return false;
            return this.subPathExpr != null ? this.subPathExpr.equals(that.subPathExpr) : that.subPathExpr == null;
        }

        @Override
        public final int hashCode() {
            int result = this.propagation != null ? this.propagation.hashCode() : 0;
            result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
            result = 31 * result + (this.subPath != null ? this.subPath.hashCode() : 0);
            result = 31 * result + (this.subPathExpr != null ? this.subPathExpr.hashCode() : 0);
            return result;
        }
    }
}
