package org.cdk8s.plus20;

/**
 * Options for exposing a deployment via a service.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-24T02:12:24.247Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.ExposeOptions")
@software.amazon.jsii.Jsii.Proxy(ExposeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExposeOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the service to expose.
     * <p>
     * This will be set on the Service.metadata and must be a DNS_LABEL
     * <p>
     * Default: undefined Uses the system generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The IP protocol for this port.
     * <p>
     * Supports "TCP", "UDP", and "SCTP". Default is TCP.
     * <p>
     * Default: Protocol.TCP
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.Protocol getProtocol() {
        return null;
    }

    /**
     * The type of the exposed service.
     * <p>
     * Default: - ClusterIP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.ServiceType getServiceType() {
        return null;
    }

    /**
     * The port number the service will redirect to.
     * <p>
     * Default: - The port of the first container in the deployment (ie. containers[0].port)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTargetPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ExposeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExposeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExposeOptions> {
        private java.lang.String name;
        private org.cdk8s.plus20.Protocol protocol;
        private org.cdk8s.plus20.ServiceType serviceType;
        private java.lang.Number targetPort;

        /**
         * Sets the value of {@link ExposeOptions#getName}
         * @param name The name of the service to expose.
         *             This will be set on the Service.metadata and must be a DNS_LABEL
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ExposeOptions#getProtocol}
         * @param protocol The IP protocol for this port.
         *                 Supports "TCP", "UDP", and "SCTP". Default is TCP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(org.cdk8s.plus20.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link ExposeOptions#getServiceType}
         * @param serviceType The type of the exposed service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceType(org.cdk8s.plus20.ServiceType serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        /**
         * Sets the value of {@link ExposeOptions#getTargetPort}
         * @param targetPort The port number the service will redirect to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetPort(java.lang.Number targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExposeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExposeOptions build() {
            return new Jsii$Proxy(name, protocol, serviceType, targetPort);
        }
    }

    /**
     * An implementation for {@link ExposeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExposeOptions {
        private final java.lang.String name;
        private final org.cdk8s.plus20.Protocol protocol;
        private final org.cdk8s.plus20.ServiceType serviceType;
        private final java.lang.Number targetPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Protocol.class));
            this.serviceType = software.amazon.jsii.Kernel.get(this, "serviceType", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ServiceType.class));
            this.targetPort = software.amazon.jsii.Kernel.get(this, "targetPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String name, final org.cdk8s.plus20.Protocol protocol, final org.cdk8s.plus20.ServiceType serviceType, final java.lang.Number targetPort) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = name;
            this.protocol = protocol;
            this.serviceType = serviceType;
            this.targetPort = targetPort;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final org.cdk8s.plus20.Protocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final org.cdk8s.plus20.ServiceType getServiceType() {
            return this.serviceType;
        }

        @Override
        public final java.lang.Number getTargetPort() {
            return this.targetPort;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getServiceType() != null) {
                data.set("serviceType", om.valueToTree(this.getServiceType()));
            }
            if (this.getTargetPort() != null) {
                data.set("targetPort", om.valueToTree(this.getTargetPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.ExposeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExposeOptions.Jsii$Proxy that = (ExposeOptions.Jsii$Proxy) o;

            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.serviceType != null ? !this.serviceType.equals(that.serviceType) : that.serviceType != null) return false;
            return this.targetPort != null ? this.targetPort.equals(that.targetPort) : that.targetPort == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.serviceType != null ? this.serviceType.hashCode() : 0);
            result = 31 * result + (this.targetPort != null ? this.targetPort.hashCode() : 0);
            return result;
        }
    }
}
