package org.cdk8s.plus20;

/**
 * Mount a volume from the pod to the container.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-07T00:21:18.787Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.VolumeMount")
@software.amazon.jsii.Jsii.Proxy(VolumeMount.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VolumeMount extends software.amazon.jsii.JsiiSerializable, org.cdk8s.plus20.MountOptions {

    /**
     * Path within the container at which the volume should be mounted.
     * <p>
     * Must not
     * contain ':'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPath();

    /**
     * The volume to mount.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Volume getVolume();

    /**
     * @return a {@link Builder} of {@link VolumeMount}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VolumeMount}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VolumeMount> {
        java.lang.String path;
        org.cdk8s.plus20.Volume volume;
        org.cdk8s.plus20.MountPropagation propagation;
        java.lang.Boolean readOnly;
        java.lang.String subPath;
        java.lang.String subPathExpr;

        /**
         * Sets the value of {@link VolumeMount#getPath}
         * @param path Path within the container at which the volume should be mounted. This parameter is required.
         *             Must not
         *             contain ':'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link VolumeMount#getVolume}
         * @param volume The volume to mount. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volume(org.cdk8s.plus20.Volume volume) {
            this.volume = volume;
            return this;
        }

        /**
         * Sets the value of {@link VolumeMount#getPropagation}
         * @param propagation Determines how mounts are propagated from the host to container and the other way around.
         *                    When not set, MountPropagationNone is used.
         *                    <p>
         *                    Mount propagation allows for sharing volumes mounted by a Container to
         *                    other Containers in the same Pod, or even to other Pods on the same node.
         *                    <p>
         *                    This field is beta in 1.10.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagation(org.cdk8s.plus20.MountPropagation propagation) {
            this.propagation = propagation;
            return this;
        }

        /**
         * Sets the value of {@link VolumeMount#getReadOnly}
         * @param readOnly Mounted read-only if true, read-write otherwise (false or unspecified).
         *                 Defaults to false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnly(java.lang.Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        /**
         * Sets the value of {@link VolumeMount#getSubPath}
         * @param subPath Path within the volume from which the container's volume should be mounted.).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subPath(java.lang.String subPath) {
            this.subPath = subPath;
            return this;
        }

        /**
         * Sets the value of {@link VolumeMount#getSubPathExpr}
         * @param subPathExpr Expanded path within the volume from which the container's volume should be mounted.
         *                    Behaves similarly to SubPath but environment variable references
         *                    $(VAR_NAME) are expanded using the container's environment. Defaults to ""
         *                    (volume's root). SubPathExpr and SubPath are mutually exclusive. This field
         *                    is beta in 1.15.
         *                    <p>
         *                    <code>subPathExpr</code> and <code>subPath</code> are mutually exclusive. This field is beta in
         *                    1.15.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subPathExpr(java.lang.String subPathExpr) {
            this.subPathExpr = subPathExpr;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VolumeMount}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VolumeMount build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VolumeMount}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeMount {
        private final java.lang.String path;
        private final org.cdk8s.plus20.Volume volume;
        private final org.cdk8s.plus20.MountPropagation propagation;
        private final java.lang.Boolean readOnly;
        private final java.lang.String subPath;
        private final java.lang.String subPathExpr;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volume = software.amazon.jsii.Kernel.get(this, "volume", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Volume.class));
            this.propagation = software.amazon.jsii.Kernel.get(this, "propagation", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.MountPropagation.class));
            this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.subPath = software.amazon.jsii.Kernel.get(this, "subPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subPathExpr = software.amazon.jsii.Kernel.get(this, "subPathExpr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
            this.volume = java.util.Objects.requireNonNull(builder.volume, "volume is required");
            this.propagation = builder.propagation;
            this.readOnly = builder.readOnly;
            this.subPath = builder.subPath;
            this.subPathExpr = builder.subPathExpr;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final org.cdk8s.plus20.Volume getVolume() {
            return this.volume;
        }

        @Override
        public final org.cdk8s.plus20.MountPropagation getPropagation() {
            return this.propagation;
        }

        @Override
        public final java.lang.Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public final java.lang.String getSubPath() {
            return this.subPath;
        }

        @Override
        public final java.lang.String getSubPathExpr() {
            return this.subPathExpr;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("path", om.valueToTree(this.getPath()));
            data.set("volume", om.valueToTree(this.getVolume()));
            if (this.getPropagation() != null) {
                data.set("propagation", om.valueToTree(this.getPropagation()));
            }
            if (this.getReadOnly() != null) {
                data.set("readOnly", om.valueToTree(this.getReadOnly()));
            }
            if (this.getSubPath() != null) {
                data.set("subPath", om.valueToTree(this.getSubPath()));
            }
            if (this.getSubPathExpr() != null) {
                data.set("subPathExpr", om.valueToTree(this.getSubPathExpr()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.VolumeMount"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VolumeMount.Jsii$Proxy that = (VolumeMount.Jsii$Proxy) o;

            if (!path.equals(that.path)) return false;
            if (!volume.equals(that.volume)) return false;
            if (this.propagation != null ? !this.propagation.equals(that.propagation) : that.propagation != null) return false;
            if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
            if (this.subPath != null ? !this.subPath.equals(that.subPath) : that.subPath != null) return false;
            return this.subPathExpr != null ? this.subPathExpr.equals(that.subPathExpr) : that.subPathExpr == null;
        }

        @Override
        public final int hashCode() {
            int result = this.path.hashCode();
            result = 31 * result + (this.volume.hashCode());
            result = 31 * result + (this.propagation != null ? this.propagation.hashCode() : 0);
            result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
            result = 31 * result + (this.subPath != null ? this.subPath.hashCode() : 0);
            result = 31 * result + (this.subPathExpr != null ? this.subPathExpr.hashCode() : 0);
            return result;
        }
    }
}
