package org.cdk8s.plus20;

/**
 * Properties for `Ingress`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.46.0 (build cd08c55)", date = "2021-12-02T00:21:53.010Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.IngressV1Beta1Props")
@software.amazon.jsii.Jsii.Proxy(IngressV1Beta1Props.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IngressV1Beta1Props extends software.amazon.jsii.JsiiSerializable, org.cdk8s.plus20.ResourceProps {

    /**
     * The default backend services requests that do not match any rule.
     * <p>
     * Using this option or the <code>addDefaultBackend()</code> method is equivalent to
     * adding a rule with both <code>path</code> and <code>host</code> undefined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.IngressV1Beta1Backend getDefaultBackend() {
        return null;
    }

    /**
     * Routing rules for this ingress.
     * <p>
     * Each rule must define an <code>IngressBackend</code> that will receive the requests
     * that match this rule. If both <code>host</code> and <code>path</code> are not specifiec, this
     * backend will be used as the default backend of the ingress.
     * <p>
     * You can also add rules later using <code>addRule()</code>, <code>addHostRule()</code>,
     * <code>addDefaultBackend()</code> and <code>addHostDefaultBackend()</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus20.IngressV1Beta1Rule> getRules() {
        return null;
    }

    /**
     * TLS settings for this ingress.
     * <p>
     * Using this option tells the ingress controller to expose a TLS endpoint.
     * Currently the Ingress only supports a single TLS port, 443. If multiple
     * members of this list specify different hosts, they will be multiplexed on
     * the same port according to the hostname specified through the SNI TLS
     * extension, if the ingress controller fulfilling the ingress supports SNI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus20.IngressV1Beta1Tls> getTls() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IngressV1Beta1Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IngressV1Beta1Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IngressV1Beta1Props> {
        org.cdk8s.plus20.IngressV1Beta1Backend defaultBackend;
        java.util.List<org.cdk8s.plus20.IngressV1Beta1Rule> rules;
        java.util.List<org.cdk8s.plus20.IngressV1Beta1Tls> tls;
        org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Sets the value of {@link IngressV1Beta1Props#getDefaultBackend}
         * @param defaultBackend The default backend services requests that do not match any rule.
         *                       Using this option or the <code>addDefaultBackend()</code> method is equivalent to
         *                       adding a rule with both <code>path</code> and <code>host</code> undefined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultBackend(org.cdk8s.plus20.IngressV1Beta1Backend defaultBackend) {
            this.defaultBackend = defaultBackend;
            return this;
        }

        /**
         * Sets the value of {@link IngressV1Beta1Props#getRules}
         * @param rules Routing rules for this ingress.
         *              Each rule must define an <code>IngressBackend</code> that will receive the requests
         *              that match this rule. If both <code>host</code> and <code>path</code> are not specifiec, this
         *              backend will be used as the default backend of the ingress.
         *              <p>
         *              You can also add rules later using <code>addRule()</code>, <code>addHostRule()</code>,
         *              <code>addDefaultBackend()</code> and <code>addHostDefaultBackend()</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder rules(java.util.List<? extends org.cdk8s.plus20.IngressV1Beta1Rule> rules) {
            this.rules = (java.util.List<org.cdk8s.plus20.IngressV1Beta1Rule>)rules;
            return this;
        }

        /**
         * Sets the value of {@link IngressV1Beta1Props#getTls}
         * @param tls TLS settings for this ingress.
         *            Using this option tells the ingress controller to expose a TLS endpoint.
         *            Currently the Ingress only supports a single TLS port, 443. If multiple
         *            members of this list specify different hosts, they will be multiplexed on
         *            the same port according to the hostname specified through the SNI TLS
         *            extension, if the ingress controller fulfilling the ingress supports SNI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tls(java.util.List<? extends org.cdk8s.plus20.IngressV1Beta1Tls> tls) {
            this.tls = (java.util.List<org.cdk8s.plus20.IngressV1Beta1Tls>)tls;
            return this;
        }

        /**
         * Sets the value of {@link IngressV1Beta1Props#getMetadata}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(org.cdk8s.ApiObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IngressV1Beta1Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IngressV1Beta1Props build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IngressV1Beta1Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressV1Beta1Props {
        private final org.cdk8s.plus20.IngressV1Beta1Backend defaultBackend;
        private final java.util.List<org.cdk8s.plus20.IngressV1Beta1Rule> rules;
        private final java.util.List<org.cdk8s.plus20.IngressV1Beta1Tls> tls;
        private final org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultBackend = software.amazon.jsii.Kernel.get(this, "defaultBackend", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IngressV1Beta1Backend.class));
            this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IngressV1Beta1Rule.class)));
            this.tls = software.amazon.jsii.Kernel.get(this, "tls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IngressV1Beta1Tls.class)));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadata.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultBackend = builder.defaultBackend;
            this.rules = (java.util.List<org.cdk8s.plus20.IngressV1Beta1Rule>)builder.rules;
            this.tls = (java.util.List<org.cdk8s.plus20.IngressV1Beta1Tls>)builder.tls;
            this.metadata = builder.metadata;
        }

        @Override
        public final org.cdk8s.plus20.IngressV1Beta1Backend getDefaultBackend() {
            return this.defaultBackend;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.IngressV1Beta1Rule> getRules() {
            return this.rules;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.IngressV1Beta1Tls> getTls() {
            return this.tls;
        }

        @Override
        public final org.cdk8s.ApiObjectMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDefaultBackend() != null) {
                data.set("defaultBackend", om.valueToTree(this.getDefaultBackend()));
            }
            if (this.getRules() != null) {
                data.set("rules", om.valueToTree(this.getRules()));
            }
            if (this.getTls() != null) {
                data.set("tls", om.valueToTree(this.getTls()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.IngressV1Beta1Props"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IngressV1Beta1Props.Jsii$Proxy that = (IngressV1Beta1Props.Jsii$Proxy) o;

            if (this.defaultBackend != null ? !this.defaultBackend.equals(that.defaultBackend) : that.defaultBackend != null) return false;
            if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) return false;
            if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) return false;
            return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultBackend != null ? this.defaultBackend.hashCode() : 0;
            result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
            result = 31 * result + (this.tls != null ? this.tls.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            return result;
        }
    }
}
