package org.cdk8s.plus20;

/**
 * Represents the rules mapping the paths under a specified host to the related backend services.
 * <p>
 * Incoming requests are first evaluated for a host match,
 * then routed to the backend associated with the matching path.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.46.0 (build cd08c55)", date = "2021-11-26T00:21:50.387Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.IngressV1Beta1Rule")
@software.amazon.jsii.Jsii.Proxy(IngressV1Beta1Rule.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IngressV1Beta1Rule extends software.amazon.jsii.JsiiSerializable {

    /**
     * Backend defines the referenced service endpoint to which the traffic will be forwarded to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IngressV1Beta1Backend getBackend();

    /**
     * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
     * <p>
     * Note the following deviations from the "host" part of the URI as
     * defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue
     * can only apply to the IP in the Spec of the parent Ingress. 2. The <code>:</code>
     * delimiter is not respected because ports are not allowed. Currently the
     * port of an Ingress is implicitly :80 for http and :443 for https. Both
     * these may change in the future. Incoming requests are matched against the
     * host before the IngressRuleValue.
     * <p>
     * Default: - If the host is unspecified, the Ingress routes all traffic based
     * on the specified IngressRuleValue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHost() {
        return null;
    }

    /**
     * Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'.
     * <p>
     * Default: - If unspecified, the path defaults to a catch all sending traffic
     * to the backend.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IngressV1Beta1Rule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IngressV1Beta1Rule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IngressV1Beta1Rule> {
        org.cdk8s.plus20.IngressV1Beta1Backend backend;
        java.lang.String host;
        java.lang.String path;

        /**
         * Sets the value of {@link IngressV1Beta1Rule#getBackend}
         * @param backend Backend defines the referenced service endpoint to which the traffic will be forwarded to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backend(org.cdk8s.plus20.IngressV1Beta1Backend backend) {
            this.backend = backend;
            return this;
        }

        /**
         * Sets the value of {@link IngressV1Beta1Rule#getHost}
         * @param host Host is the fully qualified domain name of a network host, as defined by RFC 3986.
         *             Note the following deviations from the "host" part of the URI as
         *             defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue
         *             can only apply to the IP in the Spec of the parent Ingress. 2. The <code>:</code>
         *             delimiter is not respected because ports are not allowed. Currently the
         *             port of an Ingress is implicitly :80 for http and :443 for https. Both
         *             these may change in the future. Incoming requests are matched against the
         *             host before the IngressRuleValue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder host(java.lang.String host) {
            this.host = host;
            return this;
        }

        /**
         * Sets the value of {@link IngressV1Beta1Rule#getPath}
         * @param path Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IngressV1Beta1Rule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IngressV1Beta1Rule build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IngressV1Beta1Rule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressV1Beta1Rule {
        private final org.cdk8s.plus20.IngressV1Beta1Backend backend;
        private final java.lang.String host;
        private final java.lang.String path;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backend = software.amazon.jsii.Kernel.get(this, "backend", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IngressV1Beta1Backend.class));
            this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backend = java.util.Objects.requireNonNull(builder.backend, "backend is required");
            this.host = builder.host;
            this.path = builder.path;
        }

        @Override
        public final org.cdk8s.plus20.IngressV1Beta1Backend getBackend() {
            return this.backend;
        }

        @Override
        public final java.lang.String getHost() {
            return this.host;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("backend", om.valueToTree(this.getBackend()));
            if (this.getHost() != null) {
                data.set("host", om.valueToTree(this.getHost()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.IngressV1Beta1Rule"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IngressV1Beta1Rule.Jsii$Proxy that = (IngressV1Beta1Rule.Jsii$Proxy) o;

            if (!backend.equals(that.backend)) return false;
            if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
            return this.path != null ? this.path.equals(that.path) : that.path == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backend.hashCode();
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }
    }
}
