package org.cdk8s.plus20;

/**
 * A single application container that you want to run within a pod.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.44.1 (build 8a27521)", date = "2021-11-17T00:19:54.582Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.Container")
public class Container extends software.amazon.jsii.JsiiObject {

    protected Container(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Container(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Container(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.ContainerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add an environment value to the container.
     * <p>
     * The variable value can come
     * from various dynamic sources such a secrets of config maps.
     * <p>
     * @see EnvValue.fromXXX
     * @param name - The variable name. This parameter is required.
     * @param value - The variable value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEnv(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.EnvValue value) {
        software.amazon.jsii.Kernel.call(this, "addEnv", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Mount a volume to a specific path so that it is accessible by the container.
     * <p>
     * Every pod that is configured to use this container will autmoatically have access to the volume.
     * <p>
     * @param path - The desired path in the container. This parameter is required.
     * @param volume - The volume to mount. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void mount(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Volume volume, final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.MountOptions options) {
        software.amazon.jsii.Kernel.call(this, "mount", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(volume, "volume is required"), options });
    }

    /**
     * Mount a volume to a specific path so that it is accessible by the container.
     * <p>
     * Every pod that is configured to use this container will autmoatically have access to the volume.
     * <p>
     * @param path - The desired path in the container. This parameter is required.
     * @param volume - The volume to mount. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void mount(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Volume volume) {
        software.amazon.jsii.Kernel.call(this, "mount", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(volume, "volume is required") });
    }

    /**
     * The environment variables for this container.
     * <p>
     * Returns a copy. To add environment variables use <code>addEnv()</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, org.cdk8s.plus20.EnvValue> getEnv() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.EnvValue.class))));
    }

    /**
     * The container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImage() {
        return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Image pull policy for this container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.ImagePullPolicy getImagePullPolicy() {
        return software.amazon.jsii.Kernel.get(this, "imagePullPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ImagePullPolicy.class));
    }

    /**
     * Volume mounts configured for this container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.VolumeMount> getMounts() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "mounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.VolumeMount.class))));
    }

    /**
     * The name of the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Arguments to the entrypoint.
     * <p>
     * @return a copy of the arguments array, cannot be modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Entrypoint array (the command to execute when the container starts).
     * <p>
     * @return a copy of the entrypoint array, cannot be modified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The port this container exposes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The working directory inside the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWorkingDir() {
        return software.amazon.jsii.Kernel.get(this, "workingDir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus20.Container}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus20.Container> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final org.cdk8s.plus20.ContainerProps.Builder props;

        private Builder() {
            this.props = new org.cdk8s.plus20.ContainerProps.Builder();
        }

        /**
         * Docker image name.
         * <p>
         * @return {@code this}
         * @param image Docker image name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(final java.lang.String image) {
            this.props.image(image);
            return this;
        }

        /**
         * Arguments to the entrypoint. The docker image's CMD is used if `command` is not provided.
         * <p>
         * Variable references $(VAR_NAME) are expanded using the container's
         * environment. If a variable cannot be resolved, the reference in the input
         * string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
         * double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
         * regardless of whether the variable exists or not.
         * <p>
         * Cannot be updated.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
         * @param args Arguments to the entrypoint. The docker image's CMD is used if `command` is not provided. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder args(final java.util.List<java.lang.String> args) {
            this.props.args(args);
            return this;
        }

        /**
         * Entrypoint array.
         * <p>
         * Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment.
         * If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
         * Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated.
         * More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
         * <p>
         * Default: - The docker image's ENTRYPOINT.
         * <p>
         * @return {@code this}
         * @param command Entrypoint array. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(final java.util.List<java.lang.String> command) {
            this.props.command(command);
            return this;
        }

        /**
         * List of environment variables to set in the container.
         * <p>
         * Cannot be updated.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param env List of environment variables to set in the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(final java.util.Map<java.lang.String, ? extends org.cdk8s.plus20.EnvValue> env) {
            this.props.env(env);
            return this;
        }

        /**
         * Image pull policy for this container.
         * <p>
         * Default: ImagePullPolicy.ALWAYS
         * <p>
         * @return {@code this}
         * @param imagePullPolicy Image pull policy for this container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imagePullPolicy(final org.cdk8s.plus20.ImagePullPolicy imagePullPolicy) {
            this.props.imagePullPolicy(imagePullPolicy);
            return this;
        }

        /**
         * Periodic probe of container liveness.
         * <p>
         * Container will be restarted if the probe fails.
         * <p>
         * Default: - no liveness probe is defined
         * <p>
         * @return {@code this}
         * @param liveness Periodic probe of container liveness. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder liveness(final org.cdk8s.plus20.Probe liveness) {
            this.props.liveness(liveness);
            return this;
        }

        /**
         * Name of the container specified as a DNS_LABEL.
         * <p>
         * Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
         * <p>
         * Default: 'main'
         * <p>
         * @return {@code this}
         * @param name Name of the container specified as a DNS_LABEL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Number of port to expose on the pod's IP address.
         * <p>
         * This must be a valid port number, 0 &lt; x &lt; 65536.
         * <p>
         * Default: - No port is exposed.
         * <p>
         * @return {@code this}
         * @param port Number of port to expose on the pod's IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * Determines when the container is ready to serve traffic.
         * <p>
         * Default: - no readiness probe is defined
         * <p>
         * @return {@code this}
         * @param readiness Determines when the container is ready to serve traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readiness(final org.cdk8s.plus20.Probe readiness) {
            this.props.readiness(readiness);
            return this;
        }

        /**
         * StartupProbe indicates that the Pod has successfully initialized.
         * <p>
         * If specified, no other probes are executed until this completes successfully
         * <p>
         * Default: - no startup probe is defined.
         * <p>
         * @return {@code this}
         * @param startup StartupProbe indicates that the Pod has successfully initialized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startup(final org.cdk8s.plus20.Probe startup) {
            this.props.startup(startup);
            return this;
        }

        /**
         * Pod volumes to mount into the container's filesystem.
         * <p>
         * Cannot be updated.
         * <p>
         * @return {@code this}
         * @param volumeMounts Pod volumes to mount into the container's filesystem. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeMounts(final java.util.List<? extends org.cdk8s.plus20.VolumeMount> volumeMounts) {
            this.props.volumeMounts(volumeMounts);
            return this;
        }

        /**
         * Container's working directory.
         * <p>
         * If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
         * <p>
         * Default: - The container runtime's default.
         * <p>
         * @return {@code this}
         * @param workingDir Container's working directory. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDir(final java.lang.String workingDir) {
            this.props.workingDir(workingDir);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus20.Container}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus20.Container build() {
            return new org.cdk8s.plus20.Container(
                this.props.build()
            );
        }
    }
}
