package org.cdk8s.plus20;

/**
 * Properties for `PodSecurityContext`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-05-15T15:18:28.669Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.PodSecurityContextProps")
@software.amazon.jsii.Jsii.Proxy(PodSecurityContextProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PodSecurityContextProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates that the container must run as a non-root user.
     * <p>
     * If true, the Kubelet will validate the image at runtime to ensure that it does
     * not run as UID 0 (root) and fail to start the container if it does.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnsureNonRoot() {
        return null;
    }

    /**
     * Modify the ownership and permissions of pod volumes to this GID.
     * <p>
     * Default: - Volume ownership is not changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getFsGroup() {
        return null;
    }

    /**
     * Defines behavior of changing ownership and permission of the volume before being exposed inside Pod.
     * <p>
     * This field will only apply to volume types which support fsGroup based ownership(and permissions).
     * It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir.
     * <p>
     * Default: FsGroupChangePolicy.ALWAYS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.FsGroupChangePolicy getFsGroupChangePolicy() {
        return null;
    }

    /**
     * The GID to run the entrypoint of the container process.
     * <p>
     * Default: - Group configured by container runtime
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGroup() {
        return null;
    }

    /**
     * Sysctls hold a list of namespaced sysctls used for the pod.
     * <p>
     * Pods with unsupported sysctls (by the container runtime) might fail to launch.
     * <p>
     * Default: - No sysctls
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus20.Sysctl> getSysctls() {
        return null;
    }

    /**
     * The UID to run the entrypoint of the container process.
     * <p>
     * Default: - User specified in image metadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUser() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PodSecurityContextProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PodSecurityContextProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PodSecurityContextProps> {
        java.lang.Boolean ensureNonRoot;
        java.lang.Number fsGroup;
        org.cdk8s.plus20.FsGroupChangePolicy fsGroupChangePolicy;
        java.lang.Number group;
        java.util.List<org.cdk8s.plus20.Sysctl> sysctls;
        java.lang.Number user;

        /**
         * Sets the value of {@link PodSecurityContextProps#getEnsureNonRoot}
         * @param ensureNonRoot Indicates that the container must run as a non-root user.
         *                      If true, the Kubelet will validate the image at runtime to ensure that it does
         *                      not run as UID 0 (root) and fail to start the container if it does.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ensureNonRoot(java.lang.Boolean ensureNonRoot) {
            this.ensureNonRoot = ensureNonRoot;
            return this;
        }

        /**
         * Sets the value of {@link PodSecurityContextProps#getFsGroup}
         * @param fsGroup Modify the ownership and permissions of pod volumes to this GID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fsGroup(java.lang.Number fsGroup) {
            this.fsGroup = fsGroup;
            return this;
        }

        /**
         * Sets the value of {@link PodSecurityContextProps#getFsGroupChangePolicy}
         * @param fsGroupChangePolicy Defines behavior of changing ownership and permission of the volume before being exposed inside Pod.
         *                            This field will only apply to volume types which support fsGroup based ownership(and permissions).
         *                            It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fsGroupChangePolicy(org.cdk8s.plus20.FsGroupChangePolicy fsGroupChangePolicy) {
            this.fsGroupChangePolicy = fsGroupChangePolicy;
            return this;
        }

        /**
         * Sets the value of {@link PodSecurityContextProps#getGroup}
         * @param group The GID to run the entrypoint of the container process.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder group(java.lang.Number group) {
            this.group = group;
            return this;
        }

        /**
         * Sets the value of {@link PodSecurityContextProps#getSysctls}
         * @param sysctls Sysctls hold a list of namespaced sysctls used for the pod.
         *                Pods with unsupported sysctls (by the container runtime) might fail to launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder sysctls(java.util.List<? extends org.cdk8s.plus20.Sysctl> sysctls) {
            this.sysctls = (java.util.List<org.cdk8s.plus20.Sysctl>)sysctls;
            return this;
        }

        /**
         * Sets the value of {@link PodSecurityContextProps#getUser}
         * @param user The UID to run the entrypoint of the container process.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.Number user) {
            this.user = user;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PodSecurityContextProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PodSecurityContextProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PodSecurityContextProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PodSecurityContextProps {
        private final java.lang.Boolean ensureNonRoot;
        private final java.lang.Number fsGroup;
        private final org.cdk8s.plus20.FsGroupChangePolicy fsGroupChangePolicy;
        private final java.lang.Number group;
        private final java.util.List<org.cdk8s.plus20.Sysctl> sysctls;
        private final java.lang.Number user;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ensureNonRoot = software.amazon.jsii.Kernel.get(this, "ensureNonRoot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.fsGroup = software.amazon.jsii.Kernel.get(this, "fsGroup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.fsGroupChangePolicy = software.amazon.jsii.Kernel.get(this, "fsGroupChangePolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.FsGroupChangePolicy.class));
            this.group = software.amazon.jsii.Kernel.get(this, "group", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.sysctls = software.amazon.jsii.Kernel.get(this, "sysctls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Sysctl.class)));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ensureNonRoot = builder.ensureNonRoot;
            this.fsGroup = builder.fsGroup;
            this.fsGroupChangePolicy = builder.fsGroupChangePolicy;
            this.group = builder.group;
            this.sysctls = (java.util.List<org.cdk8s.plus20.Sysctl>)builder.sysctls;
            this.user = builder.user;
        }

        @Override
        public final java.lang.Boolean getEnsureNonRoot() {
            return this.ensureNonRoot;
        }

        @Override
        public final java.lang.Number getFsGroup() {
            return this.fsGroup;
        }

        @Override
        public final org.cdk8s.plus20.FsGroupChangePolicy getFsGroupChangePolicy() {
            return this.fsGroupChangePolicy;
        }

        @Override
        public final java.lang.Number getGroup() {
            return this.group;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.Sysctl> getSysctls() {
            return this.sysctls;
        }

        @Override
        public final java.lang.Number getUser() {
            return this.user;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEnsureNonRoot() != null) {
                data.set("ensureNonRoot", om.valueToTree(this.getEnsureNonRoot()));
            }
            if (this.getFsGroup() != null) {
                data.set("fsGroup", om.valueToTree(this.getFsGroup()));
            }
            if (this.getFsGroupChangePolicy() != null) {
                data.set("fsGroupChangePolicy", om.valueToTree(this.getFsGroupChangePolicy()));
            }
            if (this.getGroup() != null) {
                data.set("group", om.valueToTree(this.getGroup()));
            }
            if (this.getSysctls() != null) {
                data.set("sysctls", om.valueToTree(this.getSysctls()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.PodSecurityContextProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PodSecurityContextProps.Jsii$Proxy that = (PodSecurityContextProps.Jsii$Proxy) o;

            if (this.ensureNonRoot != null ? !this.ensureNonRoot.equals(that.ensureNonRoot) : that.ensureNonRoot != null) return false;
            if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) return false;
            if (this.fsGroupChangePolicy != null ? !this.fsGroupChangePolicy.equals(that.fsGroupChangePolicy) : that.fsGroupChangePolicy != null) return false;
            if (this.group != null ? !this.group.equals(that.group) : that.group != null) return false;
            if (this.sysctls != null ? !this.sysctls.equals(that.sysctls) : that.sysctls != null) return false;
            return this.user != null ? this.user.equals(that.user) : that.user == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ensureNonRoot != null ? this.ensureNonRoot.hashCode() : 0;
            result = 31 * result + (this.fsGroup != null ? this.fsGroup.hashCode() : 0);
            result = 31 * result + (this.fsGroupChangePolicy != null ? this.fsGroupChangePolicy.hashCode() : 0);
            result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
            result = 31 * result + (this.sysctls != null ? this.sysctls.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            return result;
        }
    }
}
