package org.cdk8s.plus20;

/**
 * Create a secret for storing credentials for accessing a container image registry.
 * <p>
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#docker-config-secrets
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-05-15T15:18:28.583Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.DockerConfigSecret")
public class DockerConfigSecret extends org.cdk8s.plus20.Secret {

    protected DockerConfigSecret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DockerConfigSecret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DockerConfigSecret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.DockerConfigSecretProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus20.DockerConfigSecret}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus20.DockerConfigSecret> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final org.cdk8s.plus20.DockerConfigSecretProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new org.cdk8s.plus20.DockerConfigSecretProps.Builder();
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props.metadata(metadata);
            return this;
        }

        /**
         * If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).
         * <p>
         * If not set to true, the field can be modified at any time.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param immutable If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder immutable(final java.lang.Boolean immutable) {
            this.props.immutable(immutable);
            return this;
        }

        /**
         * JSON content to provide for the `~/.docker/config.json` file. This will be stringified and inserted as stringData.
         * <p>
         * @return {@code this}
         * @see https://docs.docker.com/engine/reference/commandline/cli/#sample-configuration-file
         * @param data JSON content to provide for the `~/.docker/config.json` file. This will be stringified and inserted as stringData. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder data(final java.util.Map<java.lang.String, ? extends java.lang.Object> data) {
            this.props.data(data);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus20.DockerConfigSecret}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus20.DockerConfigSecret build() {
            return new org.cdk8s.plus20.DockerConfigSecret(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
