package org.cdk8s.plus20;

/**
 * StatefulSet is the workload API object used to manage stateful applications.
 * <p>
 * Manages the deployment and scaling of a set of Pods, and provides guarantees
 * about the ordering and uniqueness of these Pods.
 * <p>
 * Like a Deployment, a StatefulSet manages Pods that are based on an identical
 * container spec. Unlike a Deployment, a StatefulSet maintains a sticky identity
 * for each of their Pods. These pods are created from the same spec, but are not
 * interchangeable: each has a persistent identifier that it maintains across any
 * rescheduling.
 * <p>
 * If you want to use storage volumes to provide persistence for your workload, you
 * can use a StatefulSet as part of the solution. Although individual Pods in a StatefulSet
 * are susceptible to failure, the persistent Pod identifiers make it easier to match existing
 * volumes to the new Pods that replace any that have failed.
 * <p>
 * <h2>Using StatefulSets</h2>
 * <p>
 * StatefulSets are valuable for applications that require one or more of the following.
 * <p>
 * <ul>
 * <li>Stable, unique network identifiers.</li>
 * <li>Stable, persistent storage.</li>
 * <li>Ordered, graceful deployment and scaling.</li>
 * <li>Ordered, automated rolling updates.</li>
 * </ul>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-05-01T02:58:07.344Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.StatefulSet")
public class StatefulSet extends org.cdk8s.plus20.Workload {

    protected StatefulSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StatefulSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StatefulSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.StatefulSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * Management policy to use for the set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.PodManagementPolicy getPodManagementPolicy() {
        return software.amazon.jsii.Kernel.get(this, "podManagementPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PodManagementPolicy.class));
    }

    /**
     * Number of desired pods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getReplicas() {
        return software.amazon.jsii.Kernel.get(this, "replicas", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The update startegy of this stateful set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.StatefulSetUpdateStrategy getStrategy() {
        return software.amazon.jsii.Kernel.get(this, "strategy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.StatefulSetUpdateStrategy.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus20.StatefulSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus20.StatefulSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final org.cdk8s.plus20.StatefulSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new org.cdk8s.plus20.StatefulSetProps.Builder();
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props.metadata(metadata);
            return this;
        }

        /**
         * Indicates whether a service account token should be automatically mounted.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
         * @param automountServiceAccountToken Indicates whether a service account token should be automatically mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automountServiceAccountToken(final java.lang.Boolean automountServiceAccountToken) {
            this.props.automountServiceAccountToken(automountServiceAccountToken);
            return this;
        }

        /**
         * List of containers belonging to the pod.
         * <p>
         * Containers cannot currently be
         * added or removed. There must be at least one container in a Pod.
         * <p>
         * You can add additionnal containers using <code>podSpec.addContainer()</code>
         * <p>
         * Default: - No containers. Note that a pod spec must include at least one container.
         * <p>
         * @return {@code this}
         * @param containers List of containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(final java.util.List<? extends org.cdk8s.plus20.ContainerProps> containers) {
            this.props.containers(containers);
            return this;
        }

        /**
         * DNS settings for the pod.
         * <p>
         * Default:  policy: DnsPolicy.CLUSTER_FIRST
         *  hostnameAsFQDN: false
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
         * @param dns DNS settings for the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dns(final org.cdk8s.plus20.PodDnsProps dns) {
            this.props.dns(dns);
            return this;
        }

        /**
         * A secret containing docker credentials for authenticating to a registry.
         * <p>
         * Default: - No auth. Images are assumed to be publicly available.
         * <p>
         * @return {@code this}
         * @param dockerRegistryAuth A secret containing docker credentials for authenticating to a registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerRegistryAuth(final org.cdk8s.plus20.DockerConfigSecret dockerRegistryAuth) {
            this.props.dockerRegistryAuth(dockerRegistryAuth);
            return this;
        }

        /**
         * HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
         * <p>
         * @return {@code this}
         * @param hostAliases HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostAliases(final java.util.List<? extends org.cdk8s.plus20.HostAlias> hostAliases) {
            this.props.hostAliases(hostAliases);
            return this;
        }

        /**
         * List of initialization containers belonging to the pod.
         * <p>
         * Init containers are executed in order prior to containers being started.
         * If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
         * The name for an init container or normal container must be unique among all containers.
         * Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
         * The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
         * for each resource type, and then using the max of of that value or the sum of the normal containers.
         * Limits are applied to init containers in a similar fashion.
         * <p>
         * Init containers cannot currently be added ,removed or updated.
         * <p>
         * Default: - No init containers.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
         * @param initContainers List of initialization containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initContainers(final java.util.List<? extends org.cdk8s.plus20.ContainerProps> initContainers) {
            this.props.initContainers(initContainers);
            return this;
        }

        /**
         * Restart policy for all containers within the pod.
         * <p>
         * Default: RestartPolicy.ALWAYS
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
         * @param restartPolicy Restart policy for all containers within the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartPolicy(final org.cdk8s.plus20.RestartPolicy restartPolicy) {
            this.props.restartPolicy(restartPolicy);
            return this;
        }

        /**
         * SecurityContext holds pod-level security attributes and common container settings.
         * <p>
         * Default:   fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
         *   ensureNonRoot: false
         * <p>
         * @return {@code this}
         * @param securityContext SecurityContext holds pod-level security attributes and common container settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityContext(final org.cdk8s.plus20.PodSecurityContextProps securityContext) {
            this.props.securityContext(securityContext);
            return this;
        }

        /**
         * A service account provides an identity for processes that run in a Pod.
         * <p>
         * When you (a human) access the cluster (for example, using kubectl), you are
         * authenticated by the apiserver as a particular User Account (currently this
         * is usually admin, unless your cluster administrator has customized your
         * cluster). Processes in containers inside pods can also contact the
         * apiserver. When they do, they are authenticated as a particular Service
         * Account (for example, default).
         * <p>
         * Default: - No service account.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
         * @param serviceAccount A service account provides an identity for processes that run in a Pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(final org.cdk8s.plus20.IServiceAccount serviceAccount) {
            this.props.serviceAccount(serviceAccount);
            return this;
        }

        /**
         * List of volumes that can be mounted by containers belonging to the pod.
         * <p>
         * You can also add volumes later using <code>podSpec.addVolume()</code>
         * <p>
         * Default: - No volumes.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/volumes
         * @param volumes List of volumes that can be mounted by containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends org.cdk8s.plus20.Volume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        /**
         * The pod metadata of this workload.
         * <p>
         * @return {@code this}
         * @param podMetadata The pod metadata of this workload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podMetadata(final org.cdk8s.ApiObjectMetadata podMetadata) {
            this.props.podMetadata(podMetadata);
            return this;
        }

        /**
         * Automatically allocates a pod label selector for this workload and add it to the pod metadata.
         * <p>
         * This ensures this workload manages pods created by
         * its pod template.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param select Automatically allocates a pod label selector for this workload and add it to the pod metadata. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder select(final java.lang.Boolean select) {
            this.props.select(select);
            return this;
        }

        /**
         * Service to associate with the statefulset.
         * <p>
         * @return {@code this}
         * @param service Service to associate with the statefulset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(final org.cdk8s.plus20.Service service) {
            this.props.service(service);
            return this;
        }

        /**
         * Pod management policy to use for this statefulset.
         * <p>
         * Default: PodManagementPolicy.ORDERED_READY
         * <p>
         * @return {@code this}
         * @param podManagementPolicy Pod management policy to use for this statefulset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podManagementPolicy(final org.cdk8s.plus20.PodManagementPolicy podManagementPolicy) {
            this.props.podManagementPolicy(podManagementPolicy);
            return this;
        }

        /**
         * Number of desired pods.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param replicas Number of desired pods. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicas(final java.lang.Number replicas) {
            this.props.replicas(replicas);
            return this;
        }

        /**
         * Indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
         * <p>
         * Default: - RollingUpdate with partition set to 0
         * <p>
         * @return {@code this}
         * @param strategy Indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder strategy(final org.cdk8s.plus20.StatefulSetUpdateStrategy strategy) {
            this.props.strategy(strategy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus20.StatefulSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus20.StatefulSet build() {
            return new org.cdk8s.plus20.StatefulSet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
