package org.cdk8s.plus20;

/**
 * Represents the TLS configuration mapping that is passed to the ingress controller for SSL termination.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-27T19:26:13.990Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.IngressV1Beta1Tls")
@software.amazon.jsii.Jsii.Proxy(IngressV1Beta1Tls.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IngressV1Beta1Tls extends software.amazon.jsii.JsiiSerializable {

    /**
     * Hosts are a list of hosts included in the TLS certificate.
     * <p>
     * The values in
     * this list must match the name/s used in the TLS Secret.
     * <p>
     * Default: - If unspecified, it defaults to the wildcard host setting for
     * the loadbalancer controller fulfilling this Ingress.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHosts() {
        return null;
    }

    /**
     * Secret is the secret that contains the certificate and key used to terminate SSL traffic on 443.
     * <p>
     * If the SNI host in a listener conflicts with
     * the "Host" header field used by an IngressRule, the SNI host is used for
     * termination and value of the Host header is used for routing.
     * <p>
     * Default: - If unspecified, it allows SSL routing based on SNI hostname.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.ISecret getSecret() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IngressV1Beta1Tls}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IngressV1Beta1Tls}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IngressV1Beta1Tls> {
        java.util.List<java.lang.String> hosts;
        org.cdk8s.plus20.ISecret secret;

        /**
         * Sets the value of {@link IngressV1Beta1Tls#getHosts}
         * @param hosts Hosts are a list of hosts included in the TLS certificate.
         *              The values in
         *              this list must match the name/s used in the TLS Secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hosts(java.util.List<java.lang.String> hosts) {
            this.hosts = hosts;
            return this;
        }

        /**
         * Sets the value of {@link IngressV1Beta1Tls#getSecret}
         * @param secret Secret is the secret that contains the certificate and key used to terminate SSL traffic on 443.
         *               If the SNI host in a listener conflicts with
         *               the "Host" header field used by an IngressRule, the SNI host is used for
         *               termination and value of the Host header is used for routing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(org.cdk8s.plus20.ISecret secret) {
            this.secret = secret;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IngressV1Beta1Tls}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IngressV1Beta1Tls build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IngressV1Beta1Tls}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressV1Beta1Tls {
        private final java.util.List<java.lang.String> hosts;
        private final org.cdk8s.plus20.ISecret secret;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hosts = software.amazon.jsii.Kernel.get(this, "hosts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ISecret.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hosts = builder.hosts;
            this.secret = builder.secret;
        }

        @Override
        public final java.util.List<java.lang.String> getHosts() {
            return this.hosts;
        }

        @Override
        public final org.cdk8s.plus20.ISecret getSecret() {
            return this.secret;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHosts() != null) {
                data.set("hosts", om.valueToTree(this.getHosts()));
            }
            if (this.getSecret() != null) {
                data.set("secret", om.valueToTree(this.getSecret()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.IngressV1Beta1Tls"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IngressV1Beta1Tls.Jsii$Proxy that = (IngressV1Beta1Tls.Jsii$Proxy) o;

            if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) return false;
            return this.secret != null ? this.secret.equals(that.secret) : that.secret == null;
        }

        @Override
        public final int hashCode() {
            int result = this.hosts != null ? this.hosts.hashCode() : 0;
            result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
            return result;
        }
    }
}
