package org.cdk8s.plus20;

/**
 * A PersistentVolumeClaim (PVC) is a request for storage by a user.
 * <p>
 * It is similar to a Pod. Pods consume node resources and PVCs consume PV resources.
 * Pods can request specific levels of resources (CPU and Memory).
 * Claims can request specific size and access modes
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-26T11:02:25.489Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.PersistentVolumeClaim")
public class PersistentVolumeClaim extends org.cdk8s.plus20.Resource implements org.cdk8s.plus20.IPersistentVolumeClaim {

    protected PersistentVolumeClaim(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PersistentVolumeClaim(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PersistentVolumeClaim(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.PersistentVolumeClaimProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PersistentVolumeClaim(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a pvc from the cluster as a reference.
     * <p>
     * @param claimName The name of the pvc to reference. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IPersistentVolumeClaim fromClaimName(final @org.jetbrains.annotations.NotNull java.lang.String claimName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus20.PersistentVolumeClaim.class, "fromClaimName", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IPersistentVolumeClaim.class), new Object[] { java.util.Objects.requireNonNull(claimName, "claimName is required") });
    }

    /**
     * Bind a claim to a specific volume.
     * <p>
     * Note that you must also bind the volume to the claim.
     * <p>
     * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding
     * @param vol The PV to bind to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bind(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IPersistentVolume vol) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vol, "vol is required") });
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * Volume mode requirement of this claim.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.PersistentVolumeMode getVolumeMode() {
        return software.amazon.jsii.Kernel.get(this, "volumeMode", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PersistentVolumeMode.class));
    }

    /**
     * Access modes requirement of this claim.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus20.PersistentVolumeAccessMode> getAccessModes() {
        return java.util.Optional.ofNullable((java.util.List<org.cdk8s.plus20.PersistentVolumeAccessMode>)(software.amazon.jsii.Kernel.get(this, "accessModes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PersistentVolumeAccessMode.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Storage requirement of this claim.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.Size getStorage() {
        return software.amazon.jsii.Kernel.get(this, "storage", software.amazon.jsii.NativeType.forClass(org.cdk8s.Size.class));
    }

    /**
     * Storage class requirment of this claim.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStorageClassName() {
        return software.amazon.jsii.Kernel.get(this, "storageClassName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * PV this claim is bound to.
     * <p>
     * Undefined means the claim is not bound
     * to any specific volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus20.IPersistentVolume getVolume() {
        return software.amazon.jsii.Kernel.get(this, "volume", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IPersistentVolume.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus20.PersistentVolumeClaim}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus20.PersistentVolumeClaim> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus20.PersistentVolumeClaimProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * Contains the access modes the volume should support.
         * <p>
         * Default: - No access modes requirement.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
         * @param accessModes Contains the access modes the volume should support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessModes(final java.util.List<? extends org.cdk8s.plus20.PersistentVolumeAccessMode> accessModes) {
            this.props().accessModes(accessModes);
            return this;
        }

        /**
         * Minimum storage size the volume should have.
         * <p>
         * Default: - No storage requirement.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
         * @param storage Minimum storage size the volume should have. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storage(final org.cdk8s.Size storage) {
            this.props().storage(storage);
            return this;
        }

        /**
         * Name of the StorageClass required by the claim. When this property is not set, the behavior is as follows:.
         * <p>
         * <ul>
         * <li>If the admission plugin is turned on, the storage class marked as default will be used.</li>
         * <li>If the admission plugin is turned off, the pvc can only be bound to volumes without a storage class.</li>
         * </ul>
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
         * @param storageClassName Name of the StorageClass required by the claim. When this property is not set, the behavior is as follows:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClassName(final java.lang.String storageClassName) {
            this.props().storageClassName(storageClassName);
            return this;
        }

        /**
         * The PersistentVolume backing this claim.
         * <p>
         * The control plane still checks that storage class, access modes,
         * and requested storage size on the volume are valid.
         * <p>
         * Note that in order to guarantee a proper binding, the volume should
         * also define a <code>claimRef</code> referring to this claim. Otherwise, the volume may be
         * claimed be other pvc's before it gets a chance to bind to this one.
         * <p>
         * If the volume is managed (i.e not imported), you can use <code>pv.claim()</code> to easily
         * create a bi-directional bounded claim.
         * <p>
         * Default: - No specific volume binding.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding.
         * @param volume The PersistentVolume backing this claim. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volume(final org.cdk8s.plus20.IPersistentVolume volume) {
            this.props().volume(volume);
            return this;
        }

        /**
         * Defines what type of volume is required by the claim.
         * <p>
         * Default: VolumeMode.FILE_SYSTEM
         * <p>
         * @return {@code this}
         * @param volumeMode Defines what type of volume is required by the claim. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeMode(final org.cdk8s.plus20.PersistentVolumeMode volumeMode) {
            this.props().volumeMode(volumeMode);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus20.PersistentVolumeClaim}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus20.PersistentVolumeClaim build() {
            return new org.cdk8s.plus20.PersistentVolumeClaim(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus20.PersistentVolumeClaimProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus20.PersistentVolumeClaimProps.Builder();
            }
            return this.props;
        }
    }
}
