package org.cdk8s.plus20;

/**
 * Provides read/write capabilities ontop of a `PodSpecProps`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-26T09:02:10.540Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.PodSpec")
public class PodSpec extends software.amazon.jsii.JsiiObject implements org.cdk8s.plus20.IPodSpec {

    protected PodSpec(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PodSpec(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PodSpec(final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.PodSpecProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PodSpec() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Add a container to the pod.
     * <p>
     * @param cont This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Container addContainer(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.ContainerProps cont) {
        return software.amazon.jsii.Kernel.call(this, "addContainer", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Container.class), new Object[] { java.util.Objects.requireNonNull(cont, "cont is required") });
    }

    /**
     * @param hostAlias This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addHostAlias(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.HostAlias hostAlias) {
        software.amazon.jsii.Kernel.call(this, "addHostAlias", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(hostAlias, "hostAlias is required") });
    }

    /**
     * Add an init container to the pod.
     * <p>
     * @param cont This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Container addInitContainer(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.ContainerProps cont) {
        return software.amazon.jsii.Kernel.call(this, "addInitContainer", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Container.class), new Object[] { java.util.Objects.requireNonNull(cont, "cont is required") });
    }

    /**
     * Add a volume to the pod.
     * <p>
     * @param vol This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addVolume(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Volume vol) {
        software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vol, "vol is required") });
    }

    /**
     * The containers belonging to the pod.
     * <p>
     * Use <code>addContainer</code> to add containers.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.Container> getContainers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Container.class))));
    }

    /**
     * The pod's DNS settings.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.PodDns getDns() {
        return software.amazon.jsii.Kernel.get(this, "dns", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PodDns.class));
    }

    /**
     * An optional list of hosts and IPs that will be injected into the pod's hosts file if specified.
     * <p>
     * This is only valid for non-hostNetwork pods.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.HostAlias> getHostAliases() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "hostAliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.HostAlias.class))));
    }

    /**
     * The init containers belonging to the pod.
     * <p>
     * Use <code>addInitContainer</code> to add init containers.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.Container> getInitContainers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "initContainers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Container.class))));
    }

    /**
     * The pod's security context.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.PodSecurityContext getSecurityContext() {
        return software.amazon.jsii.Kernel.get(this, "securityContext", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PodSecurityContext.class));
    }

    /**
     * The volumes associated with this pod.
     * <p>
     * Use <code>addVolume</code> to add volumes.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.Volume> getVolumes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Volume.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus20.DockerConfigSecret getDockerRegistryAuth() {
        return software.amazon.jsii.Kernel.get(this, "dockerRegistryAuth", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.DockerConfigSecret.class));
    }

    /**
     * Restart policy for all containers within the pod.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus20.RestartPolicy getRestartPolicy() {
        return software.amazon.jsii.Kernel.get(this, "restartPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.RestartPolicy.class));
    }

    /**
     * The service account used to run this pod.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus20.IServiceAccount getServiceAccount() {
        return software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IServiceAccount.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus20.PodSpec}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus20.PodSpec> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private org.cdk8s.plus20.PodSpecProps.Builder props;

        private Builder() {
        }

        /**
         * List of containers belonging to the pod.
         * <p>
         * Containers cannot currently be
         * added or removed. There must be at least one container in a Pod.
         * <p>
         * You can add additionnal containers using <code>podSpec.addContainer()</code>
         * <p>
         * Default: - No containers. Note that a pod spec must include at least one container.
         * <p>
         * @return {@code this}
         * @param containers List of containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(final java.util.List<? extends org.cdk8s.plus20.ContainerProps> containers) {
            this.props().containers(containers);
            return this;
        }

        /**
         * DNS settings for the pod.
         * <p>
         * Default:  policy: DnsPolicy.CLUSTER_FIRST
         *  hostnameAsFQDN: false
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
         * @param dns DNS settings for the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dns(final org.cdk8s.plus20.PodDnsProps dns) {
            this.props().dns(dns);
            return this;
        }

        /**
         * A secret containing docker credentials for authenticating to a registry.
         * <p>
         * Default: - No auth. Images are assumed to be publicly available.
         * <p>
         * @return {@code this}
         * @param dockerRegistryAuth A secret containing docker credentials for authenticating to a registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerRegistryAuth(final org.cdk8s.plus20.DockerConfigSecret dockerRegistryAuth) {
            this.props().dockerRegistryAuth(dockerRegistryAuth);
            return this;
        }

        /**
         * HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
         * <p>
         * @return {@code this}
         * @param hostAliases HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostAliases(final java.util.List<? extends org.cdk8s.plus20.HostAlias> hostAliases) {
            this.props().hostAliases(hostAliases);
            return this;
        }

        /**
         * List of initialization containers belonging to the pod.
         * <p>
         * Init containers are executed in order prior to containers being started.
         * If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
         * The name for an init container or normal container must be unique among all containers.
         * Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
         * The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
         * for each resource type, and then using the max of of that value or the sum of the normal containers.
         * Limits are applied to init containers in a similar fashion.
         * <p>
         * Init containers cannot currently be added ,removed or updated.
         * <p>
         * Default: - No init containers.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
         * @param initContainers List of initialization containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initContainers(final java.util.List<? extends org.cdk8s.plus20.ContainerProps> initContainers) {
            this.props().initContainers(initContainers);
            return this;
        }

        /**
         * Restart policy for all containers within the pod.
         * <p>
         * Default: RestartPolicy.ALWAYS
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
         * @param restartPolicy Restart policy for all containers within the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartPolicy(final org.cdk8s.plus20.RestartPolicy restartPolicy) {
            this.props().restartPolicy(restartPolicy);
            return this;
        }

        /**
         * SecurityContext holds pod-level security attributes and common container settings.
         * <p>
         * Default:   fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
         *   ensureNonRoot: false
         * <p>
         * @return {@code this}
         * @param securityContext SecurityContext holds pod-level security attributes and common container settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityContext(final org.cdk8s.plus20.PodSecurityContextProps securityContext) {
            this.props().securityContext(securityContext);
            return this;
        }

        /**
         * A service account provides an identity for processes that run in a Pod.
         * <p>
         * When you (a human) access the cluster (for example, using kubectl), you are
         * authenticated by the apiserver as a particular User Account (currently this
         * is usually admin, unless your cluster administrator has customized your
         * cluster). Processes in containers inside pods can also contact the
         * apiserver. When they do, they are authenticated as a particular Service
         * Account (for example, default).
         * <p>
         * Default: - No service account.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
         * @param serviceAccount A service account provides an identity for processes that run in a Pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(final org.cdk8s.plus20.IServiceAccount serviceAccount) {
            this.props().serviceAccount(serviceAccount);
            return this;
        }

        /**
         * List of volumes that can be mounted by containers belonging to the pod.
         * <p>
         * You can also add volumes later using <code>podSpec.addVolume()</code>
         * <p>
         * Default: - No volumes.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/volumes
         * @param volumes List of volumes that can be mounted by containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends org.cdk8s.plus20.Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus20.PodSpec}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus20.PodSpec build() {
            return new org.cdk8s.plus20.PodSpec(
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus20.PodSpecProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus20.PodSpecProps.Builder();
            }
            return this.props;
        }
    }
}
