package org.cdk8s.plus20;

/**
 * For some parts of your application (for example, frontends) you may want to expose a Service onto an external IP address, that's outside of your cluster.
 * <p>
 * Kubernetes ServiceTypes allow you to specify what kind of Service you want.
 * The default is ClusterIP.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-26T02:51:16.884Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.ServiceType")
public enum ServiceType {
    /**
     * Exposes the Service on a cluster-internal IP.
     * <p>
     * Choosing this value makes the Service only reachable from within the cluster.
     * This is the default ServiceType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLUSTER_IP,
    /**
     * Exposes the Service on each Node's IP at a static port (the NodePort).
     * <p>
     * A ClusterIP Service, to which the NodePort Service routes, is automatically created.
     * You'll be able to contact the NodePort Service, from outside the cluster,
     * by requesting <NodeIP>:<NodePort>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NODE_PORT,
    /**
     * Exposes the Service externally using a cloud provider's load balancer.
     * <p>
     * NodePort and ClusterIP Services, to which the external load balancer routes,
     * are automatically created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LOAD_BALANCER,
    /**
     * Maps the Service to the contents of the externalName field (e.g. foo.bar.example.com), by returning a CNAME record with its value. No proxying of any kind is set up.
     * <p>
     * <blockquote>
     * <p>
     * Note: You need either kube-dns version 1.7 or CoreDNS version 0.0.8 or higher to use the ExternalName type.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXTERNAL_NAME,
}
