package org.cdk8s.plus20;

/**
 * A PersistentVolume (PV) is a piece of storage in the cluster that has been provisioned by an administrator or dynamically provisioned using Storage Classes.
 * <p>
 * It is a resource in the cluster just like a node is a cluster resource.
 * PVs are volume plugins like Volumes, but have a lifecycle independent of any
 * individual Pod that uses the PV. This API object captures the details of the
 * implementation of the storage, be that NFS, iSCSI, or a
 * cloud-provider-specific storage system.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-22T02:55:55.093Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.PersistentVolume")
public class PersistentVolume extends org.cdk8s.plus20.Resource implements org.cdk8s.plus20.IPersistentVolume, org.cdk8s.plus20.IStorage {

    protected PersistentVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PersistentVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected PersistentVolume(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.PersistentVolumeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected PersistentVolume(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a pv from the cluster as a reference.
     * <p>
     * @param volumeName The name of the pv to reference. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IPersistentVolume fromPersistentVolumeName(final @org.jetbrains.annotations.NotNull java.lang.String volumeName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus20.PersistentVolume.class, "fromPersistentVolumeName", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IPersistentVolume.class), new Object[] { java.util.Objects.requireNonNull(volumeName, "volumeName is required") });
    }

    /**
     * Convert the piece of storage into a concrete volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Volume asVolume() {
        return software.amazon.jsii.Kernel.call(this, "asVolume", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Volume.class));
    }

    /**
     * Bind a volume to a specific claim.
     * <p>
     * Note that you must also bind the claim to the volume.
     * <p>
     * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding
     * @param pvc The PVC to bind to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bind(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IPersistentVolumeClaim pvc) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(pvc, "pvc is required") });
    }

    /**
     * Reserve a `PersistentVolume` by creating a `PersistentVolumeClaim` that is wired to claim this volume.
     * <p>
     * Note that this method will throw in case the volume is already claimed.
     * <p>
     * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes/#reserving-a-persistentvolume
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.PersistentVolumeClaim reserve() {
        return software.amazon.jsii.Kernel.call(this, "reserve", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PersistentVolumeClaim.class));
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * Volume mode of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.PersistentVolumeMode getMode() {
        return software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PersistentVolumeMode.class));
    }

    /**
     * Reclaim policy of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.PersistentVolumeReclaimPolicy getReclaimPolicy() {
        return software.amazon.jsii.Kernel.get(this, "reclaimPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PersistentVolumeReclaimPolicy.class));
    }

    /**
     * Access modes requirement of this claim.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus20.PersistentVolumeAccessMode> getAccessModes() {
        return java.util.Optional.ofNullable((java.util.List<org.cdk8s.plus20.PersistentVolumeAccessMode>)(software.amazon.jsii.Kernel.get(this, "accessModes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PersistentVolumeAccessMode.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * PVC this volume is bound to.
     * <p>
     * Undefined means this volume is not yet
     * claimed by any PVC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus20.IPersistentVolumeClaim getClaim() {
        return software.amazon.jsii.Kernel.get(this, "claim", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IPersistentVolumeClaim.class));
    }

    /**
     * Mount options of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMountOptions() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Storage size of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.Size getStorage() {
        return software.amazon.jsii.Kernel.get(this, "storage", software.amazon.jsii.NativeType.forClass(org.cdk8s.Size.class));
    }

    /**
     * Storage class this volume belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStorageClassName() {
        return software.amazon.jsii.Kernel.get(this, "storageClassName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
