package org.cdk8s.plus20;

/**
 * Properties of a `PodSpec`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.56.0 (build 55e7d15)", date = "2022-04-14T10:16:34.190Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.PodSpecProps")
@software.amazon.jsii.Jsii.Proxy(PodSpecProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PodSpecProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of containers belonging to the pod.
     * <p>
     * Containers cannot currently be
     * added or removed. There must be at least one container in a Pod.
     * <p>
     * You can add additionnal containers using <code>podSpec.addContainer()</code>
     * <p>
     * Default: - No containers. Note that a pod spec must include at least one container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus20.ContainerProps> getContainers() {
        return null;
    }

    /**
     * A secret containing docker credentials for authenticating to a registry.
     * <p>
     * Default: - No auth. Images are assumed to be publicly available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.DockerConfigSecret getDockerRegistryAuth() {
        return null;
    }

    /**
     * HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus20.HostAlias> getHostAliases() {
        return null;
    }

    /**
     * List of initialization containers belonging to the pod.
     * <p>
     * Init containers are executed in order prior to containers being started.
     * If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
     * The name for an init container or normal container must be unique among all containers.
     * Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
     * The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
     * for each resource type, and then using the max of of that value or the sum of the normal containers.
     * Limits are applied to init containers in a similar fashion.
     * <p>
     * Init containers cannot currently be added ,removed or updated.
     * <p>
     * Default: - No init containers.
     * <p>
     * @see https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus20.ContainerProps> getInitContainers() {
        return null;
    }

    /**
     * Restart policy for all containers within the pod.
     * <p>
     * Default: RestartPolicy.ALWAYS
     * <p>
     * @see https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.RestartPolicy getRestartPolicy() {
        return null;
    }

    /**
     * SecurityContext holds pod-level security attributes and common container settings.
     * <p>
     * Default:   fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
     *   ensureNonRoot: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.PodSecurityContextProps getSecurityContext() {
        return null;
    }

    /**
     * A service account provides an identity for processes that run in a Pod.
     * <p>
     * When you (a human) access the cluster (for example, using kubectl), you are
     * authenticated by the apiserver as a particular User Account (currently this
     * is usually admin, unless your cluster administrator has customized your
     * cluster). Processes in containers inside pods can also contact the
     * apiserver. When they do, they are authenticated as a particular Service
     * Account (for example, default).
     * <p>
     * Default: - No service account.
     * <p>
     * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.IServiceAccount getServiceAccount() {
        return null;
    }

    /**
     * List of volumes that can be mounted by containers belonging to the pod.
     * <p>
     * You can also add volumes later using <code>podSpec.addVolume()</code>
     * <p>
     * Default: - No volumes.
     * <p>
     * @see https://kubernetes.io/docs/concepts/storage/volumes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus20.Volume> getVolumes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PodSpecProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PodSpecProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PodSpecProps> {
        java.util.List<org.cdk8s.plus20.ContainerProps> containers;
        org.cdk8s.plus20.DockerConfigSecret dockerRegistryAuth;
        java.util.List<org.cdk8s.plus20.HostAlias> hostAliases;
        java.util.List<org.cdk8s.plus20.ContainerProps> initContainers;
        org.cdk8s.plus20.RestartPolicy restartPolicy;
        org.cdk8s.plus20.PodSecurityContextProps securityContext;
        org.cdk8s.plus20.IServiceAccount serviceAccount;
        java.util.List<org.cdk8s.plus20.Volume> volumes;

        /**
         * Sets the value of {@link PodSpecProps#getContainers}
         * @param containers List of containers belonging to the pod.
         *                   Containers cannot currently be
         *                   added or removed. There must be at least one container in a Pod.
         *                   <p>
         *                   You can add additionnal containers using <code>podSpec.addContainer()</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder containers(java.util.List<? extends org.cdk8s.plus20.ContainerProps> containers) {
            this.containers = (java.util.List<org.cdk8s.plus20.ContainerProps>)containers;
            return this;
        }

        /**
         * Sets the value of {@link PodSpecProps#getDockerRegistryAuth}
         * @param dockerRegistryAuth A secret containing docker credentials for authenticating to a registry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerRegistryAuth(org.cdk8s.plus20.DockerConfigSecret dockerRegistryAuth) {
            this.dockerRegistryAuth = dockerRegistryAuth;
            return this;
        }

        /**
         * Sets the value of {@link PodSpecProps#getHostAliases}
         * @param hostAliases HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder hostAliases(java.util.List<? extends org.cdk8s.plus20.HostAlias> hostAliases) {
            this.hostAliases = (java.util.List<org.cdk8s.plus20.HostAlias>)hostAliases;
            return this;
        }

        /**
         * Sets the value of {@link PodSpecProps#getInitContainers}
         * @param initContainers List of initialization containers belonging to the pod.
         *                       Init containers are executed in order prior to containers being started.
         *                       If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
         *                       The name for an init container or normal container must be unique among all containers.
         *                       Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
         *                       The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
         *                       for each resource type, and then using the max of of that value or the sum of the normal containers.
         *                       Limits are applied to init containers in a similar fashion.
         *                       <p>
         *                       Init containers cannot currently be added ,removed or updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder initContainers(java.util.List<? extends org.cdk8s.plus20.ContainerProps> initContainers) {
            this.initContainers = (java.util.List<org.cdk8s.plus20.ContainerProps>)initContainers;
            return this;
        }

        /**
         * Sets the value of {@link PodSpecProps#getRestartPolicy}
         * @param restartPolicy Restart policy for all containers within the pod.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartPolicy(org.cdk8s.plus20.RestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        /**
         * Sets the value of {@link PodSpecProps#getSecurityContext}
         * @param securityContext SecurityContext holds pod-level security attributes and common container settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityContext(org.cdk8s.plus20.PodSecurityContextProps securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        /**
         * Sets the value of {@link PodSpecProps#getServiceAccount}
         * @param serviceAccount A service account provides an identity for processes that run in a Pod.
         *                       When you (a human) access the cluster (for example, using kubectl), you are
         *                       authenticated by the apiserver as a particular User Account (currently this
         *                       is usually admin, unless your cluster administrator has customized your
         *                       cluster). Processes in containers inside pods can also contact the
         *                       apiserver. When they do, they are authenticated as a particular Service
         *                       Account (for example, default).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(org.cdk8s.plus20.IServiceAccount serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        /**
         * Sets the value of {@link PodSpecProps#getVolumes}
         * @param volumes List of volumes that can be mounted by containers belonging to the pod.
         *                You can also add volumes later using <code>podSpec.addVolume()</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends org.cdk8s.plus20.Volume> volumes) {
            this.volumes = (java.util.List<org.cdk8s.plus20.Volume>)volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PodSpecProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PodSpecProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PodSpecProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PodSpecProps {
        private final java.util.List<org.cdk8s.plus20.ContainerProps> containers;
        private final org.cdk8s.plus20.DockerConfigSecret dockerRegistryAuth;
        private final java.util.List<org.cdk8s.plus20.HostAlias> hostAliases;
        private final java.util.List<org.cdk8s.plus20.ContainerProps> initContainers;
        private final org.cdk8s.plus20.RestartPolicy restartPolicy;
        private final org.cdk8s.plus20.PodSecurityContextProps securityContext;
        private final org.cdk8s.plus20.IServiceAccount serviceAccount;
        private final java.util.List<org.cdk8s.plus20.Volume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ContainerProps.class)));
            this.dockerRegistryAuth = software.amazon.jsii.Kernel.get(this, "dockerRegistryAuth", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.DockerConfigSecret.class));
            this.hostAliases = software.amazon.jsii.Kernel.get(this, "hostAliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.HostAlias.class)));
            this.initContainers = software.amazon.jsii.Kernel.get(this, "initContainers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ContainerProps.class)));
            this.restartPolicy = software.amazon.jsii.Kernel.get(this, "restartPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.RestartPolicy.class));
            this.securityContext = software.amazon.jsii.Kernel.get(this, "securityContext", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PodSecurityContextProps.class));
            this.serviceAccount = software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IServiceAccount.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Volume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containers = (java.util.List<org.cdk8s.plus20.ContainerProps>)builder.containers;
            this.dockerRegistryAuth = builder.dockerRegistryAuth;
            this.hostAliases = (java.util.List<org.cdk8s.plus20.HostAlias>)builder.hostAliases;
            this.initContainers = (java.util.List<org.cdk8s.plus20.ContainerProps>)builder.initContainers;
            this.restartPolicy = builder.restartPolicy;
            this.securityContext = builder.securityContext;
            this.serviceAccount = builder.serviceAccount;
            this.volumes = (java.util.List<org.cdk8s.plus20.Volume>)builder.volumes;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.ContainerProps> getContainers() {
            return this.containers;
        }

        @Override
        public final org.cdk8s.plus20.DockerConfigSecret getDockerRegistryAuth() {
            return this.dockerRegistryAuth;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.HostAlias> getHostAliases() {
            return this.hostAliases;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.ContainerProps> getInitContainers() {
            return this.initContainers;
        }

        @Override
        public final org.cdk8s.plus20.RestartPolicy getRestartPolicy() {
            return this.restartPolicy;
        }

        @Override
        public final org.cdk8s.plus20.PodSecurityContextProps getSecurityContext() {
            return this.securityContext;
        }

        @Override
        public final org.cdk8s.plus20.IServiceAccount getServiceAccount() {
            return this.serviceAccount;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContainers() != null) {
                data.set("containers", om.valueToTree(this.getContainers()));
            }
            if (this.getDockerRegistryAuth() != null) {
                data.set("dockerRegistryAuth", om.valueToTree(this.getDockerRegistryAuth()));
            }
            if (this.getHostAliases() != null) {
                data.set("hostAliases", om.valueToTree(this.getHostAliases()));
            }
            if (this.getInitContainers() != null) {
                data.set("initContainers", om.valueToTree(this.getInitContainers()));
            }
            if (this.getRestartPolicy() != null) {
                data.set("restartPolicy", om.valueToTree(this.getRestartPolicy()));
            }
            if (this.getSecurityContext() != null) {
                data.set("securityContext", om.valueToTree(this.getSecurityContext()));
            }
            if (this.getServiceAccount() != null) {
                data.set("serviceAccount", om.valueToTree(this.getServiceAccount()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.PodSpecProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PodSpecProps.Jsii$Proxy that = (PodSpecProps.Jsii$Proxy) o;

            if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) return false;
            if (this.dockerRegistryAuth != null ? !this.dockerRegistryAuth.equals(that.dockerRegistryAuth) : that.dockerRegistryAuth != null) return false;
            if (this.hostAliases != null ? !this.hostAliases.equals(that.hostAliases) : that.hostAliases != null) return false;
            if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) return false;
            if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) return false;
            if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) return false;
            if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containers != null ? this.containers.hashCode() : 0;
            result = 31 * result + (this.dockerRegistryAuth != null ? this.dockerRegistryAuth.hashCode() : 0);
            result = 31 * result + (this.hostAliases != null ? this.hostAliases.hashCode() : 0);
            result = 31 * result + (this.initContainers != null ? this.initContainers.hashCode() : 0);
            result = 31 * result + (this.restartPolicy != null ? this.restartPolicy.hashCode() : 0);
            result = 31 * result + (this.securityContext != null ? this.securityContext.hashCode() : 0);
            result = 31 * result + (this.serviceAccount != null ? this.serviceAccount.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
