package org.cdk8s.plus20;

/**
 * Properties for `AzureDiskPersistentVolume`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.56.0 (build 55e7d15)", date = "2022-04-14T10:16:34.069Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.AzureDiskPersistentVolumeProps")
@software.amazon.jsii.Jsii.Proxy(AzureDiskPersistentVolumeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AzureDiskPersistentVolumeProps extends software.amazon.jsii.JsiiSerializable, org.cdk8s.plus20.PersistentVolumeProps {

    /**
     * The Name of the data disk in the blob storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDiskName();

    /**
     * The URI the data disk in the blob storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDiskUri();

    /**
     * Host Caching mode.
     * <p>
     * Default: - AzureDiskPersistentVolumeCachingMode.NONE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.AzureDiskPersistentVolumeCachingMode getCachingMode() {
        return null;
    }

    /**
     * Filesystem type to mount.
     * <p>
     * Must be a filesystem type supported by the host operating system.
     * <p>
     * Default: 'ext4'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFsType() {
        return null;
    }

    /**
     * Kind of disk.
     * <p>
     * Default: AzureDiskPersistentVolumeKind.SHARED
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.AzureDiskPersistentVolumeKind getKind() {
        return null;
    }

    /**
     * Force the ReadOnly setting in VolumeMounts.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReadOnly() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AzureDiskPersistentVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AzureDiskPersistentVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AzureDiskPersistentVolumeProps> {
        java.lang.String diskName;
        java.lang.String diskUri;
        org.cdk8s.plus20.AzureDiskPersistentVolumeCachingMode cachingMode;
        java.lang.String fsType;
        org.cdk8s.plus20.AzureDiskPersistentVolumeKind kind;
        java.lang.Boolean readOnly;
        java.util.List<org.cdk8s.plus20.PersistentVolumeAccessMode> accessModes;
        org.cdk8s.plus20.IPersistentVolumeClaim claim;
        java.util.List<java.lang.String> mountOptions;
        org.cdk8s.plus20.PersistentVolumeReclaimPolicy reclaimPolicy;
        org.cdk8s.Size storage;
        java.lang.String storageClassName;
        org.cdk8s.plus20.PersistentVolumeMode volumeMode;
        org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getDiskName}
         * @param diskName The Name of the data disk in the blob storage. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diskName(java.lang.String diskName) {
            this.diskName = diskName;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getDiskUri}
         * @param diskUri The URI the data disk in the blob storage. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diskUri(java.lang.String diskUri) {
            this.diskUri = diskUri;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getCachingMode}
         * @param cachingMode Host Caching mode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachingMode(org.cdk8s.plus20.AzureDiskPersistentVolumeCachingMode cachingMode) {
            this.cachingMode = cachingMode;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getFsType}
         * @param fsType Filesystem type to mount.
         *               Must be a filesystem type supported by the host operating system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fsType(java.lang.String fsType) {
            this.fsType = fsType;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getKind}
         * @param kind Kind of disk.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kind(org.cdk8s.plus20.AzureDiskPersistentVolumeKind kind) {
            this.kind = kind;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getReadOnly}
         * @param readOnly Force the ReadOnly setting in VolumeMounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnly(java.lang.Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getAccessModes}
         * @param accessModes Contains all ways the volume can be mounted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder accessModes(java.util.List<? extends org.cdk8s.plus20.PersistentVolumeAccessMode> accessModes) {
            this.accessModes = (java.util.List<org.cdk8s.plus20.PersistentVolumeAccessMode>)accessModes;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getClaim}
         * @param claim Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.
         *              Expected to be non-nil when bound.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder claim(org.cdk8s.plus20.IPersistentVolumeClaim claim) {
            this.claim = claim;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getMountOptions}
         * @param mountOptions A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountOptions(java.util.List<java.lang.String> mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getReclaimPolicy}
         * @param reclaimPolicy When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.
         *                      The reclaim policy tells the cluster what to do with
         *                      the volume after it has been released of its claim.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reclaimPolicy(org.cdk8s.plus20.PersistentVolumeReclaimPolicy reclaimPolicy) {
            this.reclaimPolicy = reclaimPolicy;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getStorage}
         * @param storage What is the storage capacity of this volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storage(org.cdk8s.Size storage) {
            this.storage = storage;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getStorageClassName}
         * @param storageClassName Name of StorageClass to which this persistent volume belongs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClassName(java.lang.String storageClassName) {
            this.storageClassName = storageClassName;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getVolumeMode}
         * @param volumeMode Defines what type of volume is required by the claim.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeMode(org.cdk8s.plus20.PersistentVolumeMode volumeMode) {
            this.volumeMode = volumeMode;
            return this;
        }

        /**
         * Sets the value of {@link AzureDiskPersistentVolumeProps#getMetadata}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(org.cdk8s.ApiObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AzureDiskPersistentVolumeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AzureDiskPersistentVolumeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AzureDiskPersistentVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AzureDiskPersistentVolumeProps {
        private final java.lang.String diskName;
        private final java.lang.String diskUri;
        private final org.cdk8s.plus20.AzureDiskPersistentVolumeCachingMode cachingMode;
        private final java.lang.String fsType;
        private final org.cdk8s.plus20.AzureDiskPersistentVolumeKind kind;
        private final java.lang.Boolean readOnly;
        private final java.util.List<org.cdk8s.plus20.PersistentVolumeAccessMode> accessModes;
        private final org.cdk8s.plus20.IPersistentVolumeClaim claim;
        private final java.util.List<java.lang.String> mountOptions;
        private final org.cdk8s.plus20.PersistentVolumeReclaimPolicy reclaimPolicy;
        private final org.cdk8s.Size storage;
        private final java.lang.String storageClassName;
        private final org.cdk8s.plus20.PersistentVolumeMode volumeMode;
        private final org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.diskName = software.amazon.jsii.Kernel.get(this, "diskName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.diskUri = software.amazon.jsii.Kernel.get(this, "diskUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cachingMode = software.amazon.jsii.Kernel.get(this, "cachingMode", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.AzureDiskPersistentVolumeCachingMode.class));
            this.fsType = software.amazon.jsii.Kernel.get(this, "fsType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kind = software.amazon.jsii.Kernel.get(this, "kind", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.AzureDiskPersistentVolumeKind.class));
            this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.accessModes = software.amazon.jsii.Kernel.get(this, "accessModes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PersistentVolumeAccessMode.class)));
            this.claim = software.amazon.jsii.Kernel.get(this, "claim", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IPersistentVolumeClaim.class));
            this.mountOptions = software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.reclaimPolicy = software.amazon.jsii.Kernel.get(this, "reclaimPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PersistentVolumeReclaimPolicy.class));
            this.storage = software.amazon.jsii.Kernel.get(this, "storage", software.amazon.jsii.NativeType.forClass(org.cdk8s.Size.class));
            this.storageClassName = software.amazon.jsii.Kernel.get(this, "storageClassName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumeMode = software.amazon.jsii.Kernel.get(this, "volumeMode", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.PersistentVolumeMode.class));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadata.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.diskName = java.util.Objects.requireNonNull(builder.diskName, "diskName is required");
            this.diskUri = java.util.Objects.requireNonNull(builder.diskUri, "diskUri is required");
            this.cachingMode = builder.cachingMode;
            this.fsType = builder.fsType;
            this.kind = builder.kind;
            this.readOnly = builder.readOnly;
            this.accessModes = (java.util.List<org.cdk8s.plus20.PersistentVolumeAccessMode>)builder.accessModes;
            this.claim = builder.claim;
            this.mountOptions = builder.mountOptions;
            this.reclaimPolicy = builder.reclaimPolicy;
            this.storage = builder.storage;
            this.storageClassName = builder.storageClassName;
            this.volumeMode = builder.volumeMode;
            this.metadata = builder.metadata;
        }

        @Override
        public final java.lang.String getDiskName() {
            return this.diskName;
        }

        @Override
        public final java.lang.String getDiskUri() {
            return this.diskUri;
        }

        @Override
        public final org.cdk8s.plus20.AzureDiskPersistentVolumeCachingMode getCachingMode() {
            return this.cachingMode;
        }

        @Override
        public final java.lang.String getFsType() {
            return this.fsType;
        }

        @Override
        public final org.cdk8s.plus20.AzureDiskPersistentVolumeKind getKind() {
            return this.kind;
        }

        @Override
        public final java.lang.Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.PersistentVolumeAccessMode> getAccessModes() {
            return this.accessModes;
        }

        @Override
        public final org.cdk8s.plus20.IPersistentVolumeClaim getClaim() {
            return this.claim;
        }

        @Override
        public final java.util.List<java.lang.String> getMountOptions() {
            return this.mountOptions;
        }

        @Override
        public final org.cdk8s.plus20.PersistentVolumeReclaimPolicy getReclaimPolicy() {
            return this.reclaimPolicy;
        }

        @Override
        public final org.cdk8s.Size getStorage() {
            return this.storage;
        }

        @Override
        public final java.lang.String getStorageClassName() {
            return this.storageClassName;
        }

        @Override
        public final org.cdk8s.plus20.PersistentVolumeMode getVolumeMode() {
            return this.volumeMode;
        }

        @Override
        public final org.cdk8s.ApiObjectMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("diskName", om.valueToTree(this.getDiskName()));
            data.set("diskUri", om.valueToTree(this.getDiskUri()));
            if (this.getCachingMode() != null) {
                data.set("cachingMode", om.valueToTree(this.getCachingMode()));
            }
            if (this.getFsType() != null) {
                data.set("fsType", om.valueToTree(this.getFsType()));
            }
            if (this.getKind() != null) {
                data.set("kind", om.valueToTree(this.getKind()));
            }
            if (this.getReadOnly() != null) {
                data.set("readOnly", om.valueToTree(this.getReadOnly()));
            }
            if (this.getAccessModes() != null) {
                data.set("accessModes", om.valueToTree(this.getAccessModes()));
            }
            if (this.getClaim() != null) {
                data.set("claim", om.valueToTree(this.getClaim()));
            }
            if (this.getMountOptions() != null) {
                data.set("mountOptions", om.valueToTree(this.getMountOptions()));
            }
            if (this.getReclaimPolicy() != null) {
                data.set("reclaimPolicy", om.valueToTree(this.getReclaimPolicy()));
            }
            if (this.getStorage() != null) {
                data.set("storage", om.valueToTree(this.getStorage()));
            }
            if (this.getStorageClassName() != null) {
                data.set("storageClassName", om.valueToTree(this.getStorageClassName()));
            }
            if (this.getVolumeMode() != null) {
                data.set("volumeMode", om.valueToTree(this.getVolumeMode()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.AzureDiskPersistentVolumeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AzureDiskPersistentVolumeProps.Jsii$Proxy that = (AzureDiskPersistentVolumeProps.Jsii$Proxy) o;

            if (!diskName.equals(that.diskName)) return false;
            if (!diskUri.equals(that.diskUri)) return false;
            if (this.cachingMode != null ? !this.cachingMode.equals(that.cachingMode) : that.cachingMode != null) return false;
            if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) return false;
            if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) return false;
            if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
            if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) return false;
            if (this.claim != null ? !this.claim.equals(that.claim) : that.claim != null) return false;
            if (this.mountOptions != null ? !this.mountOptions.equals(that.mountOptions) : that.mountOptions != null) return false;
            if (this.reclaimPolicy != null ? !this.reclaimPolicy.equals(that.reclaimPolicy) : that.reclaimPolicy != null) return false;
            if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) return false;
            if (this.storageClassName != null ? !this.storageClassName.equals(that.storageClassName) : that.storageClassName != null) return false;
            if (this.volumeMode != null ? !this.volumeMode.equals(that.volumeMode) : that.volumeMode != null) return false;
            return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
        }

        @Override
        public final int hashCode() {
            int result = this.diskName.hashCode();
            result = 31 * result + (this.diskUri.hashCode());
            result = 31 * result + (this.cachingMode != null ? this.cachingMode.hashCode() : 0);
            result = 31 * result + (this.fsType != null ? this.fsType.hashCode() : 0);
            result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
            result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
            result = 31 * result + (this.accessModes != null ? this.accessModes.hashCode() : 0);
            result = 31 * result + (this.claim != null ? this.claim.hashCode() : 0);
            result = 31 * result + (this.mountOptions != null ? this.mountOptions.hashCode() : 0);
            result = 31 * result + (this.reclaimPolicy != null ? this.reclaimPolicy.hashCode() : 0);
            result = 31 * result + (this.storage != null ? this.storage.hashCode() : 0);
            result = 31 * result + (this.storageClassName != null ? this.storageClassName.hashCode() : 0);
            result = 31 * result + (this.volumeMode != null ? this.volumeMode.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            return result;
        }
    }
}
