package org.cdk8s.plus20;

/**
 * Provides read/write capabilities ontop of a `PodTemplateProps`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.38.0 (build 717bef2)", date = "2021-10-10T01:09:06.200Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.PodTemplate")
public class PodTemplate extends org.cdk8s.plus20.PodSpec implements org.cdk8s.plus20.IPodTemplate {

    protected PodTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PodTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PodTemplate(final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.PodTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PodTemplate() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Provides read/write access to the underlying pod metadata of the resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.ApiObjectMetadataDefinition getPodMetadata() {
        return software.amazon.jsii.Kernel.get(this, "podMetadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadataDefinition.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus20.PodTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus20.PodTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private org.cdk8s.plus20.PodTemplateProps.Builder props;

        private Builder() {
        }

        /**
         * List of containers belonging to the pod.
         * <p>
         * Containers cannot currently be
         * added or removed. There must be at least one container in a Pod.
         * <p>
         * You can add additionnal containers using <code>podSpec.addContainer()</code>
         * <p>
         * Default: - No containers. Note that a pod spec must include at least one container.
         * <p>
         * @return {@code this}
         * @param containers List of containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(final java.util.List<? extends org.cdk8s.plus20.ContainerProps> containers) {
            this.props().containers(containers);
            return this;
        }

        /**
         * Restart policy for all containers within the pod.
         * <p>
         * Default: RestartPolicy.ALWAYS
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
         * @param restartPolicy Restart policy for all containers within the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartPolicy(final org.cdk8s.plus20.RestartPolicy restartPolicy) {
            this.props().restartPolicy(restartPolicy);
            return this;
        }

        /**
         * A service account provides an identity for processes that run in a Pod.
         * <p>
         * When you (a human) access the cluster (for example, using kubectl), you are
         * authenticated by the apiserver as a particular User Account (currently this
         * is usually admin, unless your cluster administrator has customized your
         * cluster). Processes in containers inside pods can also contact the
         * apiserver. When they do, they are authenticated as a particular Service
         * Account (for example, default).
         * <p>
         * Default: - No service account.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
         * @param serviceAccount A service account provides an identity for processes that run in a Pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(final org.cdk8s.plus20.IServiceAccount serviceAccount) {
            this.props().serviceAccount(serviceAccount);
            return this;
        }

        /**
         * List of volumes that can be mounted by containers belonging to the pod.
         * <p>
         * You can also add volumes later using <code>podSpec.addVolume()</code>
         * <p>
         * Default: - No volumes.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/volumes
         * @param volumes List of volumes that can be mounted by containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends org.cdk8s.plus20.Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * The pod metadata.
         * <p>
         * @return {@code this}
         * @param podMetadata The pod metadata. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podMetadata(final org.cdk8s.ApiObjectMetadata podMetadata) {
            this.props().podMetadata(podMetadata);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus20.PodTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus20.PodTemplate build() {
            return new org.cdk8s.plus20.PodTemplate(
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus20.PodTemplateProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus20.PodTemplateProps.Builder();
            }
            return this.props;
        }
    }
}
