package org.cdk8s.plus20;

/**
 * Properties for creating a container.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.56.0 (build 55e7d15)", date = "2022-04-13T14:52:28.839Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.ContainerProps")
@software.amazon.jsii.Jsii.Proxy(ContainerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContainerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Docker image name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getImage();

    /**
     * Arguments to the entrypoint. The docker image's CMD is used if `command` is not provided.
     * <p>
     * Variable references $(VAR_NAME) are expanded using the container's
     * environment. If a variable cannot be resolved, the reference in the input
     * string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
     * double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
     * regardless of whether the variable exists or not.
     * <p>
     * Cannot be updated.
     * <p>
     * Default: []
     * <p>
     * @see https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
        return null;
    }

    /**
     * Entrypoint array.
     * <p>
     * Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment.
     * If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
     * Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated.
     * More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     * <p>
     * Default: - The docker image's ENTRYPOINT.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * List of environment variables to set in the container.
     * <p>
     * Cannot be updated.
     * <p>
     * Default: - No environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, org.cdk8s.plus20.EnvValue> getEnv() {
        return null;
    }

    /**
     * Image pull policy for this container.
     * <p>
     * Default: ImagePullPolicy.ALWAYS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.ImagePullPolicy getImagePullPolicy() {
        return null;
    }

    /**
     * Describes actions that the management system should take in response to container lifecycle events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.ContainerLifecycle getLifecycle() {
        return null;
    }

    /**
     * Periodic probe of container liveness.
     * <p>
     * Container will be restarted if the probe fails.
     * <p>
     * Default: - no liveness probe is defined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.Probe getLiveness() {
        return null;
    }

    /**
     * Name of the container specified as a DNS_LABEL.
     * <p>
     * Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
     * <p>
     * Default: 'main'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Number of port to expose on the pod's IP address.
     * <p>
     * This must be a valid port number, 0 &lt; x &lt; 65536.
     * <p>
     * Default: - No port is exposed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * Determines when the container is ready to serve traffic.
     * <p>
     * Default: - no readiness probe is defined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.Probe getReadiness() {
        return null;
    }

    /**
     * Compute resources (CPU and memory requests and limits) required by the container.
     * <p>
     * @see https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.Resources getResources() {
        return null;
    }

    /**
     * SecurityContext defines the security options the container should be run with.
     * <p>
     * If set, the fields override equivalent fields of the pod's security context.
     * <p>
     * Default:   ensureNonRoot: false
     *   privileged: false
     *   readOnlyRootFilesystem: false
     * <p>
     * @see https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.ContainerSecurityContextProps getSecurityContext() {
        return null;
    }

    /**
     * StartupProbe indicates that the Pod has successfully initialized.
     * <p>
     * If specified, no other probes are executed until this completes successfully
     * <p>
     * Default: - no startup probe is defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.Probe getStartup() {
        return null;
    }

    /**
     * Pod volumes to mount into the container's filesystem.
     * <p>
     * Cannot be updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus20.VolumeMount> getVolumeMounts() {
        return null;
    }

    /**
     * Container's working directory.
     * <p>
     * If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
     * <p>
     * Default: - The container runtime's default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDir() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerProps> {
        java.lang.String image;
        java.util.List<java.lang.String> args;
        java.util.List<java.lang.String> command;
        java.util.Map<java.lang.String, org.cdk8s.plus20.EnvValue> env;
        org.cdk8s.plus20.ImagePullPolicy imagePullPolicy;
        org.cdk8s.plus20.ContainerLifecycle lifecycle;
        org.cdk8s.plus20.Probe liveness;
        java.lang.String name;
        java.lang.Number port;
        org.cdk8s.plus20.Probe readiness;
        org.cdk8s.plus20.Resources resources;
        org.cdk8s.plus20.ContainerSecurityContextProps securityContext;
        org.cdk8s.plus20.Probe startup;
        java.util.List<org.cdk8s.plus20.VolumeMount> volumeMounts;
        java.lang.String workingDir;

        /**
         * Sets the value of {@link ContainerProps#getImage}
         * @param image Docker image name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(java.lang.String image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getArgs}
         * @param args Arguments to the entrypoint. The docker image's CMD is used if `command` is not provided.
         *             Variable references $(VAR_NAME) are expanded using the container's
         *             environment. If a variable cannot be resolved, the reference in the input
         *             string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
         *             double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
         *             regardless of whether the variable exists or not.
         *             <p>
         *             Cannot be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder args(java.util.List<java.lang.String> args) {
            this.args = args;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getCommand}
         * @param command Entrypoint array.
         *                Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment.
         *                If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
         *                Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated.
         *                More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getEnv}
         * @param env List of environment variables to set in the container.
         *            Cannot be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder env(java.util.Map<java.lang.String, ? extends org.cdk8s.plus20.EnvValue> env) {
            this.env = (java.util.Map<java.lang.String, org.cdk8s.plus20.EnvValue>)env;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getImagePullPolicy}
         * @param imagePullPolicy Image pull policy for this container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imagePullPolicy(org.cdk8s.plus20.ImagePullPolicy imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getLifecycle}
         * @param lifecycle Describes actions that the management system should take in response to container lifecycle events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycle(org.cdk8s.plus20.ContainerLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getLiveness}
         * @param liveness Periodic probe of container liveness.
         *                 Container will be restarted if the probe fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder liveness(org.cdk8s.plus20.Probe liveness) {
            this.liveness = liveness;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getName}
         * @param name Name of the container specified as a DNS_LABEL.
         *             Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getPort}
         * @param port Number of port to expose on the pod's IP address.
         *             This must be a valid port number, 0 &lt; x &lt; 65536.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getReadiness}
         * @param readiness Determines when the container is ready to serve traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readiness(org.cdk8s.plus20.Probe readiness) {
            this.readiness = readiness;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getResources}
         * @param resources Compute resources (CPU and memory requests and limits) required by the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(org.cdk8s.plus20.Resources resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getSecurityContext}
         * @param securityContext SecurityContext defines the security options the container should be run with.
         *                        If set, the fields override equivalent fields of the pod's security context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityContext(org.cdk8s.plus20.ContainerSecurityContextProps securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getStartup}
         * @param startup StartupProbe indicates that the Pod has successfully initialized.
         *                If specified, no other probes are executed until this completes successfully
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startup(org.cdk8s.plus20.Probe startup) {
            this.startup = startup;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getVolumeMounts}
         * @param volumeMounts Pod volumes to mount into the container's filesystem.
         *                     Cannot be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumeMounts(java.util.List<? extends org.cdk8s.plus20.VolumeMount> volumeMounts) {
            this.volumeMounts = (java.util.List<org.cdk8s.plus20.VolumeMount>)volumeMounts;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getWorkingDir}
         * @param workingDir Container's working directory.
         *                   If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDir(java.lang.String workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContainerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerProps {
        private final java.lang.String image;
        private final java.util.List<java.lang.String> args;
        private final java.util.List<java.lang.String> command;
        private final java.util.Map<java.lang.String, org.cdk8s.plus20.EnvValue> env;
        private final org.cdk8s.plus20.ImagePullPolicy imagePullPolicy;
        private final org.cdk8s.plus20.ContainerLifecycle lifecycle;
        private final org.cdk8s.plus20.Probe liveness;
        private final java.lang.String name;
        private final java.lang.Number port;
        private final org.cdk8s.plus20.Probe readiness;
        private final org.cdk8s.plus20.Resources resources;
        private final org.cdk8s.plus20.ContainerSecurityContextProps securityContext;
        private final org.cdk8s.plus20.Probe startup;
        private final java.util.List<org.cdk8s.plus20.VolumeMount> volumeMounts;
        private final java.lang.String workingDir;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.EnvValue.class)));
            this.imagePullPolicy = software.amazon.jsii.Kernel.get(this, "imagePullPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ImagePullPolicy.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ContainerLifecycle.class));
            this.liveness = software.amazon.jsii.Kernel.get(this, "liveness", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Probe.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.readiness = software.amazon.jsii.Kernel.get(this, "readiness", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Probe.class));
            this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Resources.class));
            this.securityContext = software.amazon.jsii.Kernel.get(this, "securityContext", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ContainerSecurityContextProps.class));
            this.startup = software.amazon.jsii.Kernel.get(this, "startup", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Probe.class));
            this.volumeMounts = software.amazon.jsii.Kernel.get(this, "volumeMounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.VolumeMount.class)));
            this.workingDir = software.amazon.jsii.Kernel.get(this, "workingDir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
            this.args = builder.args;
            this.command = builder.command;
            this.env = (java.util.Map<java.lang.String, org.cdk8s.plus20.EnvValue>)builder.env;
            this.imagePullPolicy = builder.imagePullPolicy;
            this.lifecycle = builder.lifecycle;
            this.liveness = builder.liveness;
            this.name = builder.name;
            this.port = builder.port;
            this.readiness = builder.readiness;
            this.resources = builder.resources;
            this.securityContext = builder.securityContext;
            this.startup = builder.startup;
            this.volumeMounts = (java.util.List<org.cdk8s.plus20.VolumeMount>)builder.volumeMounts;
            this.workingDir = builder.workingDir;
        }

        @Override
        public final java.lang.String getImage() {
            return this.image;
        }

        @Override
        public final java.util.List<java.lang.String> getArgs() {
            return this.args;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.Map<java.lang.String, org.cdk8s.plus20.EnvValue> getEnv() {
            return this.env;
        }

        @Override
        public final org.cdk8s.plus20.ImagePullPolicy getImagePullPolicy() {
            return this.imagePullPolicy;
        }

        @Override
        public final org.cdk8s.plus20.ContainerLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final org.cdk8s.plus20.Probe getLiveness() {
            return this.liveness;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final org.cdk8s.plus20.Probe getReadiness() {
            return this.readiness;
        }

        @Override
        public final org.cdk8s.plus20.Resources getResources() {
            return this.resources;
        }

        @Override
        public final org.cdk8s.plus20.ContainerSecurityContextProps getSecurityContext() {
            return this.securityContext;
        }

        @Override
        public final org.cdk8s.plus20.Probe getStartup() {
            return this.startup;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.VolumeMount> getVolumeMounts() {
            return this.volumeMounts;
        }

        @Override
        public final java.lang.String getWorkingDir() {
            return this.workingDir;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("image", om.valueToTree(this.getImage()));
            if (this.getArgs() != null) {
                data.set("args", om.valueToTree(this.getArgs()));
            }
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getImagePullPolicy() != null) {
                data.set("imagePullPolicy", om.valueToTree(this.getImagePullPolicy()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getLiveness() != null) {
                data.set("liveness", om.valueToTree(this.getLiveness()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getReadiness() != null) {
                data.set("readiness", om.valueToTree(this.getReadiness()));
            }
            if (this.getResources() != null) {
                data.set("resources", om.valueToTree(this.getResources()));
            }
            if (this.getSecurityContext() != null) {
                data.set("securityContext", om.valueToTree(this.getSecurityContext()));
            }
            if (this.getStartup() != null) {
                data.set("startup", om.valueToTree(this.getStartup()));
            }
            if (this.getVolumeMounts() != null) {
                data.set("volumeMounts", om.valueToTree(this.getVolumeMounts()));
            }
            if (this.getWorkingDir() != null) {
                data.set("workingDir", om.valueToTree(this.getWorkingDir()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.ContainerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerProps.Jsii$Proxy that = (ContainerProps.Jsii$Proxy) o;

            if (!image.equals(that.image)) return false;
            if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals(that.imagePullPolicy) : that.imagePullPolicy != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.liveness != null ? !this.liveness.equals(that.liveness) : that.liveness != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.readiness != null ? !this.readiness.equals(that.readiness) : that.readiness != null) return false;
            if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
            if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) return false;
            if (this.startup != null ? !this.startup.equals(that.startup) : that.startup != null) return false;
            if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) return false;
            return this.workingDir != null ? this.workingDir.equals(that.workingDir) : that.workingDir == null;
        }

        @Override
        public final int hashCode() {
            int result = this.image.hashCode();
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.imagePullPolicy != null ? this.imagePullPolicy.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.liveness != null ? this.liveness.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.readiness != null ? this.readiness.hashCode() : 0);
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            result = 31 * result + (this.securityContext != null ? this.securityContext.hashCode() : 0);
            result = 31 * result + (this.startup != null ? this.startup.hashCode() : 0);
            result = 31 * result + (this.volumeMounts != null ? this.volumeMounts.hashCode() : 0);
            result = 31 * result + (this.workingDir != null ? this.workingDir.hashCode() : 0);
            return result;
        }
    }
}
