/*
 * Decompiled with CFR 0.152.
 */
package org.cdk8s.plus20;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cdk8s.plus20.;
import org.cdk8s.plus20.Container;
import org.cdk8s.plus20.ContainerProps;
import org.cdk8s.plus20.HostAlias;
import org.cdk8s.plus20.IPodSpec;
import org.cdk8s.plus20.IServiceAccount;
import org.cdk8s.plus20.PodSecurityContext;
import org.cdk8s.plus20.PodSecurityContextProps;
import org.cdk8s.plus20.PodSpecProps;
import org.cdk8s.plus20.RestartPolicy;
import org.cdk8s.plus20.Volume;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="cdk8s-plus-20.PodSpec")
public class PodSpec
extends JsiiObject
implements IPodSpec {
    protected PodSpec(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PodSpec(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public PodSpec(@Nullable PodSpecProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{props});
    }

    public PodSpec() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    @Override
    @NotNull
    public Container addContainer(@NotNull ContainerProps container) {
        return (Container)((Object)Kernel.call((Object)this, (String)"addContainer", (NativeType)NativeType.forClass(Container.class), (Object[])new Object[]{Objects.requireNonNull(container, "container is required")}));
    }

    public void addHostAlias(@NotNull HostAlias hostAlias) {
        Kernel.call((Object)this, (String)"addHostAlias", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(hostAlias, "hostAlias is required")});
    }

    @Override
    @NotNull
    public Container addInitContainer(@NotNull ContainerProps container) {
        return (Container)((Object)Kernel.call((Object)this, (String)"addInitContainer", (NativeType)NativeType.forClass(Container.class), (Object[])new Object[]{Objects.requireNonNull(container, "container is required")}));
    }

    @Override
    public void addVolume(@NotNull Volume volume) {
        Kernel.call((Object)this, (String)"addVolume", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(volume, "volume is required")});
    }

    @Override
    @NotNull
    public List<Container> getContainers() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"containers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Container.class))));
    }

    @Override
    @NotNull
    public List<HostAlias> getHostAliases() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"hostAliases", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(HostAlias.class))));
    }

    @Override
    @NotNull
    public List<Container> getInitContainers() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"initContainers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Container.class))));
    }

    @NotNull
    public PodSecurityContext getSecurityContext() {
        return (PodSecurityContext)((Object)Kernel.get((Object)this, (String)"securityContext", (NativeType)NativeType.forClass(PodSecurityContext.class)));
    }

    @Override
    @NotNull
    public List<Volume> getVolumes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"volumes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Volume.class))));
    }

    @Override
    @Nullable
    public RestartPolicy getRestartPolicy() {
        return (RestartPolicy)((Object)Kernel.get((Object)this, (String)"restartPolicy", (NativeType)NativeType.forClass(RestartPolicy.class)));
    }

    @Override
    @Nullable
    public IServiceAccount getServiceAccount() {
        return (IServiceAccount)Kernel.get((Object)this, (String)"serviceAccount", (NativeType)NativeType.forClass(IServiceAccount.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<PodSpec> {
        private PodSpecProps.Builder props;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder containers(List<? extends ContainerProps> containers) {
            this.props().containers(containers);
            return this;
        }

        public Builder hostAliases(List<? extends HostAlias> hostAliases) {
            this.props().hostAliases(hostAliases);
            return this;
        }

        public Builder initContainers(List<? extends ContainerProps> initContainers) {
            this.props().initContainers(initContainers);
            return this;
        }

        public Builder restartPolicy(RestartPolicy restartPolicy) {
            this.props().restartPolicy(restartPolicy);
            return this;
        }

        public Builder securityContext(PodSecurityContextProps securityContext) {
            this.props().securityContext(securityContext);
            return this;
        }

        public Builder serviceAccount(IServiceAccount serviceAccount) {
            this.props().serviceAccount(serviceAccount);
            return this;
        }

        public Builder volumes(List<? extends Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        public PodSpec build() {
            return new PodSpec(this.props != null ? this.props.build() : null);
        }

        private PodSpecProps.Builder props() {
            if (this.props == null) {
                this.props = new PodSpecProps.Builder();
            }
            return this.props;
        }
    }
}

