/*
 * Decompiled with CFR 0.152.
 */
package org.cdk8s.plus20;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cdk8s.ApiObject;
import org.cdk8s.ApiObjectMetadata;
import org.cdk8s.ApiObjectMetadataDefinition;
import org.cdk8s.plus20.$Module;
import org.cdk8s.plus20.Container;
import org.cdk8s.plus20.ContainerProps;
import org.cdk8s.plus20.DeploymentProps;
import org.cdk8s.plus20.ExposeDeploymentViaIngressOptions;
import org.cdk8s.plus20.ExposeDeploymentViaServiceOptions;
import org.cdk8s.plus20.IPodTemplate;
import org.cdk8s.plus20.IServiceAccount;
import org.cdk8s.plus20.IngressV1Beta1;
import org.cdk8s.plus20.Resource;
import org.cdk8s.plus20.RestartPolicy;
import org.cdk8s.plus20.Service;
import org.cdk8s.plus20.Volume;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="cdk8s-plus-20.Deployment")
public class Deployment
extends Resource
implements IPodTemplate {
    protected Deployment(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Deployment(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Deployment(@NotNull Construct scope, @NotNull String id, @Nullable DeploymentProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Deployment(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Container addContainer(@NotNull ContainerProps container) {
        return (Container)((Object)Kernel.call((Object)this, (String)"addContainer", (NativeType)NativeType.forClass(Container.class), (Object[])new Object[]{Objects.requireNonNull(container, "container is required")}));
    }

    @Override
    @NotNull
    public Container addInitContainer(@NotNull ContainerProps container) {
        return (Container)((Object)Kernel.call((Object)this, (String)"addInitContainer", (NativeType)NativeType.forClass(Container.class), (Object[])new Object[]{Objects.requireNonNull(container, "container is required")}));
    }

    @Override
    public void addVolume(@NotNull Volume volume) {
        Kernel.call((Object)this, (String)"addVolume", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(volume, "volume is required")});
    }

    @NotNull
    public IngressV1Beta1 exposeViaIngress(@NotNull String path, @Nullable ExposeDeploymentViaIngressOptions options) {
        return (IngressV1Beta1)Kernel.call((Object)this, (String)"exposeViaIngress", (NativeType)NativeType.forClass(IngressV1Beta1.class), (Object[])new Object[]{Objects.requireNonNull(path, "path is required"), options});
    }

    @NotNull
    public IngressV1Beta1 exposeViaIngress(@NotNull String path) {
        return (IngressV1Beta1)Kernel.call((Object)this, (String)"exposeViaIngress", (NativeType)NativeType.forClass(IngressV1Beta1.class), (Object[])new Object[]{Objects.requireNonNull(path, "path is required")});
    }

    @NotNull
    public Service exposeViaService(@Nullable ExposeDeploymentViaServiceOptions options) {
        return (Service)Kernel.call((Object)this, (String)"exposeViaService", (NativeType)NativeType.forClass(Service.class), (Object[])new Object[]{options});
    }

    @NotNull
    public Service exposeViaService() {
        return (Service)Kernel.call((Object)this, (String)"exposeViaService", (NativeType)NativeType.forClass(Service.class), (Object[])new Object[0]);
    }

    public void selectByLabel(@NotNull String key, @NotNull String value) {
        Kernel.call((Object)this, (String)"selectByLabel", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required")});
    }

    @Override
    @NotNull
    protected ApiObject getApiObject() {
        return (ApiObject)Kernel.get((Object)this, (String)"apiObject", (NativeType)NativeType.forClass(ApiObject.class));
    }

    @Override
    @NotNull
    public List<Container> getContainers() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"containers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Container.class))));
    }

    @Override
    @NotNull
    public List<Container> getInitContainers() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"initContainers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Container.class))));
    }

    @NotNull
    public Map<String, String> getLabelSelector() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"labelSelector", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @Override
    @NotNull
    public ApiObjectMetadataDefinition getPodMetadata() {
        return (ApiObjectMetadataDefinition)Kernel.get((Object)this, (String)"podMetadata", (NativeType)NativeType.forClass(ApiObjectMetadataDefinition.class));
    }

    @NotNull
    public Number getReplicas() {
        return (Number)Kernel.get((Object)this, (String)"replicas", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @NotNull
    public List<Volume> getVolumes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"volumes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Volume.class))));
    }

    @Override
    @Nullable
    public RestartPolicy getRestartPolicy() {
        return (RestartPolicy)((Object)Kernel.get((Object)this, (String)"restartPolicy", (NativeType)NativeType.forClass(RestartPolicy.class)));
    }

    @Override
    @Nullable
    public IServiceAccount getServiceAccount() {
        return (IServiceAccount)Kernel.get((Object)this, (String)"serviceAccount", (NativeType)NativeType.forClass(IServiceAccount.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Deployment> {
        private final Construct scope;
        private final String id;
        private DeploymentProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder metadata(ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        public Builder containers(List<? extends ContainerProps> containers) {
            this.props().containers(containers);
            return this;
        }

        public Builder initContainers(List<? extends ContainerProps> initContainers) {
            this.props().initContainers(initContainers);
            return this;
        }

        public Builder restartPolicy(RestartPolicy restartPolicy) {
            this.props().restartPolicy(restartPolicy);
            return this;
        }

        public Builder serviceAccount(IServiceAccount serviceAccount) {
            this.props().serviceAccount(serviceAccount);
            return this;
        }

        public Builder volumes(List<? extends Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        public Builder podMetadata(ApiObjectMetadata podMetadata) {
            this.props().podMetadata(podMetadata);
            return this;
        }

        public Builder defaultSelector(Boolean defaultSelector) {
            this.props().defaultSelector(defaultSelector);
            return this;
        }

        public Builder replicas(Number replicas) {
            this.props().replicas(replicas);
            return this;
        }

        public Deployment build() {
            return new Deployment(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private DeploymentProps.Builder props() {
            if (this.props == null) {
                this.props = new DeploymentProps.Builder();
            }
            return this.props;
        }
    }
}

