package org.cdk8s.plus20;

/**
 * Represents a resource that can be configured with a kuberenets pod spec. (e.g `Deployment`, `Job`, `Pod`, ...).
 * <p>
 * Use the <code>PodSpec</code> class as an implementation helper.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.56.0 (build 55e7d15)", date = "2022-04-13T09:05:50.571Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.IPodSpec")
@software.amazon.jsii.Jsii.Proxy(IPodSpec.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPodSpec extends software.amazon.jsii.JsiiSerializable {

    /**
     * The containers belonging to the pod.
     * <p>
     * Use <code>addContainer</code> to add containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.Container> getContainers();

    /**
     * The volumes associated with this pod.
     * <p>
     * Use <code>addVolume</code> to add volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.Volume> getVolumes();

    /**
     * Restart policy for all containers within the pod.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.RestartPolicy getRestartPolicy() {
        return null;
    }

    /**
     * The service account used to run this pod.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.IServiceAccount getServiceAccount() {
        return null;
    }

    /**
     * Add a container to the pod.
     * <p>
     * @param container The container. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Container addContainer(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.ContainerProps container);

    /**
     * Add a volume to the pod.
     * <p>
     * @param volume The volume. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addVolume(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Volume volume);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements org.cdk8s.plus20.IPodSpec.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The containers belonging to the pod.
         * <p>
         * Use <code>addContainer</code> to add containers.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.Container> getContainers() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Container.class))));
        }

        /**
         * The volumes associated with this pod.
         * <p>
         * Use <code>addVolume</code> to add volumes.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.Volume> getVolumes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Volume.class))));
        }

        /**
         * Restart policy for all containers within the pod.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.RestartPolicy getRestartPolicy() {
            return software.amazon.jsii.Kernel.get(this, "restartPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.RestartPolicy.class));
        }

        /**
         * The service account used to run this pod.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.IServiceAccount getServiceAccount() {
            return software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IServiceAccount.class));
        }

        /**
         * Add a container to the pod.
         * <p>
         * @param container The container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Container addContainer(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.ContainerProps container) {
            return software.amazon.jsii.Kernel.call(this, "addContainer", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Container.class), new Object[] { java.util.Objects.requireNonNull(container, "container is required") });
        }

        /**
         * Add a volume to the pod.
         * <p>
         * @param volume The volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addVolume(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Volume volume) {
            software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
        }
    }

    /**
     * Internal default implementation for {@link IPodSpec}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IPodSpec {

        /**
         * The containers belonging to the pod.
         * <p>
         * Use <code>addContainer</code> to add containers.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.Container> getContainers() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Container.class))));
        }

        /**
         * The volumes associated with this pod.
         * <p>
         * Use <code>addVolume</code> to add volumes.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.Volume> getVolumes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Volume.class))));
        }

        /**
         * Restart policy for all containers within the pod.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.RestartPolicy getRestartPolicy() {
            return software.amazon.jsii.Kernel.get(this, "restartPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.RestartPolicy.class));
        }

        /**
         * The service account used to run this pod.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.IServiceAccount getServiceAccount() {
            return software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IServiceAccount.class));
        }

        /**
         * Add a container to the pod.
         * <p>
         * @param container The container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Container addContainer(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.ContainerProps container) {
            return software.amazon.jsii.Kernel.call(this, "addContainer", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Container.class), new Object[] { java.util.Objects.requireNonNull(container, "container is required") });
        }

        /**
         * Add a volume to the pod.
         * <p>
         * @param volume The volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addVolume(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Volume volume) {
            software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
        }
    }
}
