package org.cdk8s.plus20;

/**
 * An abstract way to expose an application running on a set of Pods as a network service.
 * <p>
 * With Kubernetes you don't need to modify your application to use an unfamiliar service discovery mechanism.
 * Kubernetes gives Pods their own IP addresses and a single DNS name for a set of Pods, and can load-balance across them.
 * <p>
 * For example, consider a stateless image-processing backend which is running with 3 replicas. Those replicas are fungible—frontends do not care which backend they use.
 * While the actual Pods that compose the backend set may change, the frontend clients should not need to be aware of that,
 * nor should they need to keep track of the set of backends themselves.
 * The Service abstraction enables this decoupling.
 * <p>
 * If you're able to use Kubernetes APIs for service discovery in your application, you can query the API server for Endpoints,
 * that get updated whenever the set of Pods in a Service changes. For non-native applications, Kubernetes offers ways to place a network port
 * or load balancer in between your application and the backend Pods.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-03-18T02:34:03.921Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.Service")
public class Service extends org.cdk8s.plus20.Resource {

    protected Service(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Service(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Service(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.ServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Service(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Associate a deployment to this service.
     * <p>
     * If not targetPort is specific in the portOptions, then requests will be routed
     * to the port exposed by the first container in the deployment's pods.
     * The deployment's <code>labelSelector</code> will be used to select pods.
     * <p>
     * @param deployment The deployment to expose. This parameter is required.
     * @param options Optional settings for the port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDeployment(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Deployment deployment, final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.AddDeploymentOptions options) {
        software.amazon.jsii.Kernel.call(this, "addDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(deployment, "deployment is required"), options });
    }

    /**
     * Associate a deployment to this service.
     * <p>
     * If not targetPort is specific in the portOptions, then requests will be routed
     * to the port exposed by the first container in the deployment's pods.
     * The deployment's <code>labelSelector</code> will be used to select pods.
     * <p>
     * @param deployment The deployment to expose. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDeployment(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Deployment deployment) {
        software.amazon.jsii.Kernel.call(this, "addDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(deployment, "deployment is required") });
    }

    /**
     * Services defined using this spec will select pods according the provided label.
     * <p>
     * @param label The label key. This parameter is required.
     * @param value The label value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSelector(final @org.jetbrains.annotations.NotNull java.lang.String label, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.call(this, "addSelector", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(label, "label is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Expose a service via an ingress using the specified path.
     * <p>
     * @return The `Ingress` resource that was used.
     * @param path The path to expose the service under. This parameter is required.
     * @param options Additional options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IngressV1Beta1 exposeViaIngress(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.ExposeServiceViaIngressOptions options) {
        return software.amazon.jsii.Kernel.call(this, "exposeViaIngress", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IngressV1Beta1.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Expose a service via an ingress using the specified path.
     * <p>
     * @return The `Ingress` resource that was used.
     * @param path The path to expose the service under. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IngressV1Beta1 exposeViaIngress(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.Kernel.call(this, "exposeViaIngress", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IngressV1Beta1.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Configure a port the service will bind to.
     * <p>
     * This method can be called multiple times.
     * <p>
     * @param port The port definition. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void serve(final @org.jetbrains.annotations.NotNull java.lang.Number port, final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.ServicePortOptions options) {
        software.amazon.jsii.Kernel.call(this, "serve", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(port, "port is required"), options });
    }

    /**
     * Configure a port the service will bind to.
     * <p>
     * This method can be called multiple times.
     * <p>
     * @param port The port definition. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void serve(final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        software.amazon.jsii.Kernel.call(this, "serve", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * Ports for this service.
     * <p>
     * Use <code>serve()</code> to expose additional service ports.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.ServicePort> getPorts() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "ports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ServicePort.class))));
    }

    /**
     * Returns the labels which are used to select pods for this service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getSelector() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "selector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Determines how the Service is exposed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.ServiceType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ServiceType.class));
    }

    /**
     * The IP address of the service and is usually assigned randomly by the master.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterIP() {
        return software.amazon.jsii.Kernel.get(this, "clusterIP", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The externalName to be used for EXTERNAL_NAME types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExternalName() {
        return software.amazon.jsii.Kernel.get(this, "externalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus20.Service}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus20.Service> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus20.ServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * The IP address of the service and is usually assigned randomly by the master.
         * <p>
         * If an address is specified manually and is not in use by others, it
         * will be allocated to the service; otherwise, creation of the service will
         * fail. This field can not be changed through updates. Valid values are
         * "None", empty string (""), or a valid IP address. "None" can be specified
         * for headless services when proxying is not required. Only applies to types
         * ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName.
         * <p>
         * Default: - Automatically assigned.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * @param clusterIp The IP address of the service and is usually assigned randomly by the master. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIp(final java.lang.String clusterIp) {
            this.props().clusterIp(clusterIp);
            return this;
        }

        /**
         * A list of IP addresses for which nodes in the cluster will also accept traffic for this service.
         * <p>
         * These IPs are not managed by Kubernetes. The user
         * is responsible for ensuring that traffic arrives at a node with this IP. A
         * common example is external load-balancers that are not part of the
         * Kubernetes system.
         * <p>
         * Default: - No external IPs.
         * <p>
         * @return {@code this}
         * @param externalIPs A list of IP addresses for which nodes in the cluster will also accept traffic for this service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalIPs(final java.util.List<java.lang.String> externalIPs) {
            this.props().externalIPs(externalIPs);
            return this;
        }

        /**
         * The externalName to be used when ServiceType.EXTERNAL_NAME is set.
         * <p>
         * Default: - No external name.
         * <p>
         * @return {@code this}
         * @param externalName The externalName to be used when ServiceType.EXTERNAL_NAME is set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalName(final java.lang.String externalName) {
            this.props().externalName(externalName);
            return this;
        }

        /**
         * A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs.
         * <p>
         * More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
         * <p>
         * @return {@code this}
         * @param loadBalancerSourceRanges A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerSourceRanges(final java.util.List<java.lang.String> loadBalancerSourceRanges) {
            this.props().loadBalancerSourceRanges(loadBalancerSourceRanges);
            return this;
        }

        /**
         * The port exposed by this service.
         * <p>
         * More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * <p>
         * @return {@code this}
         * @param ports The port exposed by this service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ports(final java.util.List<? extends org.cdk8s.plus20.ServicePort> ports) {
            this.props().ports(ports);
            return this;
        }

        /**
         * Determines how the Service is exposed.
         * <p>
         * More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
         * <p>
         * Default: ServiceType.ClusterIP
         * <p>
         * @return {@code this}
         * @param type Determines how the Service is exposed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final org.cdk8s.plus20.ServiceType type) {
            this.props().type(type);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus20.Service}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus20.Service build() {
            return new org.cdk8s.plus20.Service(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus20.ServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus20.ServiceProps.Builder();
            }
            return this.props;
        }
    }
}
