package org.cdk8s.plus20;

/**
 * Provides read/write capabilities ontop of a `PodSpecProps`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-10T00:09:12.194Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.PodSpec")
public class PodSpec extends software.amazon.jsii.JsiiObject implements org.cdk8s.plus20.IPodSpec {

    protected PodSpec(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PodSpec(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PodSpec(final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.PodSpecProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PodSpec() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Add a container to the pod.
     * <p>
     * @param container This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Container addContainer(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.ContainerProps container) {
        return software.amazon.jsii.Kernel.call(this, "addContainer", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Container.class), new Object[] { java.util.Objects.requireNonNull(container, "container is required") });
    }

    /**
     * Add a volume to the pod.
     * <p>
     * @param volume This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addVolume(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.Volume volume) {
        software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
    }

    /**
     * The containers belonging to the pod.
     * <p>
     * Use <code>addContainer</code> to add containers.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.Container> getContainers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Container.class))));
    }

    /**
     * The volumes associated with this pod.
     * <p>
     * Use <code>addVolume</code> to add volumes.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.Volume> getVolumes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Volume.class))));
    }

    /**
     * Restart policy for all containers within the pod.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus20.RestartPolicy getRestartPolicy() {
        return software.amazon.jsii.Kernel.get(this, "restartPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.RestartPolicy.class));
    }

    /**
     * The service account used to run this pod.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus20.IServiceAccount getServiceAccount() {
        return software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IServiceAccount.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus20.PodSpec}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus20.PodSpec> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private org.cdk8s.plus20.PodSpecProps.Builder props;

        private Builder() {
        }

        /**
         * List of containers belonging to the pod.
         * <p>
         * Containers cannot currently be
         * added or removed. There must be at least one container in a Pod.
         * <p>
         * You can add additionnal containers using <code>podSpec.addContainer()</code>
         * <p>
         * Default: - No containers. Note that a pod spec must include at least one container.
         * <p>
         * @return {@code this}
         * @param containers List of containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(final java.util.List<? extends org.cdk8s.plus20.ContainerProps> containers) {
            this.props().containers(containers);
            return this;
        }

        /**
         * Restart policy for all containers within the pod.
         * <p>
         * Default: RestartPolicy.ALWAYS
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
         * @param restartPolicy Restart policy for all containers within the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartPolicy(final org.cdk8s.plus20.RestartPolicy restartPolicy) {
            this.props().restartPolicy(restartPolicy);
            return this;
        }

        /**
         * A service account provides an identity for processes that run in a Pod.
         * <p>
         * When you (a human) access the cluster (for example, using kubectl), you are
         * authenticated by the apiserver as a particular User Account (currently this
         * is usually admin, unless your cluster administrator has customized your
         * cluster). Processes in containers inside pods can also contact the
         * apiserver. When they do, they are authenticated as a particular Service
         * Account (for example, default).
         * <p>
         * Default: - No service account.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
         * @param serviceAccount A service account provides an identity for processes that run in a Pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(final org.cdk8s.plus20.IServiceAccount serviceAccount) {
            this.props().serviceAccount(serviceAccount);
            return this;
        }

        /**
         * List of volumes that can be mounted by containers belonging to the pod.
         * <p>
         * You can also add volumes later using <code>podSpec.addVolume()</code>
         * <p>
         * Default: - No volumes.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/volumes
         * @param volumes List of volumes that can be mounted by containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends org.cdk8s.plus20.Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus20.PodSpec}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus20.PodSpec build() {
            return new org.cdk8s.plus20.PodSpec(
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus20.PodSpecProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus20.PodSpecProps.Builder();
            }
            return this.props;
        }
    }
}
