package org.cdk8s.plus20;

/**
 * Properties for initialization of `Job`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-20T20:33:53.586Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.JobProps")
@software.amazon.jsii.Jsii.Proxy(JobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JobProps extends software.amazon.jsii.JsiiSerializable, org.cdk8s.plus20.ResourceProps, org.cdk8s.plus20.PodTemplateProps {

    /**
     * Specifies the duration the job may be active before the system tries to terminate it.
     * <p>
     * Default: - If unset, then there is no deadline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.Duration getActiveDeadline() {
        return null;
    }

    /**
     * Specifies the number of retries before marking this job failed.
     * <p>
     * Default: - If not set, system defaults to 6.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBackoffLimit() {
        return null;
    }

    /**
     * Limits the lifetime of a Job that has finished execution (either Complete or Failed).
     * <p>
     * If this field is set, after the Job finishes, it is eligible to
     * be automatically deleted. When the Job is being deleted, its lifecycle
     * guarantees (e.g. finalizers) will be honored. If this field is set to zero,
     * the Job becomes eligible to be deleted immediately after it finishes. This
     * field is alpha-level and is only honored by servers that enable the
     * <code>TTLAfterFinished</code> feature.
     * <p>
     * Default: - If this field is unset, the Job won't be automatically deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.Duration getTtlAfterFinished() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JobProps> {
        private org.cdk8s.Duration activeDeadline;
        private java.lang.Number backoffLimit;
        private org.cdk8s.Duration ttlAfterFinished;
        private org.cdk8s.ApiObjectMetadata metadata;
        private org.cdk8s.ApiObjectMetadata podMetadata;
        private java.util.List<org.cdk8s.plus20.ContainerProps> containers;
        private org.cdk8s.plus20.RestartPolicy restartPolicy;
        private org.cdk8s.plus20.IServiceAccount serviceAccount;
        private java.util.List<org.cdk8s.plus20.Volume> volumes;

        /**
         * Sets the value of {@link JobProps#getActiveDeadline}
         * @param activeDeadline Specifies the duration the job may be active before the system tries to terminate it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activeDeadline(org.cdk8s.Duration activeDeadline) {
            this.activeDeadline = activeDeadline;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getBackoffLimit}
         * @param backoffLimit Specifies the number of retries before marking this job failed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backoffLimit(java.lang.Number backoffLimit) {
            this.backoffLimit = backoffLimit;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getTtlAfterFinished}
         * @param ttlAfterFinished Limits the lifetime of a Job that has finished execution (either Complete or Failed).
         *                         If this field is set, after the Job finishes, it is eligible to
         *                         be automatically deleted. When the Job is being deleted, its lifecycle
         *                         guarantees (e.g. finalizers) will be honored. If this field is set to zero,
         *                         the Job becomes eligible to be deleted immediately after it finishes. This
         *                         field is alpha-level and is only honored by servers that enable the
         *                         <code>TTLAfterFinished</code> feature.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttlAfterFinished(org.cdk8s.Duration ttlAfterFinished) {
            this.ttlAfterFinished = ttlAfterFinished;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getMetadata}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(org.cdk8s.ApiObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getPodMetadata}
         * @param podMetadata The pod metadata.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podMetadata(org.cdk8s.ApiObjectMetadata podMetadata) {
            this.podMetadata = podMetadata;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getContainers}
         * @param containers List of containers belonging to the pod.
         *                   Containers cannot currently be
         *                   added or removed. There must be at least one container in a Pod.
         *                   <p>
         *                   You can add additionnal containers using <code>podSpec.addContainer()</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder containers(java.util.List<? extends org.cdk8s.plus20.ContainerProps> containers) {
            this.containers = (java.util.List<org.cdk8s.plus20.ContainerProps>)containers;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getRestartPolicy}
         * @param restartPolicy Restart policy for all containers within the pod.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartPolicy(org.cdk8s.plus20.RestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getServiceAccount}
         * @param serviceAccount A service account provides an identity for processes that run in a Pod.
         *                       When you (a human) access the cluster (for example, using kubectl), you are
         *                       authenticated by the apiserver as a particular User Account (currently this
         *                       is usually admin, unless your cluster administrator has customized your
         *                       cluster). Processes in containers inside pods can also contact the
         *                       apiserver. When they do, they are authenticated as a particular Service
         *                       Account (for example, default).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(org.cdk8s.plus20.IServiceAccount serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getVolumes}
         * @param volumes List of volumes that can be mounted by containers belonging to the pod.
         *                You can also add volumes later using <code>podSpec.addVolume()</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends org.cdk8s.plus20.Volume> volumes) {
            this.volumes = (java.util.List<org.cdk8s.plus20.Volume>)volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JobProps build() {
            return new Jsii$Proxy(activeDeadline, backoffLimit, ttlAfterFinished, metadata, podMetadata, containers, restartPolicy, serviceAccount, volumes);
        }
    }

    /**
     * An implementation for {@link JobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobProps {
        private final org.cdk8s.Duration activeDeadline;
        private final java.lang.Number backoffLimit;
        private final org.cdk8s.Duration ttlAfterFinished;
        private final org.cdk8s.ApiObjectMetadata metadata;
        private final org.cdk8s.ApiObjectMetadata podMetadata;
        private final java.util.List<org.cdk8s.plus20.ContainerProps> containers;
        private final org.cdk8s.plus20.RestartPolicy restartPolicy;
        private final org.cdk8s.plus20.IServiceAccount serviceAccount;
        private final java.util.List<org.cdk8s.plus20.Volume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.activeDeadline = software.amazon.jsii.Kernel.get(this, "activeDeadline", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
            this.backoffLimit = software.amazon.jsii.Kernel.get(this, "backoffLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ttlAfterFinished = software.amazon.jsii.Kernel.get(this, "ttlAfterFinished", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadata.class));
            this.podMetadata = software.amazon.jsii.Kernel.get(this, "podMetadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadata.class));
            this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.ContainerProps.class)));
            this.restartPolicy = software.amazon.jsii.Kernel.get(this, "restartPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.RestartPolicy.class));
            this.serviceAccount = software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IServiceAccount.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.Volume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final org.cdk8s.Duration activeDeadline, final java.lang.Number backoffLimit, final org.cdk8s.Duration ttlAfterFinished, final org.cdk8s.ApiObjectMetadata metadata, final org.cdk8s.ApiObjectMetadata podMetadata, final java.util.List<? extends org.cdk8s.plus20.ContainerProps> containers, final org.cdk8s.plus20.RestartPolicy restartPolicy, final org.cdk8s.plus20.IServiceAccount serviceAccount, final java.util.List<? extends org.cdk8s.plus20.Volume> volumes) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.activeDeadline = activeDeadline;
            this.backoffLimit = backoffLimit;
            this.ttlAfterFinished = ttlAfterFinished;
            this.metadata = metadata;
            this.podMetadata = podMetadata;
            this.containers = (java.util.List<org.cdk8s.plus20.ContainerProps>)containers;
            this.restartPolicy = restartPolicy;
            this.serviceAccount = serviceAccount;
            this.volumes = (java.util.List<org.cdk8s.plus20.Volume>)volumes;
        }

        @Override
        public final org.cdk8s.Duration getActiveDeadline() {
            return this.activeDeadline;
        }

        @Override
        public final java.lang.Number getBackoffLimit() {
            return this.backoffLimit;
        }

        @Override
        public final org.cdk8s.Duration getTtlAfterFinished() {
            return this.ttlAfterFinished;
        }

        @Override
        public final org.cdk8s.ApiObjectMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public final org.cdk8s.ApiObjectMetadata getPodMetadata() {
            return this.podMetadata;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.ContainerProps> getContainers() {
            return this.containers;
        }

        @Override
        public final org.cdk8s.plus20.RestartPolicy getRestartPolicy() {
            return this.restartPolicy;
        }

        @Override
        public final org.cdk8s.plus20.IServiceAccount getServiceAccount() {
            return this.serviceAccount;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getActiveDeadline() != null) {
                data.set("activeDeadline", om.valueToTree(this.getActiveDeadline()));
            }
            if (this.getBackoffLimit() != null) {
                data.set("backoffLimit", om.valueToTree(this.getBackoffLimit()));
            }
            if (this.getTtlAfterFinished() != null) {
                data.set("ttlAfterFinished", om.valueToTree(this.getTtlAfterFinished()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }
            if (this.getPodMetadata() != null) {
                data.set("podMetadata", om.valueToTree(this.getPodMetadata()));
            }
            if (this.getContainers() != null) {
                data.set("containers", om.valueToTree(this.getContainers()));
            }
            if (this.getRestartPolicy() != null) {
                data.set("restartPolicy", om.valueToTree(this.getRestartPolicy()));
            }
            if (this.getServiceAccount() != null) {
                data.set("serviceAccount", om.valueToTree(this.getServiceAccount()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.JobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobProps.Jsii$Proxy that = (JobProps.Jsii$Proxy) o;

            if (this.activeDeadline != null ? !this.activeDeadline.equals(that.activeDeadline) : that.activeDeadline != null) return false;
            if (this.backoffLimit != null ? !this.backoffLimit.equals(that.backoffLimit) : that.backoffLimit != null) return false;
            if (this.ttlAfterFinished != null ? !this.ttlAfterFinished.equals(that.ttlAfterFinished) : that.ttlAfterFinished != null) return false;
            if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
            if (this.podMetadata != null ? !this.podMetadata.equals(that.podMetadata) : that.podMetadata != null) return false;
            if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) return false;
            if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) return false;
            if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.activeDeadline != null ? this.activeDeadline.hashCode() : 0;
            result = 31 * result + (this.backoffLimit != null ? this.backoffLimit.hashCode() : 0);
            result = 31 * result + (this.ttlAfterFinished != null ? this.ttlAfterFinished.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            result = 31 * result + (this.podMetadata != null ? this.podMetadata.hashCode() : 0);
            result = 31 * result + (this.containers != null ? this.containers.hashCode() : 0);
            result = 31 * result + (this.restartPolicy != null ? this.restartPolicy.hashCode() : 0);
            result = 31 * result + (this.serviceAccount != null ? this.serviceAccount.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
