/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import org.cassandraunit.dataset.CQLDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLDataLoader {
    private static final Logger log = LoggerFactory.getLogger(CQLDataLoader.class);
    public static final String DEFAULT_KEYSPACE_NAME = "cassandraunitkeyspace";
    private final Session session;

    public Session getSession() {
        return this.session;
    }

    public CQLDataLoader(Session session) {
        this.session = session;
    }

    public void load(CQLDataSet dataSet) {
        this.initKeyspaceContext(this.session, dataSet);
        log.debug("loading data");
        for (String query : dataSet.getCQLStatements()) {
            log.debug("executing : " + query);
            this.session.execute(query);
        }
        if (dataSet.getKeyspaceName() != null) {
            String useQuery = "use " + dataSet.getKeyspaceName();
            this.session.execute(useQuery);
        }
    }

    private void initKeyspaceContext(Session session, CQLDataSet dataSet) {
        String selectQuery;
        ResultSet keyspaceQueryResult;
        String keyspaceName = DEFAULT_KEYSPACE_NAME;
        if (dataSet.getKeyspaceName() != null) {
            keyspaceName = dataSet.getKeyspaceName();
        }
        log.debug("initKeyspaceContext : keyspaceDeletion=" + dataSet.isKeyspaceDeletion() + "keyspaceCreation=" + dataSet.isKeyspaceCreation() + ";keyspaceName=" + keyspaceName);
        if (dataSet.isKeyspaceDeletion() && (keyspaceQueryResult = session.execute(selectQuery = "SELECT keyspace_name FROM system.schema_keyspaces where keyspace_name='" + keyspaceName + "'")).iterator().hasNext()) {
            String dropQuery = "DROP KEYSPACE " + keyspaceName;
            log.debug("executing : " + dropQuery);
            session.execute(dropQuery);
        }
        if (dataSet.isKeyspaceCreation()) {
            String createQuery = "CREATE KEYSPACE " + keyspaceName + " WITH replication={'class' : 'SimpleStrategy', 'replication_factor':1}";
            log.debug("executing : " + createQuery);
            session.execute(createQuery);
            String useQuery = "USE " + keyspaceName;
            log.debug("executing : " + useQuery);
            session.execute(useQuery);
        }
    }
}

