/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.serializer;

import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.UUID;
import me.prettyprint.cassandra.serializers.AbstractSerializer;
import me.prettyprint.cassandra.serializers.BooleanSerializer;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.CompositeSerializer;
import me.prettyprint.cassandra.serializers.DateSerializer;
import me.prettyprint.cassandra.serializers.DoubleSerializer;
import me.prettyprint.cassandra.serializers.FloatSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Composite;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.cassandraunit.exception.CassandraUnitException;
import org.cassandraunit.type.GenericType;
import org.cassandraunit.type.GenericTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTypeSerializer
extends AbstractSerializer<GenericType> {
    private static final GenericTypeSerializer instance = new GenericTypeSerializer();
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd HHmmss");
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public static GenericTypeSerializer get() {
        return instance;
    }

    public GenericType fromByteBuffer(ByteBuffer byteBuffer) {
        return null;
    }

    public ByteBuffer toByteBuffer(GenericType genericType) {
        ByteBuffer byteBuffer = null;
        GenericTypeEnum currentType = genericType.getType();
        if (currentType == null) {
            currentType = GenericTypeEnum.BYTES_TYPE;
        }
        if (currentType != null) {
            String genericValue = genericType.getValue();
            switch (genericType.getType()) {
                case BOOLEAN_TYPE: {
                    byteBuffer = BooleanSerializer.get().toByteBuffer(Boolean.valueOf(Boolean.parseBoolean(genericValue)));
                    break;
                }
                case BYTES_TYPE: {
                    try {
                        if (genericValue.isEmpty()) {
                            byteBuffer = (ByteBuffer)ByteBufferSerializer.get().fromBytes(new byte[0]);
                            break;
                        }
                        byte[] hexDecodedBytes = Hex.decodeHex((char[])genericValue.toCharArray());
                        byteBuffer = (ByteBuffer)ByteBufferSerializer.get().fromBytes(hexDecodedBytes);
                        break;
                    }
                    catch (DecoderException e) {
                        throw new CassandraUnitException("cannot parse \"" + genericValue + "\" as hex bytes", e);
                    }
                }
                case DATE_TYPE: {
                    try {
                        byteBuffer = DateSerializer.get().toByteBuffer(dateFormat.parse(genericValue));
                        break;
                    }
                    catch (ParseException e) {
                        throw new CassandraUnitException("cannot parse \"" + genericValue + "\" as date", e);
                    }
                }
                case DOUBLE_TYPE: {
                    byteBuffer = DoubleSerializer.get().toByteBuffer(Double.valueOf(Double.parseDouble(genericValue)));
                    break;
                }
                case FLOAT_TYPE: {
                    byteBuffer = FloatSerializer.get().toByteBuffer(Float.valueOf(Float.parseFloat(genericValue)));
                    break;
                }
                case INTEGER_TYPE: {
                    int val = Integer.parseInt(genericValue);
                    byteBuffer = IntegerSerializer.get().toByteBuffer(Integer.valueOf(val));
                    break;
                }
                case LEXICAL_UUID_TYPE: {
                    byteBuffer = UUIDSerializer.get().toByteBuffer(UUID.fromString(genericValue));
                    break;
                }
                case LONG_TYPE: {
                    byteBuffer = LongSerializer.get().toByteBuffer(Long.valueOf(Long.parseLong(genericValue)));
                    break;
                }
                case TIME_UUID_TYPE: {
                    byteBuffer = UUIDSerializer.get().toByteBuffer(UUID.fromString(genericValue));
                    break;
                }
                case ASCII_TYPE: 
                case UTF_8_TYPE: {
                    byteBuffer = StringSerializer.get().toByteBuffer(genericValue);
                    break;
                }
                case UUID_TYPE: {
                    byteBuffer = UUIDSerializer.get().toByteBuffer(UUID.fromString(genericValue));
                    break;
                }
                case COUNTER_TYPE: {
                    byteBuffer = LongSerializer.get().toByteBuffer(Long.valueOf(Long.parseLong(genericValue)));
                    break;
                }
                case COMPOSITE_TYPE: {
                    byteBuffer = new CompositeSerializer().toByteBuffer(this.createComposite(genericType));
                    break;
                }
                default: {
                    byteBuffer = BytesArraySerializer.get().toByteBuffer(genericValue.getBytes());
                }
            }
        }
        return byteBuffer;
    }

    private Composite createComposite(GenericType genericType) {
        if (!GenericTypeEnum.COMPOSITE_TYPE.equals((Object)genericType.getType())) {
            throw new IllegalArgumentException("the generricType must be a CompositeType");
        }
        Composite composite = new Composite();
        for (int i = 0; i < genericType.getCompositeValues().length; ++i) {
            composite.addComponent((Object)new GenericType(genericType.getCompositeValues()[i], genericType.getTypesBelongingCompositeType()[i]), (Serializer)GenericTypeSerializer.get());
        }
        return composite;
    }
}

