/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.dataset.commons;

import java.util.ArrayList;
import java.util.List;
import me.prettyprint.hector.api.ddl.ColumnIndexType;
import me.prettyprint.hector.api.ddl.ColumnType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import org.apache.commons.lang.StringUtils;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.dataset.commons.ParsedColumn;
import org.cassandraunit.dataset.commons.ParsedColumnFamily;
import org.cassandraunit.dataset.commons.ParsedColumnMetadata;
import org.cassandraunit.dataset.commons.ParsedCompactionStrategyOption;
import org.cassandraunit.dataset.commons.ParsedKeyspace;
import org.cassandraunit.dataset.commons.ParsedRow;
import org.cassandraunit.dataset.commons.ParsedSuperColumn;
import org.cassandraunit.model.ColumnFamilyModel;
import org.cassandraunit.model.ColumnMetadataModel;
import org.cassandraunit.model.ColumnModel;
import org.cassandraunit.model.CompactionStrategyOptionModel;
import org.cassandraunit.model.KeyspaceModel;
import org.cassandraunit.model.RowModel;
import org.cassandraunit.model.StrategyModel;
import org.cassandraunit.model.SuperColumnModel;
import org.cassandraunit.type.GenericType;
import org.cassandraunit.type.GenericTypeEnum;
import org.cassandraunit.utils.ComparatorTypeHelper;
import org.cassandraunit.utils.TypeExtractor;

public abstract class AbstractCommonsParserDataSet
implements DataSet {
    protected KeyspaceModel keyspace = null;

    protected abstract ParsedKeyspace getParsedKeyspace();

    @Override
    public KeyspaceModel getKeyspace() {
        if (this.keyspace == null) {
            this.mapParsedKeyspaceToModel(this.getParsedKeyspace());
        }
        return this.keyspace;
    }

    @Override
    public List<ColumnFamilyModel> getColumnFamilies() {
        if (this.keyspace == null) {
            this.mapParsedKeyspaceToModel(this.getParsedKeyspace());
        }
        return this.keyspace.getColumnFamilies();
    }

    protected void mapParsedKeyspaceToModel(ParsedKeyspace parsedKeyspace) {
        if (parsedKeyspace == null) {
            throw new ParseException("dataSet is empty");
        }
        this.keyspace = new KeyspaceModel();
        if (parsedKeyspace.getName() == null) {
            throw new ParseException("Keyspace name is mandatory");
        }
        this.keyspace.setName(parsedKeyspace.getName());
        if (parsedKeyspace.getReplicationFactor() != 0) {
            this.keyspace.setReplicationFactor(parsedKeyspace.getReplicationFactor());
        }
        if (parsedKeyspace.getStrategy() != null) {
            try {
                this.keyspace.setStrategy(StrategyModel.fromValue(parsedKeyspace.getStrategy()));
            }
            catch (IllegalArgumentException e) {
                throw new ParseException("Invalid keyspace Strategy");
            }
        }
        this.mapsParsedColumnFamiliesToColumnFamiliesModel(parsedKeyspace);
    }

    private void mapsParsedColumnFamiliesToColumnFamiliesModel(ParsedKeyspace parsedKeyspace) {
        if (parsedKeyspace.getColumnFamilies() != null) {
            for (ParsedColumnFamily parsedColumnFamily : parsedKeyspace.getColumnFamilies()) {
                this.keyspace.getColumnFamilies().add(this.mapParsedColumnFamilyToColumnFamilyModel(parsedColumnFamily));
            }
        }
    }

    private ColumnFamilyModel mapParsedColumnFamilyToColumnFamilyModel(ParsedColumnFamily parsedColumnFamily) {
        ColumnFamilyModel columnFamily = new ColumnFamilyModel();
        if (parsedColumnFamily == null || parsedColumnFamily.getName() == null) {
            throw new ParseException("Column Family Name is missing");
        }
        columnFamily.setName(parsedColumnFamily.getName());
        if (parsedColumnFamily.getType() != null) {
            columnFamily.setType(ColumnType.valueOf((String)parsedColumnFamily.getType().toString()));
        }
        columnFamily.setComment(parsedColumnFamily.getComment());
        if (parsedColumnFamily.getCompactionStrategy() != null) {
            columnFamily.setCompactionStrategy(parsedColumnFamily.getCompactionStrategy());
        }
        if (parsedColumnFamily.getCompactionStrategyOptions() != null && !parsedColumnFamily.getCompactionStrategyOptions().isEmpty()) {
            ArrayList<CompactionStrategyOptionModel> compactionStrategyOptionModels = new ArrayList<CompactionStrategyOptionModel>();
            for (ParsedCompactionStrategyOption parsedCompactionStrategyOption : parsedColumnFamily.getCompactionStrategyOptions()) {
                compactionStrategyOptionModels.add(new CompactionStrategyOptionModel(parsedCompactionStrategyOption.getName(), parsedCompactionStrategyOption.getValue()));
            }
            columnFamily.setCompactionStrategyOptions(compactionStrategyOptionModels);
        }
        if (parsedColumnFamily.getGcGraceSeconds() != null) {
            columnFamily.setGcGraceSeconds(parsedColumnFamily.getGcGraceSeconds());
        }
        if (parsedColumnFamily.getMaxCompactionThreshold() != null) {
            columnFamily.setMaxCompactionThreshold(parsedColumnFamily.getMaxCompactionThreshold());
        }
        if (parsedColumnFamily.getMinCompactionThreshold() != null) {
            columnFamily.setMinCompactionThreshold(parsedColumnFamily.getMinCompactionThreshold());
        }
        if (parsedColumnFamily.getReadRepairChance() != null) {
            columnFamily.setReadRepairChance(parsedColumnFamily.getReadRepairChance());
        }
        if (parsedColumnFamily.getReplicationOnWrite() != null) {
            columnFamily.setReplicationOnWrite(parsedColumnFamily.getReplicationOnWrite());
        }
        GenericTypeEnum[] typesBelongingCompositeTypeForKeyType = null;
        if (parsedColumnFamily.getKeyType() != null) {
            ComparatorType keyType = ComparatorTypeHelper.verifyAndExtract(parsedColumnFamily.getKeyType());
            columnFamily.setKeyType(keyType);
            if (ComparatorType.COMPOSITETYPE.getTypeName().equals(keyType.getTypeName())) {
                String keyTypeAlias = StringUtils.removeStart((String)parsedColumnFamily.getKeyType(), (String)ComparatorType.COMPOSITETYPE.getTypeName());
                columnFamily.setKeyTypeAlias(keyTypeAlias);
                typesBelongingCompositeTypeForKeyType = ComparatorTypeHelper.extractGenericTypesFromTypeAlias(keyTypeAlias);
            }
        }
        GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType = null;
        if (parsedColumnFamily.getComparatorType() != null) {
            ComparatorType comparatorType = ComparatorTypeHelper.verifyAndExtract(parsedColumnFamily.getComparatorType());
            columnFamily.setComparatorType(comparatorType);
            if (ComparatorType.COMPOSITETYPE.getTypeName().equals(comparatorType.getTypeName())) {
                String comparatorTypeAlias = StringUtils.removeStart((String)parsedColumnFamily.getComparatorType(), (String)ComparatorType.COMPOSITETYPE.getTypeName());
                columnFamily.setComparatorTypeAlias(comparatorTypeAlias);
                typesBelongingCompositeTypeForComparatorType = ComparatorTypeHelper.extractGenericTypesFromTypeAlias(comparatorTypeAlias);
            }
        }
        if (parsedColumnFamily.getSubComparatorType() != null) {
            columnFamily.setSubComparatorType(ComparatorType.getByClassName((String)parsedColumnFamily.getSubComparatorType().name()));
        }
        if (parsedColumnFamily.getDefaultColumnValueType() != null) {
            columnFamily.setDefaultColumnValueType(ComparatorType.getByClassName((String)parsedColumnFamily.getDefaultColumnValueType().name()));
        }
        columnFamily.setColumnsMetadata(this.mapParsedColumsMetadataToColumnsMetadata(parsedColumnFamily.getColumnsMetadata(), columnFamily.getComparatorType(), typesBelongingCompositeTypeForComparatorType));
        columnFamily.setRows(this.mapParsedRowsToRowsModel(parsedColumnFamily, columnFamily.getKeyType(), typesBelongingCompositeTypeForKeyType, columnFamily.getComparatorType(), typesBelongingCompositeTypeForComparatorType, columnFamily.getSubComparatorType(), columnFamily.getDefaultColumnValueType()));
        return columnFamily;
    }

    private List<ColumnMetadataModel> mapParsedColumsMetadataToColumnsMetadata(List<ParsedColumnMetadata> parsedColumnsMetadata, ComparatorType comparatorType, GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType) {
        ArrayList<ColumnMetadataModel> columnMetadatas = new ArrayList<ColumnMetadataModel>();
        for (ParsedColumnMetadata parsedColumnMetadata : parsedColumnsMetadata) {
            columnMetadatas.add(this.mapParsedColumMetadataToColumnMetadata(parsedColumnMetadata, comparatorType, typesBelongingCompositeTypeForComparatorType));
        }
        return columnMetadatas;
    }

    private ColumnMetadataModel mapParsedColumMetadataToColumnMetadata(ParsedColumnMetadata parsedColumnMetadata, ComparatorType comparatorType, GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType) {
        if (parsedColumnMetadata.getName() == null) {
            throw new ParseException("column metadata name can't be empty");
        }
        if (parsedColumnMetadata.getValidationClass() == null) {
            throw new ParseException("column metadata validation class can't be empty");
        }
        ColumnMetadataModel columnMetadata = new ColumnMetadataModel();
        columnMetadata.setColumnName(TypeExtractor.constructGenericType(parsedColumnMetadata.getName(), comparatorType, typesBelongingCompositeTypeForComparatorType));
        columnMetadata.setValidationClass(ComparatorType.getByClassName((String)parsedColumnMetadata.getValidationClass().name()));
        if (parsedColumnMetadata.getIndexType() != null) {
            columnMetadata.setColumnIndexType(ColumnIndexType.valueOf((String)parsedColumnMetadata.getIndexType().name()));
        }
        if (parsedColumnMetadata.getIndexName() != null) {
            columnMetadata.setIndexName(parsedColumnMetadata.getIndexName());
        }
        return columnMetadata;
    }

    private List<RowModel> mapParsedRowsToRowsModel(ParsedColumnFamily parsedColumnFamily, ComparatorType keyType, GenericTypeEnum[] typesBelongingCompositeTypeForKeyType, ComparatorType comparatorType, GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<RowModel> rowsModel = new ArrayList<RowModel>();
        for (ParsedRow jsonRow : parsedColumnFamily.getRows()) {
            rowsModel.add(this.mapsParsedRowToRowModel(parsedColumnFamily.getColumnsMetadata(), jsonRow, keyType, typesBelongingCompositeTypeForKeyType, comparatorType, typesBelongingCompositeTypeForComparatorType, subComparatorType, defaultColumnValueType));
        }
        return rowsModel;
    }

    private RowModel mapsParsedRowToRowModel(List<ParsedColumnMetadata> metaData, ParsedRow parsedRow, ComparatorType keyType, GenericTypeEnum[] typesBelongingCompositeTypeForKeyType, ComparatorType comparatorType, GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        RowModel row = new RowModel();
        row.setKey(TypeExtractor.constructGenericType(parsedRow.getKey(), keyType, typesBelongingCompositeTypeForKeyType));
        row.setColumns(this.mapParsedColumnsToColumnsModel(metaData, parsedRow.getColumns(), comparatorType, typesBelongingCompositeTypeForComparatorType, defaultColumnValueType));
        row.setSuperColumns(this.mapParsedSuperColumnsToSuperColumnsModel(metaData, parsedRow.getSuperColumns(), comparatorType, subComparatorType, defaultColumnValueType));
        return row;
    }

    private List<SuperColumnModel> mapParsedSuperColumnsToSuperColumnsModel(List<ParsedColumnMetadata> metaData, List<ParsedSuperColumn> parsedSuperColumns, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<SuperColumnModel> columnsModel = new ArrayList<SuperColumnModel>();
        for (ParsedSuperColumn parsedSuperColumn : parsedSuperColumns) {
            columnsModel.add(this.mapParsedSuperColumnToSuperColumnModel(metaData, parsedSuperColumn, comparatorType, subComparatorType, defaultColumnValueType));
        }
        return columnsModel;
    }

    private SuperColumnModel mapParsedSuperColumnToSuperColumnModel(List<ParsedColumnMetadata> metaData, ParsedSuperColumn parsedSuperColumn, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        SuperColumnModel superColumnModel = new SuperColumnModel();
        superColumnModel.setName(new GenericType(parsedSuperColumn.getName(), GenericTypeEnum.fromValue(comparatorType.getTypeName())));
        superColumnModel.setColumns(this.mapParsedColumnsToColumnsModel(metaData, parsedSuperColumn.getColumns(), subComparatorType, null, defaultColumnValueType));
        return superColumnModel;
    }

    private List<ColumnModel> mapParsedColumnsToColumnsModel(List<ParsedColumnMetadata> metaData, List<ParsedColumn> parsedColumns, ComparatorType comparatorType, GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<ColumnModel> columnsModel = new ArrayList<ColumnModel>();
        for (ParsedColumn jsonColumn : parsedColumns) {
            ParsedColumnMetadata columnMetaData = null;
            for (ParsedColumnMetadata tmpMetaData : metaData) {
                if (!tmpMetaData.getName().equals(jsonColumn.getName())) continue;
                columnMetaData = tmpMetaData;
                break;
            }
            columnsModel.add(this.mapParsedColumnToColumnModel(columnMetaData, jsonColumn, comparatorType, typesBelongingCompositeTypeForComparatorType, defaultColumnValueType));
        }
        return columnsModel;
    }

    private ColumnModel mapParsedColumnToColumnModel(ParsedColumnMetadata metaData, ParsedColumn parsedColumn, ComparatorType comparatorType, GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType, ComparatorType defaultColumnValueType) {
        ColumnModel columnModel = new ColumnModel();
        columnModel.setName(TypeExtractor.constructGenericType(parsedColumn.getName(), comparatorType, typesBelongingCompositeTypeForComparatorType));
        if (ComparatorType.COUNTERTYPE.getClassName().equals(defaultColumnValueType.getClassName()) && TypeExtractor.containFunctions(parsedColumn.getValue())) {
            throw new ParseException("Impossible to override Column value into a Counter column family");
        }
        GenericType columnValue = null;
        if (parsedColumn.getValue() != null) {
            if (metaData != null && !TypeExtractor.containFunctions(parsedColumn.getValue())) {
                GenericTypeEnum genTypeEnum = GenericTypeEnum.fromValue(metaData.getValidationClass().name());
                columnValue = new GenericType(parsedColumn.getValue(), genTypeEnum);
            } else {
                columnValue = TypeExtractor.extract(parsedColumn.getValue(), defaultColumnValueType);
            }
        }
        columnModel.setValue(columnValue);
        String timestamp = parsedColumn.getTimestamp();
        if (timestamp != null) {
            columnModel.setTimestamp(Long.valueOf(timestamp));
        } else {
            columnModel.setTimestamp(null);
        }
        return columnModel;
    }
}

