/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.prettyprint.cassandra.model.BasicColumnDefinition;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.HCounterColumn;
import me.prettyprint.hector.api.beans.HCounterSuperColumn;
import me.prettyprint.hector.api.beans.HSuperColumn;
import me.prettyprint.hector.api.ddl.ColumnDefinition;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ColumnType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import org.cassandraunit.LoadingOption;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.model.ColumnFamilyModel;
import org.cassandraunit.model.ColumnMetadataModel;
import org.cassandraunit.model.ColumnModel;
import org.cassandraunit.model.CompactionStrategyOptionModel;
import org.cassandraunit.model.KeyspaceModel;
import org.cassandraunit.model.RowModel;
import org.cassandraunit.model.SuperColumnModel;
import org.cassandraunit.serializer.GenericTypeSerializer;
import org.cassandraunit.type.GenericType;
import org.cassandraunit.type.GenericTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLoader {
    Cluster cluster = null;
    private Logger log = LoggerFactory.getLogger(DataLoader.class);

    public DataLoader(String clusterName, String host) {
        this.cluster = HFactory.getOrCreateCluster((String)clusterName, (String)host);
    }

    protected Cluster getCluster() {
        return this.cluster;
    }

    public void load(DataSet dataSet) {
        this.load(dataSet, new LoadingOption());
    }

    public void load(DataSet dataSet, LoadingOption loadingOption) {
        KeyspaceModel dataSetKeyspace = dataSet.getKeyspace();
        this.dropKeyspaceIfExist(dataSetKeyspace.getName());
        KeyspaceDefinition keyspaceDefinition = this.createKeyspaceDefinition(dataSet, loadingOption);
        this.cluster.addKeyspace(keyspaceDefinition, true);
        this.log.info("creating keyspace : {}", (Object)keyspaceDefinition.getName());
        Keyspace keyspace = HFactory.createKeyspace((String)dataSet.getKeyspace().getName(), (Cluster)this.cluster);
        if (!loadingOption.isOnlySchema()) {
            this.log.info("loading data into keyspace : {}", (Object)keyspaceDefinition.getName());
            this.loadData(dataSet, keyspace);
        }
    }

    private KeyspaceModel overrideKeyspaceValueIfneeded(KeyspaceModel keyspace, LoadingOption loadingOption) {
        if (loadingOption.isOverrideReplicationFactor()) {
            keyspace.setReplicationFactor(loadingOption.getReplicationFactor());
        }
        if (loadingOption.isOverrideStrategy()) {
            keyspace.setStrategy(loadingOption.getStrategy());
        }
        return keyspace;
    }

    private KeyspaceDefinition createKeyspaceDefinition(DataSet dataSet, LoadingOption loadingOption) {
        List<ColumnFamilyDefinition> columnFamilyDefinitions = this.createColumnFamilyDefinitions(dataSet);
        KeyspaceModel dataSetKeyspace = dataSet.getKeyspace();
        dataSetKeyspace = this.overrideKeyspaceValueIfneeded(dataSetKeyspace, loadingOption);
        KeyspaceDefinition keyspaceDefinition = HFactory.createKeyspaceDefinition((String)dataSetKeyspace.getName(), (String)dataSetKeyspace.getStrategy().value(), (int)dataSetKeyspace.getReplicationFactor(), columnFamilyDefinitions);
        return keyspaceDefinition;
    }

    private void dropKeyspaceIfExist(String keyspaceName) {
        KeyspaceDefinition existedKeyspace = this.cluster.describeKeyspace(keyspaceName);
        if (existedKeyspace != null) {
            this.log.info("dropping existing keyspace : {}", (Object)existedKeyspace.getName());
            this.cluster.dropKeyspace(keyspaceName, true);
        }
    }

    private void loadData(DataSet dataSet, Keyspace keyspace) {
        for (ColumnFamilyModel columnFamily : dataSet.getColumnFamilies()) {
            this.loadColumnFamilyData(columnFamily, keyspace);
        }
    }

    private void loadColumnFamilyData(ColumnFamilyModel columnFamily, Keyspace keyspace) {
        Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)GenericTypeSerializer.get());
        for (RowModel row : columnFamily.getRows()) {
            switch (columnFamily.getType()) {
                case STANDARD: {
                    this.loadStandardColumnFamilyData(columnFamily, (Mutator<GenericType>)mutator, row);
                    break;
                }
                case SUPER: {
                    this.loadSuperColumnFamilyData(columnFamily, (Mutator<GenericType>)mutator, row);
                    break;
                }
            }
        }
        mutator.execute();
    }

    private void loadSuperColumnFamilyData(ColumnFamilyModel columnFamily, Mutator<GenericType> mutator, RowModel row) {
        if (columnFamily.isCounter()) {
            for (SuperColumnModel superColumnModel : row.getSuperColumns()) {
                HCounterSuperColumn superCounterColumn = HFactory.createCounterSuperColumn((Object)superColumnModel.getName(), this.createHCounterColumnList(superColumnModel.getColumns()), (Serializer)GenericTypeSerializer.get(), (Serializer)GenericTypeSerializer.get());
                mutator.addCounter((Object)row.getKey(), columnFamily.getName(), superCounterColumn);
            }
        } else {
            for (SuperColumnModel superColumnModel : row.getSuperColumns()) {
                HSuperColumn superColumn = HFactory.createSuperColumn((Object)superColumnModel.getName(), this.createHColumnList(superColumnModel.getColumns()), (Serializer)GenericTypeSerializer.get(), (Serializer)GenericTypeSerializer.get(), (Serializer)GenericTypeSerializer.get());
                mutator.addInsertion((Object)row.getKey(), columnFamily.getName(), superColumn);
            }
        }
    }

    private void loadStandardColumnFamilyData(ColumnFamilyModel columnFamily, Mutator<GenericType> mutator, RowModel row) {
        if (columnFamily.isCounter()) {
            for (HCounterColumn<GenericType> hCounterColumn : this.createHCounterColumnList(row.getColumns())) {
                mutator.addCounter((Object)row.getKey(), columnFamily.getName(), hCounterColumn);
            }
        } else {
            for (HColumn<GenericType, GenericType> hColumn : this.createHColumnList(row.getColumns())) {
                mutator.addInsertion((Object)row.getKey(), columnFamily.getName(), hColumn);
            }
        }
    }

    private List<HColumn<GenericType, GenericType>> createHColumnList(List<ColumnModel> columnsModel) {
        ArrayList<HColumn<GenericType, GenericType>> hColumns = new ArrayList<HColumn<GenericType, GenericType>>();
        for (ColumnModel columnModel : columnsModel) {
            Long timestamp;
            GenericType columnValue = columnModel.getValue();
            if (columnValue == null) {
                columnValue = new GenericType("", GenericTypeEnum.BYTES_TYPE);
            }
            if ((timestamp = columnModel.getTimestamp()) == null) {
                timestamp = System.currentTimeMillis();
            }
            HColumn column = HFactory.createColumn((Object)columnModel.getName(), (Object)columnValue, (long)timestamp, (Serializer)GenericTypeSerializer.get(), (Serializer)GenericTypeSerializer.get());
            hColumns.add((HColumn<GenericType, GenericType>)column);
        }
        return hColumns;
    }

    private List<HCounterColumn<GenericType>> createHCounterColumnList(List<ColumnModel> columnsModel) {
        ArrayList<HCounterColumn<GenericType>> hColumns = new ArrayList<HCounterColumn<GenericType>>();
        for (ColumnModel columnModel : columnsModel) {
            HCounterColumn column = HFactory.createCounterColumn((Object)columnModel.getName(), (long)LongSerializer.get().fromByteBuffer(GenericTypeSerializer.get().toByteBuffer(columnModel.getValue())), (Serializer)GenericTypeSerializer.get());
            hColumns.add((HCounterColumn<GenericType>)column);
        }
        return hColumns;
    }

    private List<ColumnFamilyDefinition> createColumnFamilyDefinitions(DataSet dataSet) {
        KeyspaceModel dataSetKeyspace = dataSet.getKeyspace();
        ArrayList<ColumnFamilyDefinition> columnFamilyDefinitions = new ArrayList<ColumnFamilyDefinition>();
        for (ColumnFamilyModel columnFamily : dataSet.getColumnFamilies()) {
            ColumnFamilyDefinition cfDef = HFactory.createColumnFamilyDefinition((String)dataSetKeyspace.getName(), (String)columnFamily.getName(), (ComparatorType)ComparatorType.getByClassName((String)columnFamily.getComparatorType().getClassName()), this.createColumnsDefinition(columnFamily.getColumnsMetadata()));
            cfDef.setColumnType(columnFamily.getType());
            cfDef.setComment(columnFamily.getComment());
            if (columnFamily.getCompactionStrategy() != null) {
                cfDef.setCompactionStrategy(columnFamily.getCompactionStrategy());
            }
            if (columnFamily.getCompactionStrategyOptions() != null && !columnFamily.getCompactionStrategyOptions().isEmpty()) {
                HashMap<String, String> compactionStrategyOptions = new HashMap<String, String>();
                for (CompactionStrategyOptionModel compactionStrategyOption : columnFamily.getCompactionStrategyOptions()) {
                    compactionStrategyOptions.put(compactionStrategyOption.getName(), compactionStrategyOption.getValue());
                }
                cfDef.setCompactionStrategyOptions(compactionStrategyOptions);
            }
            if (columnFamily.getGcGraceSeconds() != null) {
                cfDef.setGcGraceSeconds(columnFamily.getGcGraceSeconds().intValue());
            }
            if (columnFamily.getMaxCompactionThreshold() != null) {
                cfDef.setMaxCompactionThreshold(columnFamily.getMaxCompactionThreshold().intValue());
            }
            if (columnFamily.getMinCompactionThreshold() != null) {
                cfDef.setMinCompactionThreshold(columnFamily.getMinCompactionThreshold().intValue());
            }
            if (columnFamily.getReadRepairChance() != null) {
                cfDef.setReadRepairChance(columnFamily.getReadRepairChance().doubleValue());
            }
            if (columnFamily.getReplicationOnWrite() != null) {
                cfDef.setReplicateOnWrite(columnFamily.getReplicationOnWrite().booleanValue());
            }
            cfDef.setKeyValidationClass(columnFamily.getKeyType().getTypeName() + columnFamily.getKeyTypeAlias());
            if (columnFamily.getDefaultColumnValueType() != null) {
                cfDef.setDefaultValidationClass(columnFamily.getDefaultColumnValueType().getClassName());
            }
            if (columnFamily.getType().equals((Object)ColumnType.SUPER) && columnFamily.getSubComparatorType() != null) {
                cfDef.setSubComparatorType(columnFamily.getSubComparatorType());
            }
            if (ComparatorType.COMPOSITETYPE.equals((Object)columnFamily.getComparatorType())) {
                cfDef.setComparatorTypeAlias(columnFamily.getComparatorTypeAlias());
            }
            columnFamilyDefinitions.add(cfDef);
        }
        return columnFamilyDefinitions;
    }

    private List<ColumnDefinition> createColumnsDefinition(List<ColumnMetadataModel> columnsMetadata) {
        ArrayList<ColumnDefinition> columnsDefinition = new ArrayList<ColumnDefinition>();
        for (ColumnMetadataModel columnMetadata : columnsMetadata) {
            BasicColumnDefinition columnDefinition = new BasicColumnDefinition();
            GenericType columnName = columnMetadata.getColumnName();
            columnDefinition.setName(GenericTypeSerializer.get().toByteBuffer(columnName));
            if (columnMetadata.getColumnIndexType() != null) {
                String indexName = columnMetadata.getIndexName();
                columnDefinition.setIndexName(indexName == null ? columnName.getValue() : indexName);
                columnDefinition.setIndexType(columnMetadata.getColumnIndexType());
            }
            if (columnMetadata.getValidationClass() != null) {
                columnDefinition.setValidationClass(columnMetadata.getValidationClass().getClassName());
            }
            columnsDefinition.add((ColumnDefinition)columnDefinition);
        }
        return columnsDefinition;
    }
}

