/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.dataset.xml;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import me.prettyprint.hector.api.ddl.ColumnIndexType;
import me.prettyprint.hector.api.ddl.ColumnType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.dataset.xml.Column;
import org.cassandraunit.dataset.xml.ColumnFamily;
import org.cassandraunit.dataset.xml.ColumnMetadata;
import org.cassandraunit.dataset.xml.Keyspace;
import org.cassandraunit.dataset.xml.Row;
import org.cassandraunit.dataset.xml.SuperColumn;
import org.cassandraunit.model.ColumnFamilyModel;
import org.cassandraunit.model.ColumnModel;
import org.cassandraunit.model.KeyspaceModel;
import org.cassandraunit.model.RowModel;
import org.cassandraunit.model.StrategyModel;
import org.cassandraunit.model.SuperColumnModel;
import org.cassandraunit.type.GenericType;
import org.cassandraunit.type.GenericTypeEnum;
import org.cassandraunit.utils.TypeExtractor;
import org.xml.sax.SAXException;

public abstract class AbstractXmlDataSet
implements DataSet {
    private String dataSetLocation = null;
    private KeyspaceModel keyspace = null;

    public AbstractXmlDataSet(String dataSetLocation) {
        this.dataSetLocation = dataSetLocation;
        if (this.getInputDataSetLocation(dataSetLocation) == null) {
            throw new ParseException("Dataset not found");
        }
    }

    private Keyspace getXmlKeyspace() {
        InputStream inputDataSetLocation = this.getInputDataSetLocation(this.dataSetLocation);
        if (inputDataSetLocation == null) {
            throw new ParseException("Dataset not found in classpath");
        }
        try {
            Unmarshaller unmarshaller = this.getUnmarshaller();
            Keyspace xmlKeyspace = (Keyspace)unmarshaller.unmarshal(inputDataSetLocation);
            return xmlKeyspace;
        }
        catch (JAXBException e) {
            throw new ParseException(e);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
        catch (URISyntaxException e) {
            throw new ParseException(e);
        }
    }

    protected abstract InputStream getInputDataSetLocation(String var1);

    private Unmarshaller getUnmarshaller() throws JAXBException, SAXException, URISyntaxException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Keyspace.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(this.getClass().getResource("/dataset.xsd"));
        unmarshaller.setSchema(schema);
        return unmarshaller;
    }

    private void mapXmlKeyspaceToModel(Keyspace xmlKeyspace) {
        this.keyspace = new KeyspaceModel();
        this.keyspace.setName(xmlKeyspace.getName());
        if (xmlKeyspace.getReplicationFactor() != null) {
            this.keyspace.setReplicationFactor(xmlKeyspace.getReplicationFactor());
        }
        if (xmlKeyspace.getStrategy() != null) {
            this.keyspace.setStrategy(StrategyModel.fromValue(xmlKeyspace.getStrategy().value()));
        }
        this.mapsXmlColumnFamiliesToColumnFamiliesModel(xmlKeyspace);
    }

    private void mapsXmlColumnFamiliesToColumnFamiliesModel(Keyspace xmlKeyspace) {
        if (xmlKeyspace.getColumnFamilies() != null) {
            for (ColumnFamily xmlColumnFamily : xmlKeyspace.getColumnFamilies().getColumnFamily()) {
                this.keyspace.getColumnFamilies().add(this.mapXmlColumnFamilyToColumnFamilyModel(xmlColumnFamily));
            }
        }
    }

    private ColumnFamilyModel mapXmlColumnFamilyToColumnFamilyModel(ColumnFamily xmlColumnFamily) {
        ColumnFamilyModel columnFamily = new ColumnFamilyModel();
        columnFamily.setName(xmlColumnFamily.getName());
        if (xmlColumnFamily.getType() != null) {
            columnFamily.setType(ColumnType.valueOf((String)xmlColumnFamily.getType().toString()));
        }
        if (xmlColumnFamily.getKeyType() != null) {
            columnFamily.setKeyType(ComparatorType.getByClassName((String)xmlColumnFamily.getKeyType().value()));
        }
        if (xmlColumnFamily.getComparatorType() != null) {
            columnFamily.setComparatorType(ComparatorType.getByClassName((String)xmlColumnFamily.getComparatorType().value()));
        }
        if (xmlColumnFamily.getSubComparatorType() != null) {
            columnFamily.setSubComparatorType(ComparatorType.getByClassName((String)xmlColumnFamily.getSubComparatorType().value()));
        }
        if (xmlColumnFamily.getDefaultColumnValueType() != null) {
            columnFamily.setDefaultColumnValueType(ComparatorType.getByClassName((String)xmlColumnFamily.getDefaultColumnValueType().value()));
        }
        columnFamily.setColumnsMetadata(this.mapXmlColumsMetadataToColumnsMetadata(xmlColumnFamily.getColumnMetadata()));
        columnFamily.setRows(this.mapXmlRowsToRowsModel(xmlColumnFamily, columnFamily.getKeyType(), columnFamily.getComparatorType(), columnFamily.getSubComparatorType(), columnFamily.getDefaultColumnValueType()));
        return columnFamily;
    }

    private List<org.cassandraunit.model.ColumnMetadata> mapXmlColumsMetadataToColumnsMetadata(List<ColumnMetadata> xmlColumnsMetadata) {
        ArrayList<org.cassandraunit.model.ColumnMetadata> columnsMetadata = new ArrayList<org.cassandraunit.model.ColumnMetadata>();
        for (ColumnMetadata xmlColumnMetadata : xmlColumnsMetadata) {
            columnsMetadata.add(this.mapXmlColumnMetadataToColumMetadata(xmlColumnMetadata));
        }
        return columnsMetadata;
    }

    private org.cassandraunit.model.ColumnMetadata mapXmlColumnMetadataToColumMetadata(ColumnMetadata xmlColumnMetadata) {
        org.cassandraunit.model.ColumnMetadata columnMetadata = new org.cassandraunit.model.ColumnMetadata();
        columnMetadata.setColumnName(xmlColumnMetadata.getName());
        columnMetadata.setValidationClass(ComparatorType.getByClassName((String)xmlColumnMetadata.getValidationClass().value()));
        if (xmlColumnMetadata.getIndexType() != null) {
            columnMetadata.setColumnIndexType(ColumnIndexType.valueOf((String)xmlColumnMetadata.getIndexType().value()));
        }
        return columnMetadata;
    }

    private List<RowModel> mapXmlRowsToRowsModel(ColumnFamily xmlColumnFamily, ComparatorType keyType, ComparatorType comparatorType, ComparatorType subcomparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<RowModel> rowsModel = new ArrayList<RowModel>();
        for (Row rowType : xmlColumnFamily.getRow()) {
            rowsModel.add(this.mapsXmlRowToRowModel(rowType, keyType, comparatorType, subcomparatorType, defaultColumnValueType));
        }
        return rowsModel;
    }

    private RowModel mapsXmlRowToRowModel(Row xmlRow, ComparatorType keyType, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        RowModel row = new RowModel();
        row.setKey(new GenericType(xmlRow.getKey(), GenericTypeEnum.fromValue(keyType.getTypeName())));
        row.setColumns(this.mapXmlColumnsToColumnsModel(xmlRow.getColumn(), comparatorType, defaultColumnValueType));
        row.setSuperColumns(this.mapXmlSuperColumnsToSuperColumnsModel(xmlRow.getSuperColumn(), comparatorType, subComparatorType, defaultColumnValueType));
        return row;
    }

    private List<SuperColumnModel> mapXmlSuperColumnsToSuperColumnsModel(List<SuperColumn> xmlSuperColumns, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<SuperColumnModel> columnsModel = new ArrayList<SuperColumnModel>();
        for (SuperColumn xmlSuperColumnType : xmlSuperColumns) {
            columnsModel.add(this.mapXmlSuperColumnToSuperColumnModel(xmlSuperColumnType, comparatorType, subComparatorType, defaultColumnValueType));
        }
        return columnsModel;
    }

    private SuperColumnModel mapXmlSuperColumnToSuperColumnModel(SuperColumn xmlSuperColumn, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        SuperColumnModel superColumnModel = new SuperColumnModel();
        superColumnModel.setName(new GenericType(xmlSuperColumn.getName(), GenericTypeEnum.fromValue(comparatorType.getTypeName())));
        superColumnModel.setColumns(this.mapXmlColumnsToColumnsModel(xmlSuperColumn.getColumn(), subComparatorType, defaultColumnValueType));
        return superColumnModel;
    }

    private ColumnModel mapXmlColumnToColumnModel(Column xmlColumn, ComparatorType comparatorType, ComparatorType defaultColumnValueType) {
        ColumnModel columnModel = new ColumnModel();
        if (comparatorType == null) {
            columnModel.setName(new GenericType(xmlColumn.getName(), GenericTypeEnum.BYTES_TYPE));
        } else {
            columnModel.setName(new GenericType(xmlColumn.getName(), GenericTypeEnum.fromValue(comparatorType.getTypeName())));
        }
        if (ComparatorType.COUNTERTYPE.getClassName().equals(defaultColumnValueType.getClassName()) && TypeExtractor.containFunctions(xmlColumn.getValue())) {
            throw new ParseException("Impossible to override Column value into a Counter column family");
        }
        GenericType columnValue = TypeExtractor.extract(xmlColumn.getValue(), defaultColumnValueType);
        columnModel.setValue(columnValue);
        return columnModel;
    }

    private List<ColumnModel> mapXmlColumnsToColumnsModel(List<Column> xmlColumns, ComparatorType columnNameComparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<ColumnModel> columnsModel = new ArrayList<ColumnModel>();
        for (Column xmlColumn : xmlColumns) {
            columnsModel.add(this.mapXmlColumnToColumnModel(xmlColumn, columnNameComparatorType, defaultColumnValueType));
        }
        return columnsModel;
    }

    @Override
    public KeyspaceModel getKeyspace() {
        if (this.keyspace == null) {
            Keyspace xmlKeyspace = this.getXmlKeyspace();
            this.mapXmlKeyspaceToModel(xmlKeyspace);
        }
        return this.keyspace;
    }

    @Override
    public List<ColumnFamilyModel> getColumnFamilies() {
        if (this.keyspace == null) {
            this.getKeyspace();
        }
        return this.keyspace.getColumnFamilies();
    }
}

