/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.utils;

import me.prettyprint.hector.api.ddl.ComparatorType;
import org.apache.commons.lang.StringUtils;
import org.cassandraunit.type.GenericType;
import org.cassandraunit.type.GenericTypeEnum;

public class TypeExtractor {
    private static String endTypeFunction = ")";
    private static String startTypeFunction = "(";
    private static String[] availableTypeFunctionArray = new String[]{"bytes(", "integer(", "lexicaluuid(", "long(", "utf8(", "timeuuid(", "uuid("};

    public static GenericType extract(String valueToExtract, ComparatorType defaultValueType) {
        String extractedValue = null;
        GenericType genericType = null;
        if (TypeExtractor.containFunctions(valueToExtract)) {
            String typeFunction = StringUtils.substringBefore((String)valueToExtract, (String)startTypeFunction);
            String tmp = StringUtils.substringAfter((String)valueToExtract, (String)(typeFunction + startTypeFunction));
            extractedValue = StringUtils.substringBefore((String)tmp, (String)endTypeFunction);
            genericType = new GenericType(extractedValue, GenericTypeEnum.fromValue(typeFunction + "type"));
        } else {
            extractedValue = valueToExtract;
            genericType = defaultValueType == null ? new GenericType(extractedValue, GenericTypeEnum.BYTES_TYPE) : new GenericType(extractedValue, GenericTypeEnum.fromValue(defaultValueType.getTypeName()));
        }
        return genericType;
    }

    public static boolean containFunctions(String valueToExtract) {
        return StringUtils.startsWithAny((String)valueToExtract, (String[])availableTypeFunctionArray) && StringUtils.endsWith((String)valueToExtract, (String)endTypeFunction);
    }
}

