/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.testutils.EmbeddedServerHelper;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.EmbeddedCassandraService;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedCassandraServerHelper {
    private static final String INTERNAL_CASSANDRA_KEYSPACE = "system";
    private static Logger log = LoggerFactory.getLogger(EmbeddedCassandraServerHelper.class);
    private static final String TMP = "target/embeddedCassandra";
    private static final String yamlFile = "/cassandra.yaml";
    private static EmbeddedCassandraService embeddedCassandraService = null;

    public static void startEmbeddedCassandra() throws TTransportException, IOException, InterruptedException, ConfigurationException {
        if (embeddedCassandraService == null) {
            log.debug("Starting cassandra...");
            log.debug("Initialization needed");
            EmbeddedCassandraServerHelper.rmdir(TMP);
            EmbeddedCassandraServerHelper.copy("/log4j-embedded-cassandra.properties", TMP);
            EmbeddedCassandraServerHelper.copy(yamlFile, TMP);
            System.setProperty("cassandra.config", "file:target/embeddedCassandra/cassandra.yaml");
            System.setProperty("log4j.configuration", "file:target/embeddedCassandra/log4j-embedded-cassandra.properties");
            System.setProperty("cassandra-foreground", "true");
            EmbeddedCassandraServerHelper.cleanupAndLeaveDirs();
            embeddedCassandraService = new EmbeddedCassandraService();
            embeddedCassandraService.start();
        }
    }

    public static void cleanEmbeddedCassandra() {
        log.debug("Cleaning cassandra keyspaces");
        EmbeddedCassandraServerHelper.dropKeyspaces();
    }

    private static void dropKeyspaces() {
        Cluster cluster = HFactory.getOrCreateCluster((String)"TestCluster", (CassandraHostConfigurator)new CassandraHostConfigurator("localhost:9171"));
        List keyspaces = cluster.describeKeyspaces();
        for (KeyspaceDefinition keyspaceDefinition : keyspaces) {
            String keyspaceName = keyspaceDefinition.getName();
            if (INTERNAL_CASSANDRA_KEYSPACE.equals(keyspaceName)) continue;
            cluster.dropKeyspace(keyspaceName);
        }
    }

    private static void rmdir(String dir) throws IOException {
        File dirFile = new File(dir);
        if (dirFile.exists()) {
            FileUtils.deleteRecursive((File)new File(dir));
        }
    }

    private static void copy(String resource, String directory) throws IOException {
        int len;
        EmbeddedCassandraServerHelper.mkdir(directory);
        InputStream is = EmbeddedServerHelper.class.getResourceAsStream(resource);
        String fileName = resource.substring(resource.lastIndexOf("/") + 1);
        File file = new File(directory + System.getProperty("file.separator") + fileName);
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        is.close();
    }

    private static void mkdir(String dir) throws IOException {
        FileUtils.createDirectory((String)dir);
    }

    private static void cleanupAndLeaveDirs() throws IOException {
        EmbeddedCassandraServerHelper.mkdirs();
        EmbeddedCassandraServerHelper.cleanup();
        EmbeddedCassandraServerHelper.mkdirs();
        CommitLog.instance.resetUnsafe();
    }

    private static void cleanup() throws IOException {
        File dir;
        String[] directoryNames;
        for (String dirName : directoryNames = new String[]{DatabaseDescriptor.getCommitLogLocation()}) {
            dir = new File(dirName);
            if (!dir.exists()) {
                throw new RuntimeException("No such directory: " + dir.getAbsolutePath());
            }
            FileUtils.deleteRecursive((File)dir);
        }
        for (String dirName : DatabaseDescriptor.getAllDataFileLocations()) {
            dir = new File(dirName);
            if (!dir.exists()) {
                throw new RuntimeException("No such directory: " + dir.getAbsolutePath());
            }
            FileUtils.deleteRecursive((File)dir);
        }
    }

    public static void mkdirs() {
        try {
            DatabaseDescriptor.createAllDirectories();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

