/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import java.util.ArrayList;
import java.util.List;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.HSuperColumn;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ColumnType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import org.cassandraunit.dataset.IDataSet;
import org.cassandraunit.model.ColumnFamilyModel;
import org.cassandraunit.model.ColumnModel;
import org.cassandraunit.model.KeyspaceModel;
import org.cassandraunit.model.RowModel;
import org.cassandraunit.model.SuperColumnModel;
import org.cassandraunit.serializer.GenericTypeSerializer;
import org.cassandraunit.type.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLoader {
    Cluster cluster = null;
    private Logger log = LoggerFactory.getLogger(DataLoader.class);

    public DataLoader(String clusterName, String host) {
        this.cluster = HFactory.getOrCreateCluster((String)clusterName, (String)host);
    }

    protected Cluster getCluster() {
        return this.cluster;
    }

    public void load(IDataSet dataSet) {
        KeyspaceModel dataSetKeyspace = dataSet.getKeyspace();
        this.dropKeyspaceIfExist(dataSetKeyspace.getName());
        List<ColumnFamilyDefinition> columnFamilyDefinitions = this.createColumnFamilyDefinitions(dataSet, dataSetKeyspace);
        KeyspaceDefinition keyspaceDefinition = HFactory.createKeyspaceDefinition((String)dataSetKeyspace.getName(), (String)dataSetKeyspace.getStategy(), (int)dataSetKeyspace.getReplicationFactor(), columnFamilyDefinitions);
        this.cluster.addKeyspace(keyspaceDefinition, true);
        this.log.info("creating keyspace : {}", (Object)keyspaceDefinition.getName());
        Keyspace keyspace = HFactory.createKeyspace((String)dataSet.getKeyspace().getName(), (Cluster)this.cluster);
        this.log.info("loading data into keyspace : {}", (Object)keyspaceDefinition.getName());
        this.loadData(dataSet, keyspace);
    }

    private void dropKeyspaceIfExist(String keyspaceName) {
        KeyspaceDefinition existedKeyspace = this.cluster.describeKeyspace(keyspaceName);
        if (existedKeyspace != null) {
            this.log.info("dropping existing keyspace : {}", (Object)existedKeyspace.getName());
            this.cluster.dropKeyspace(keyspaceName, true);
        }
    }

    private void loadData(IDataSet dataSet, Keyspace keyspace) {
        for (ColumnFamilyModel columnFamily : dataSet.getColumnFamilies()) {
            this.loadColumnFamilyData(columnFamily, keyspace);
        }
    }

    private void loadColumnFamilyData(ColumnFamilyModel columnFamily, Keyspace keyspace) {
        Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)GenericTypeSerializer.get());
        block4: for (RowModel row : columnFamily.getRows()) {
            switch (columnFamily.getType()) {
                case STANDARD: {
                    for (HColumn hColumn : this.createHColumnList(row.getColumns())) {
                        mutator.addInsertion((Object)row.getKey(), columnFamily.getName(), hColumn);
                    }
                    continue block4;
                }
                case SUPER: {
                    for (SuperColumnModel superColumnModel : row.getSuperColumns()) {
                        HSuperColumn column = HFactory.createSuperColumn((Object)superColumnModel.getName(), this.createHColumnList(superColumnModel.getColumns()), (Serializer)GenericTypeSerializer.get(), (Serializer)GenericTypeSerializer.get(), (Serializer)GenericTypeSerializer.get());
                        mutator.addInsertion((Object)row.getKey(), columnFamily.getName(), column);
                    }
                    continue block4;
                }
            }
        }
        mutator.execute();
    }

    private List<HColumn<GenericType, GenericType>> createHColumnList(List<ColumnModel> columnsModel) {
        ArrayList<HColumn<GenericType, GenericType>> hColumns = new ArrayList<HColumn<GenericType, GenericType>>();
        for (ColumnModel columnModel : columnsModel) {
            HColumn column = HFactory.createColumn((Object)columnModel.getName(), (Object)columnModel.getValue(), (Serializer)GenericTypeSerializer.get(), (Serializer)GenericTypeSerializer.get());
            hColumns.add((HColumn<GenericType, GenericType>)column);
        }
        return hColumns;
    }

    private List<ColumnFamilyDefinition> createColumnFamilyDefinitions(IDataSet dataSet, KeyspaceModel dataSetKeyspace) {
        ArrayList<ColumnFamilyDefinition> columnFamilyDefinitions = new ArrayList<ColumnFamilyDefinition>();
        for (ColumnFamilyModel columnFamily : dataSet.getColumnFamilies()) {
            ColumnFamilyDefinition cfDef = HFactory.createColumnFamilyDefinition((String)dataSetKeyspace.getName(), (String)columnFamily.getName());
            cfDef.setColumnType(columnFamily.getType());
            cfDef.setKeyValidationClass(columnFamily.getKeyType().getClassName());
            cfDef.setComparatorType(ComparatorType.getByClassName((String)columnFamily.getComparatorType().getClassName()));
            if (columnFamily.getType().equals((Object)ColumnType.SUPER) && columnFamily.getSubComparatorType() != null) {
                cfDef.setSubComparatorType(columnFamily.getSubComparatorType());
            }
            columnFamilyDefinitions.add(cfDef);
        }
        return columnFamilyDefinitions;
    }
}

