/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.utils.TimeSource;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.cassandraunit.shaded.com.google.common.base.Preconditions;

public class SlidingTimeRate {
    private final ConcurrentSkipListMap<Long, AtomicInteger> counters = new ConcurrentSkipListMap();
    private final AtomicLong lastCounterTimestamp = new AtomicLong(0L);
    private final ReadWriteLock pruneLock = new ReentrantReadWriteLock();
    private final long sizeInMillis;
    private final long precisionInMillis;
    private final TimeSource timeSource;

    public SlidingTimeRate(TimeSource timeSource, long size, long precision, TimeUnit unit) {
        Preconditions.checkArgument(size > precision, "Size should be greater than precision.");
        Preconditions.checkArgument(TimeUnit.MILLISECONDS.convert(precision, unit) >= 1L, "Precision must be greater than or equal to 1 millisecond.");
        this.sizeInMillis = TimeUnit.MILLISECONDS.convert(size, unit);
        this.precisionInMillis = TimeUnit.MILLISECONDS.convert(precision, unit);
        this.timeSource = timeSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int delta) {
        block5: {
            this.pruneLock.readLock().lock();
            try {
                long now;
                long lastTimestamp;
                do {
                    boolean isWithinPrecisionRange = (now = this.timeSource.currentTimeMillis()) - (lastTimestamp = this.lastCounterTimestamp.get()) < this.precisionInMillis;
                    AtomicInteger lastCounter = this.counters.get(lastTimestamp);
                    if (lastCounter == null || !isWithinPrecisionRange) continue;
                    lastCounter.addAndGet(delta);
                    break block5;
                } while (!this.lastCounterTimestamp.compareAndSet(lastTimestamp, now));
                AtomicInteger existing = this.counters.putIfAbsent(now, new AtomicInteger(delta));
                if (existing != null) {
                    existing.addAndGet(delta);
                }
            }
            finally {
                this.pruneLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get(long toAgo, TimeUnit unit) {
        this.pruneLock.readLock().lock();
        try {
            long toAgoInMillis = TimeUnit.MILLISECONDS.convert(toAgo, unit);
            Preconditions.checkArgument(toAgoInMillis < this.sizeInMillis, "Cannot get rate in the past!");
            long now = this.timeSource.currentTimeMillis();
            long sum = 0L;
            NavigableMap tailCounters = this.counters.tailMap((Object)(now - this.sizeInMillis), true).headMap((Object)(now - toAgoInMillis), true);
            for (AtomicInteger i : tailCounters.values()) {
                sum += (long)i.get();
            }
            double rateInMillis = sum == 0L ? (double)sum : (double)sum / (double)Math.max(1000L, now - toAgoInMillis - (Long)tailCounters.firstKey());
            double multiplier = TimeUnit.MILLISECONDS.convert(1L, unit);
            double d = rateInMillis * multiplier;
            return d;
        }
        finally {
            this.pruneLock.readLock().unlock();
        }
    }

    public double get(TimeUnit unit) {
        return this.get(0L, unit);
    }

    public void prune() {
        this.pruneLock.writeLock().lock();
        try {
            long now = this.timeSource.currentTimeMillis();
            this.counters.headMap((Object)(now - this.sizeInMillis), false).clear();
        }
        finally {
            this.pruneLock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    public int size() {
        return this.counters.values().stream().reduce(new AtomicInteger(), (v1, v2) -> {
            v1.addAndGet(v2.get());
            return v1;
        }).get();
    }
}

