/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.Pair;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.cassandraunit.shaded.io.netty.buffer.ByteBuf;

public final class DataType
extends Enum<DataType> {
    public static final /* enum */ DataType CUSTOM = new DataType(0, null, ProtocolVersion.V1);
    public static final /* enum */ DataType ASCII = new DataType(1, AsciiType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType BIGINT = new DataType(2, LongType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType BLOB = new DataType(3, BytesType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType BOOLEAN = new DataType(4, BooleanType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType COUNTER = new DataType(5, CounterColumnType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType DECIMAL = new DataType(6, DecimalType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType DOUBLE = new DataType(7, DoubleType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType FLOAT = new DataType(8, FloatType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType INT = new DataType(9, Int32Type.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType TEXT = new DataType(10, UTF8Type.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType TIMESTAMP = new DataType(11, TimestampType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType UUID = new DataType(12, UUIDType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType VARCHAR = new DataType(13, UTF8Type.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType VARINT = new DataType(14, IntegerType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType TIMEUUID = new DataType(15, TimeUUIDType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType INET = new DataType(16, InetAddressType.instance, ProtocolVersion.V1);
    public static final /* enum */ DataType DATE = new DataType(17, SimpleDateType.instance, ProtocolVersion.V4);
    public static final /* enum */ DataType TIME = new DataType(18, TimeType.instance, ProtocolVersion.V4);
    public static final /* enum */ DataType SMALLINT = new DataType(19, ShortType.instance, ProtocolVersion.V4);
    public static final /* enum */ DataType BYTE = new DataType(20, ByteType.instance, ProtocolVersion.V4);
    public static final /* enum */ DataType DURATION = new DataType(21, DurationType.instance, ProtocolVersion.V5);
    public static final /* enum */ DataType LIST = new DataType(32, null, ProtocolVersion.V1);
    public static final /* enum */ DataType MAP = new DataType(33, null, ProtocolVersion.V1);
    public static final /* enum */ DataType SET = new DataType(34, null, ProtocolVersion.V1);
    public static final /* enum */ DataType UDT = new DataType(48, null, ProtocolVersion.V3);
    public static final /* enum */ DataType TUPLE = new DataType(49, null, ProtocolVersion.V3);
    public static final Codec codec;
    private final int id;
    private final ProtocolVersion protocolVersion;
    private final AbstractType type;
    private final Pair<DataType, Object> pair;
    private static final Map<AbstractType, DataType> dataTypeMap;
    private static final /* synthetic */ DataType[] $VALUES;

    public static DataType[] values() {
        return (DataType[])$VALUES.clone();
    }

    public static DataType valueOf(String name) {
        return Enum.valueOf(DataType.class, name);
    }

    private DataType(int id, AbstractType type, ProtocolVersion protocolVersion) {
        this.id = id;
        this.type = type;
        this.protocolVersion = protocolVersion;
        this.pair = Pair.create(this, null);
    }

    public int getId(ProtocolVersion version) {
        if (version.isSmallerThan(this.protocolVersion)) {
            return CUSTOM.getId(version);
        }
        return this.id;
    }

    public Object readValue(ByteBuf cb, ProtocolVersion version) {
        switch (this) {
            case CUSTOM: {
                return CBUtil.readString(cb);
            }
            case LIST: {
                return DataType.toType(codec.decodeOne(cb, version));
            }
            case SET: {
                return DataType.toType(codec.decodeOne(cb, version));
            }
            case MAP: {
                ArrayList<AbstractType> l = new ArrayList<AbstractType>(2);
                l.add(DataType.toType(codec.decodeOne(cb, version)));
                l.add(DataType.toType(codec.decodeOne(cb, version)));
                return l;
            }
            case UDT: {
                String ks = CBUtil.readString(cb);
                ByteBuffer name = UTF8Type.instance.decompose(CBUtil.readString(cb));
                int n = cb.readUnsignedShort();
                ArrayList<FieldIdentifier> fieldNames = new ArrayList<FieldIdentifier>(n);
                ArrayList fieldTypes = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    fieldNames.add(FieldIdentifier.forInternalString(CBUtil.readString(cb)));
                    fieldTypes.add(DataType.toType(codec.decodeOne(cb, version)));
                }
                return new UserType(ks, name, fieldNames, fieldTypes, true);
            }
            case TUPLE: {
                int n = cb.readUnsignedShort();
                ArrayList types = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    types.add(DataType.toType(codec.decodeOne(cb, version)));
                }
                return new TupleType(types);
            }
        }
        return null;
    }

    public void writeValue(Object value, ByteBuf cb, ProtocolVersion version) {
        if (version.isSmallerThan(this.protocolVersion)) {
            CBUtil.writeString(value.toString(), cb);
            return;
        }
        switch (this) {
            case CUSTOM: {
                assert (value instanceof String);
                CBUtil.writeString((String)value, cb);
                break;
            }
            case LIST: {
                codec.writeOne(DataType.fromType((AbstractType)value, version), cb, version);
                break;
            }
            case SET: {
                codec.writeOne(DataType.fromType((AbstractType)value, version), cb, version);
                break;
            }
            case MAP: {
                List l = (List)value;
                codec.writeOne(DataType.fromType((AbstractType)l.get(0), version), cb, version);
                codec.writeOne(DataType.fromType((AbstractType)l.get(1), version), cb, version);
                break;
            }
            case UDT: {
                UserType udt = (UserType)value;
                CBUtil.writeString(udt.keyspace, cb);
                CBUtil.writeString((String)UTF8Type.instance.compose(udt.name), cb);
                cb.writeShort(udt.size());
                for (int i = 0; i < udt.size(); ++i) {
                    CBUtil.writeString(udt.fieldName(i).toString(), cb);
                    codec.writeOne(DataType.fromType(udt.fieldType(i), version), cb, version);
                }
                break;
            }
            case TUPLE: {
                TupleType tt = (TupleType)value;
                cb.writeShort(tt.size());
                for (int i = 0; i < tt.size(); ++i) {
                    codec.writeOne(DataType.fromType(tt.type(i), version), cb, version);
                }
                break;
            }
        }
    }

    public int serializedValueSize(Object value, ProtocolVersion version) {
        if (version.isSmallerThan(this.protocolVersion)) {
            return CBUtil.sizeOfString(value.toString());
        }
        switch (this) {
            case CUSTOM: {
                return CBUtil.sizeOfString((String)value);
            }
            case LIST: 
            case SET: {
                return codec.oneSerializedSize(DataType.fromType((AbstractType)value, version), version);
            }
            case MAP: {
                List l = (List)value;
                int s = 0;
                s += codec.oneSerializedSize(DataType.fromType((AbstractType)l.get(0), version), version);
                return s += codec.oneSerializedSize(DataType.fromType((AbstractType)l.get(1), version), version);
            }
            case UDT: {
                UserType udt = (UserType)value;
                int size = 0;
                size += CBUtil.sizeOfString(udt.keyspace);
                size += CBUtil.sizeOfString((String)UTF8Type.instance.compose(udt.name));
                size += 2;
                for (int i = 0; i < udt.size(); ++i) {
                    size += CBUtil.sizeOfString(udt.fieldName(i).toString());
                    size += codec.oneSerializedSize(DataType.fromType(udt.fieldType(i), version), version);
                }
                return size;
            }
            case TUPLE: {
                TupleType tt = (TupleType)value;
                int size = 2;
                for (int i = 0; i < tt.size(); ++i) {
                    size += codec.oneSerializedSize(DataType.fromType(tt.type(i), version), version);
                }
                return size;
            }
        }
        return 0;
    }

    public static Pair<DataType, Object> fromType(AbstractType type, ProtocolVersion version) {
        DataType dt;
        if (type instanceof ReversedType) {
            type = ((ReversedType)((Object)type)).baseType;
        }
        if (type instanceof DateType) {
            type = TimestampType.instance;
        }
        if ((dt = dataTypeMap.get(type)) == null) {
            if (type.isCollection()) {
                if (type instanceof ListType) {
                    return Pair.create(LIST, ((ListType)((Object)type)).getElementsType());
                }
                if (type instanceof MapType) {
                    MapType mt = (MapType)((Object)type);
                    return Pair.create(MAP, Arrays.asList(mt.getKeysType(), mt.getValuesType()));
                }
                if (type instanceof SetType) {
                    return Pair.create(SET, ((SetType)((Object)type)).getElementsType());
                }
                throw new AssertionError();
            }
            if (type instanceof UserType && version.isGreaterOrEqualTo(DataType.UDT.protocolVersion)) {
                return Pair.create(UDT, type);
            }
            if (type instanceof TupleType && version.isGreaterOrEqualTo(DataType.TUPLE.protocolVersion)) {
                return Pair.create(TUPLE, type);
            }
            return Pair.create(CUSTOM, type.toString());
        }
        if (version.isSmallerThan(dt.protocolVersion)) {
            return Pair.create(CUSTOM, type.toString());
        }
        return dt.pair;
    }

    public static AbstractType toType(Pair<DataType, Object> entry) {
        try {
            switch ((DataType)((Object)entry.left)) {
                case CUSTOM: {
                    return TypeParser.parse((String)entry.right);
                }
                case LIST: {
                    return ListType.getInstance((AbstractType)entry.right, true);
                }
                case SET: {
                    return SetType.getInstance((AbstractType)entry.right, true);
                }
                case MAP: {
                    List l = (List)entry.right;
                    return MapType.getInstance((AbstractType)l.get(0), (AbstractType)l.get(1), true);
                }
                case UDT: {
                    return (AbstractType)entry.right;
                }
                case TUPLE: {
                    return (AbstractType)entry.right;
                }
            }
            return ((DataType)((Object)entry.left)).type;
        }
        catch (RequestValidationException e) {
            throw new ProtocolException(e.getMessage());
        }
    }

    @VisibleForTesting
    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    static {
        $VALUES = new DataType[]{CUSTOM, ASCII, BIGINT, BLOB, BOOLEAN, COUNTER, DECIMAL, DOUBLE, FLOAT, INT, TEXT, TIMESTAMP, UUID, VARCHAR, VARINT, TIMEUUID, INET, DATE, TIME, SMALLINT, BYTE, DURATION, LIST, MAP, SET, UDT, TUPLE};
        codec = new Codec();
        dataTypeMap = new HashMap<AbstractType, DataType>();
        for (DataType type : DataType.values()) {
            if (type.type == null) continue;
            dataTypeMap.put(type.type, type);
        }
    }

    public static final class Codec {
        private final DataType[] ids;

        public Codec() {
            DataType[] values = DataType.values();
            this.ids = new DataType[this.getMaxId(values) + 1];
            for (DataType opt : values) {
                int id = opt.getId(opt.getProtocolVersion());
                DataType existingType = this.ids[id];
                if (existingType != null) {
                    throw new IllegalStateException(String.format("Duplicate option id %d", id));
                }
                this.ids[id] = opt;
            }
        }

        private int getMaxId(DataType[] values) {
            int maxId = -1;
            for (DataType opt : values) {
                maxId = Math.max(maxId, opt.getId(ProtocolVersion.CURRENT));
            }
            return maxId;
        }

        private DataType fromId(int id) {
            DataType opt = this.ids[id];
            if (opt == null) {
                throw new ProtocolException(String.format("Unknown option id %d", id));
            }
            return opt;
        }

        public Pair<DataType, Object> decodeOne(ByteBuf body, ProtocolVersion version) {
            DataType opt = this.fromId(body.readUnsignedShort());
            Object value = opt.readValue(body, version);
            return Pair.create(opt, value);
        }

        public void writeOne(Pair<DataType, Object> option, ByteBuf dest, ProtocolVersion version) {
            DataType opt = (DataType)((Object)option.left);
            Object obj = option.right;
            dest.writeShort(opt.getId(version));
            opt.writeValue(obj, dest, version);
        }

        public int oneSerializedSize(Pair<DataType, Object> option, ProtocolVersion version) {
            DataType opt = (DataType)((Object)option.left);
            Object obj = option.right;
            return 2 + opt.serializedValueSize(obj, version);
        }
    }
}

