/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.SchemaConstants;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.functions.AbstractFunction;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.RowIterators;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.CQLTypeParser;
import org.apache.cassandra.schema.CachingParams;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.SpeculativeRetryParam;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.TriggerMetadata;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableList;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableSet;
import org.cassandraunit.shaded.com.google.common.collect.MapDifference;
import org.cassandraunit.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaKeyspace {
    private static final Logger logger = LoggerFactory.getLogger(SchemaKeyspace.class);
    private static final boolean FLUSH_SCHEMA_TABLES = Boolean.parseBoolean(System.getProperty("cassandra.test.flush_local_schema_changes", "true"));
    private static final boolean IGNORE_CORRUPTED_SCHEMA_TABLES = Boolean.parseBoolean(System.getProperty("cassandra.ignore_corrupted_schema_tables", "false"));
    public static final String KEYSPACES = "keyspaces";
    public static final String TABLES = "tables";
    public static final String COLUMNS = "columns";
    public static final String DROPPED_COLUMNS = "dropped_columns";
    public static final String TRIGGERS = "triggers";
    public static final String VIEWS = "views";
    public static final String TYPES = "types";
    public static final String FUNCTIONS = "functions";
    public static final String AGGREGATES = "aggregates";
    public static final String INDEXES = "indexes";
    public static final ImmutableList<String> ALL = ImmutableList.of("columns", "dropped_columns", "triggers", "types", "functions", "aggregates", "indexes", "tables", "views", "keyspaces");
    private static final Set<String> TABLES_WITH_CDC_ADDED = ImmutableSet.of("tables", "views");
    public static final ImmutableList<String> ALL_FOR_DIGEST = ImmutableList.of("keyspaces", "tables", "columns", "triggers", "views", "types", "functions", "aggregates", "indexes");
    private static final CFMetaData Keyspaces = SchemaKeyspace.compile("keyspaces", "keyspace definitions", "CREATE TABLE %s (keyspace_name text,durable_writes boolean,replication frozen<map<text, text>>,PRIMARY KEY ((keyspace_name)))");
    private static final CFMetaData Tables = SchemaKeyspace.compile("tables", "table definitions", "CREATE TABLE %s (keyspace_name text,table_name text,bloom_filter_fp_chance double,caching frozen<map<text, text>>,comment text,compaction frozen<map<text, text>>,compression frozen<map<text, text>>,crc_check_chance double,dclocal_read_repair_chance double,default_time_to_live int,extensions frozen<map<text, blob>>,flags frozen<set<text>>,gc_grace_seconds int,id uuid,max_index_interval int,memtable_flush_period_in_ms int,min_index_interval int,read_repair_chance double,speculative_retry text,cdc boolean,PRIMARY KEY ((keyspace_name), table_name))");
    private static final CFMetaData Columns = SchemaKeyspace.compile("columns", "column definitions", "CREATE TABLE %s (keyspace_name text,table_name text,column_name text,clustering_order text,column_name_bytes blob,kind text,position int,type text,PRIMARY KEY ((keyspace_name), table_name, column_name))");
    private static final CFMetaData DroppedColumns = SchemaKeyspace.compile("dropped_columns", "dropped column registry", "CREATE TABLE %s (keyspace_name text,table_name text,column_name text,dropped_time timestamp,type text,PRIMARY KEY ((keyspace_name), table_name, column_name))");
    private static final CFMetaData Triggers = SchemaKeyspace.compile("triggers", "trigger definitions", "CREATE TABLE %s (keyspace_name text,table_name text,trigger_name text,options frozen<map<text, text>>,PRIMARY KEY ((keyspace_name), table_name, trigger_name))");
    private static final CFMetaData Views = SchemaKeyspace.compile("views", "view definitions", "CREATE TABLE %s (keyspace_name text,view_name text,base_table_id uuid,base_table_name text,where_clause text,bloom_filter_fp_chance double,caching frozen<map<text, text>>,comment text,compaction frozen<map<text, text>>,compression frozen<map<text, text>>,crc_check_chance double,dclocal_read_repair_chance double,default_time_to_live int,extensions frozen<map<text, blob>>,gc_grace_seconds int,id uuid,include_all_columns boolean,max_index_interval int,memtable_flush_period_in_ms int,min_index_interval int,read_repair_chance double,speculative_retry text,cdc boolean,PRIMARY KEY ((keyspace_name), view_name))");
    private static final CFMetaData Indexes = SchemaKeyspace.compile("indexes", "secondary index definitions", "CREATE TABLE %s (keyspace_name text,table_name text,index_name text,kind text,options frozen<map<text, text>>,PRIMARY KEY ((keyspace_name), table_name, index_name))");
    private static final CFMetaData Types = SchemaKeyspace.compile("types", "user defined type definitions", "CREATE TABLE %s (keyspace_name text,type_name text,field_names frozen<list<text>>,field_types frozen<list<text>>,PRIMARY KEY ((keyspace_name), type_name))");
    private static final CFMetaData Functions = SchemaKeyspace.compile("functions", "user defined function definitions", "CREATE TABLE %s (keyspace_name text,function_name text,argument_types frozen<list<text>>,argument_names frozen<list<text>>,body text,language text,return_type text,called_on_null_input boolean,PRIMARY KEY ((keyspace_name), function_name, argument_types))");
    private static final CFMetaData Aggregates = SchemaKeyspace.compile("aggregates", "user defined aggregate definitions", "CREATE TABLE %s (keyspace_name text,aggregate_name text,argument_types frozen<list<text>>,final_func text,initcond text,return_type text,state_func text,state_type text,PRIMARY KEY ((keyspace_name), aggregate_name, argument_types))");
    public static final List<CFMetaData> ALL_TABLE_METADATA = ImmutableList.of(Keyspaces, Tables, Columns, Triggers, DroppedColumns, Views, Types, Functions, Aggregates, Indexes);

    private SchemaKeyspace() {
    }

    private static CFMetaData compile(String name, String description, String schema) {
        return CFMetaData.compile(String.format(schema, name), "system_schema").comment(description).gcGraceSeconds((int)TimeUnit.DAYS.toSeconds(7L));
    }

    public static KeyspaceMetadata metadata() {
        return KeyspaceMetadata.create("system_schema", KeyspaceParams.local(), org.apache.cassandra.schema.Tables.of(ALL_TABLE_METADATA));
    }

    public static void saveSystemKeyspacesSchema() {
        KeyspaceMetadata system = Schema.instance.getKSMetaData("system");
        KeyspaceMetadata schema = Schema.instance.getKSMetaData("system_schema");
        long timestamp = FBUtilities.timestampMicros();
        for (String schemaTable : ALL) {
            String query = String.format("DELETE FROM %s.%s USING TIMESTAMP ? WHERE keyspace_name = ?", "system_schema", schemaTable);
            for (String systemKeyspace : SchemaConstants.LOCAL_SYSTEM_KEYSPACE_NAMES) {
                QueryProcessor.executeOnceInternal(query, timestamp, systemKeyspace);
            }
        }
        SchemaKeyspace.makeCreateKeyspaceMutation(system, timestamp + 1L).build().apply();
        SchemaKeyspace.makeCreateKeyspaceMutation(schema, timestamp + 1L).build().apply();
    }

    public static void truncate() {
        ALL.reverse().forEach(table -> SchemaKeyspace.getSchemaCFS(table).truncateBlocking());
    }

    static void flush() {
        if (!DatabaseDescriptor.isUnsafeSystem()) {
            ALL.forEach(table -> FBUtilities.waitOnFuture(SchemaKeyspace.getSchemaCFS(table).forceFlush()));
        }
    }

    public static Pair<UUID, UUID> calculateSchemaDigest() {
        Set<ByteBuffer> cdc = Collections.singleton(ByteBufferUtil.bytes("cdc"));
        return SchemaKeyspace.calculateSchemaDigest(cdc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static Pair<UUID, UUID> calculateSchemaDigest(Set<ByteBuffer> columnsToExclude) {
        MessageDigest digest30;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
            digest30 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Iterator iterator = ALL_FOR_DIGEST.iterator();
        block28: while (iterator.hasNext()) {
            String table = (String)iterator.next();
            ReadCommand cmd = SchemaKeyspace.getReadCommandForTableSchema(table);
            ReadExecutionController executionController = cmd.executionController();
            Throwable throwable = null;
            try {
                PartitionIterator schema = cmd.executeInternal(executionController);
                Throwable throwable2 = null;
                try {
                    while (true) {
                        RowIterator partition;
                        block34: {
                            if (!schema.hasNext()) continue block28;
                            partition = (RowIterator)schema.next();
                            Throwable throwable3 = null;
                            try {
                                if (!SchemaKeyspace.isSystemKeyspaceSchemaPartition(partition.partitionKey())) {
                                    RowIterators.digest(partition, digest, digest30, columnsToExclude);
                                }
                                if (partition == null) continue;
                                if (throwable3 == null) break block34;
                            }
                            catch (Throwable throwable4) {
                                try {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (partition == null) throw throwable5;
                                    if (throwable3 != null) {
                                        try {
                                            partition.close();
                                            throw throwable5;
                                        }
                                        catch (Throwable throwable6) {
                                            throwable3.addSuppressed(throwable6);
                                            throw throwable5;
                                        }
                                    }
                                    partition.close();
                                    throw throwable5;
                                }
                            }
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        partition.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (schema == null) continue;
                    if (throwable2 != null) {
                        try {
                            schema.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    schema.close();
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (executionController == null) continue;
                if (throwable != null) {
                    try {
                        executionController.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                    continue;
                }
                executionController.close();
            }
        }
        return Pair.create(UUID.nameUUIDFromBytes(digest.digest()), UUID.nameUUIDFromBytes(digest30.digest()));
    }

    private static ColumnFamilyStore getSchemaCFS(String schemaTableName) {
        return Keyspace.open("system_schema").getColumnFamilyStore(schemaTableName);
    }

    private static ReadCommand getReadCommandForTableSchema(String schemaTableName) {
        ColumnFamilyStore cfs = SchemaKeyspace.getSchemaCFS(schemaTableName);
        return PartitionRangeReadCommand.allDataRead(cfs.metadata, FBUtilities.nowInSeconds());
    }

    public static Collection<Mutation> convertSchemaToMutations() {
        HashMap<DecoratedKey, Mutation> mutationMap = new HashMap<DecoratedKey, Mutation>();
        for (String table : ALL) {
            SchemaKeyspace.convertSchemaToMutations(mutationMap, table);
        }
        return mutationMap.values();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void convertSchemaToMutations(Map<DecoratedKey, Mutation> mutationMap, String schemaTableName) {
        ReadCommand cmd = SchemaKeyspace.getReadCommandForTableSchema(schemaTableName);
        try (ReadExecutionController executionController = cmd.executionController();
             UnfilteredPartitionIterator iter = cmd.executeLocally(executionController);){
            Throwable throwable;
            UnfilteredRowIterator partition;
            while (iter.hasNext()) {
                block40: {
                    block38: {
                        block39: {
                            partition = (UnfilteredRowIterator)iter.next();
                            throwable = null;
                            if (!SchemaKeyspace.isSystemKeyspaceSchemaPartition(partition.partitionKey())) break block38;
                            if (partition == null) continue;
                            if (throwable == null) break block39;
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        partition.close();
                        continue;
                    }
                    DecoratedKey key = partition.partitionKey();
                    Mutation mutation = mutationMap.get(key);
                    if (mutation == null) {
                        mutation = new Mutation("system_schema", key);
                        mutationMap.put(key, mutation);
                    }
                    mutation.add(SchemaKeyspace.makeUpdateForSchema(partition, cmd.columnFilter()));
                    if (partition == null) continue;
                    if (throwable == null) break block40;
                    try {
                        partition.close();
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                        continue;
                    }
                }
                partition.close();
            }
            return;
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (partition == null) throw throwable5;
                    if (throwable != null) {
                        try {
                            partition.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                    partition.close();
                    throw throwable5;
                }
            }
        }
    }

    private static PartitionUpdate makeUpdateForSchema(UnfilteredRowIterator partition, ColumnFilter filter) {
        if (DatabaseDescriptor.isCDCEnabled() || !TABLES_WITH_CDC_ADDED.contains(partition.metadata().cfName)) {
            return PartitionUpdate.fromIterator(partition, filter);
        }
        ColumnFilter.Builder builder = ColumnFilter.allColumnsBuilder(partition.metadata());
        for (ColumnDefinition column : filter.fetchedColumns()) {
            if (column.name.toString().equals("cdc")) continue;
            builder.add(column);
        }
        return PartitionUpdate.fromIterator(partition, builder.build());
    }

    private static boolean isSystemKeyspaceSchemaPartition(DecoratedKey partitionKey) {
        return SchemaConstants.isLocalSystemKeyspace((String)UTF8Type.instance.compose(partitionKey.getKey()));
    }

    private static DecoratedKey decorate(CFMetaData metadata, Object value) {
        return metadata.decorateKey(metadata.getKeyValidator().decompose(value));
    }

    public static Mutation.SimpleBuilder makeCreateKeyspaceMutation(String name, KeyspaceParams params, long timestamp) {
        Mutation.SimpleBuilder builder = Mutation.simpleBuilder(SchemaKeyspace.Keyspaces.ksName, SchemaKeyspace.decorate(Keyspaces, name)).timestamp(timestamp);
        builder.update(Keyspaces).row(new Object[0]).add(KeyspaceParams.Option.DURABLE_WRITES.toString(), params.durableWrites).add(KeyspaceParams.Option.REPLICATION.toString(), params.replication.asMap());
        return builder;
    }

    public static Mutation.SimpleBuilder makeCreateKeyspaceMutation(KeyspaceMetadata keyspace, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        keyspace.tables.forEach(table -> SchemaKeyspace.addTableToSchemaMutation(table, true, builder));
        keyspace.views.forEach(view -> SchemaKeyspace.addViewToSchemaMutation(view, true, builder));
        keyspace.types.forEach(type -> SchemaKeyspace.addTypeToSchemaMutation(type, builder));
        keyspace.functions.udfs().forEach(udf -> SchemaKeyspace.addFunctionToSchemaMutation(udf, builder));
        keyspace.functions.udas().forEach(uda -> SchemaKeyspace.addAggregateToSchemaMutation(uda, builder));
        return builder;
    }

    public static Mutation.SimpleBuilder makeDropKeyspaceMutation(KeyspaceMetadata keyspace, long timestamp) {
        Mutation.SimpleBuilder builder = Mutation.simpleBuilder("system_schema", SchemaKeyspace.decorate(Keyspaces, keyspace.name)).timestamp(timestamp);
        for (CFMetaData schemaTable : ALL_TABLE_METADATA) {
            builder.update(schemaTable).delete();
        }
        return builder;
    }

    public static Mutation.SimpleBuilder makeCreateTypeMutation(KeyspaceMetadata keyspace, UserType type, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addTypeToSchemaMutation(type, builder);
        return builder;
    }

    static void addTypeToSchemaMutation(UserType type, Mutation.SimpleBuilder mutation) {
        mutation.update(Types).row(type.getNameAsString()).add("field_names", type.fieldNames().stream().map(FieldIdentifier::toString).collect(Collectors.toList())).add("field_types", type.fieldTypes().stream().map(AbstractType::asCQL3Type).map(Object::toString).collect(Collectors.toList()));
    }

    public static Mutation.SimpleBuilder dropTypeFromSchemaMutation(KeyspaceMetadata keyspace, UserType type, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        builder.update(Types).row(type.name).delete();
        return builder;
    }

    public static Mutation.SimpleBuilder makeCreateTableMutation(KeyspaceMetadata keyspace, CFMetaData table, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addTableToSchemaMutation(table, true, builder);
        return builder;
    }

    static void addTableToSchemaMutation(CFMetaData table, boolean withColumnsAndTriggers, Mutation.SimpleBuilder builder) {
        Row.SimpleBuilder rowBuilder = builder.update(Tables).row(table.cfName).add("id", table.cfId).add("flags", CFMetaData.flagsToStrings(table.flags()));
        SchemaKeyspace.addTableParamsToRowBuilder(table.params, rowBuilder);
        if (withColumnsAndTriggers) {
            for (ColumnDefinition columnDefinition : table.allColumns()) {
                SchemaKeyspace.addColumnToSchemaMutation(table, columnDefinition, builder);
            }
            for (CFMetaData.DroppedColumn droppedColumn : table.getDroppedColumns().values()) {
                SchemaKeyspace.addDroppedColumnToSchemaMutation(table, droppedColumn, builder);
            }
            for (TriggerMetadata triggerMetadata : table.getTriggers()) {
                SchemaKeyspace.addTriggerToSchemaMutation(table, triggerMetadata, builder);
            }
            for (IndexMetadata indexMetadata : table.getIndexes()) {
                SchemaKeyspace.addIndexToSchemaMutation(table, indexMetadata, builder);
            }
        }
    }

    private static void addTableParamsToRowBuilder(TableParams params, Row.SimpleBuilder builder) {
        builder.add("bloom_filter_fp_chance", params.bloomFilterFpChance).add("comment", params.comment).add("dclocal_read_repair_chance", params.dcLocalReadRepairChance).add("default_time_to_live", params.defaultTimeToLive).add("gc_grace_seconds", params.gcGraceSeconds).add("max_index_interval", params.maxIndexInterval).add("memtable_flush_period_in_ms", params.memtableFlushPeriodInMs).add("min_index_interval", params.minIndexInterval).add("read_repair_chance", params.readRepairChance).add("speculative_retry", params.speculativeRetry.toString()).add("crc_check_chance", params.crcCheckChance).add("caching", params.caching.asMap()).add("compaction", params.compaction.asMap()).add("compression", params.compression.asMap()).add("extensions", params.extensions);
        if (DatabaseDescriptor.isCDCEnabled()) {
            builder.add("cdc", params.cdc);
        }
    }

    public static Mutation.SimpleBuilder makeUpdateTableMutation(KeyspaceMetadata keyspace, CFMetaData oldTable, CFMetaData newTable, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addTableToSchemaMutation(newTable, false, builder);
        MapDifference<ByteBuffer, ColumnDefinition> columnDiff = Maps.difference(oldTable.getColumnMetadata(), newTable.getColumnMetadata());
        for (ColumnDefinition columnDefinition : columnDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(oldTable, columnDefinition, builder);
        }
        for (ColumnDefinition columnDefinition : columnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addColumnToSchemaMutation(newTable, columnDefinition, builder);
        }
        for (ByteBuffer byteBuffer : columnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addColumnToSchemaMutation(newTable, newTable.getColumnDefinition(byteBuffer), builder);
        }
        MapDifference<ByteBuffer, CFMetaData.DroppedColumn> droppedColumnDiff = Maps.difference(oldTable.getDroppedColumns(), newTable.getDroppedColumns());
        for (CFMetaData.DroppedColumn droppedColumn : droppedColumnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(newTable, droppedColumn, builder);
        }
        for (ByteBuffer byteBuffer : droppedColumnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(newTable, newTable.getDroppedColumns().get(byteBuffer), builder);
        }
        MapDifference<String, TriggerMetadata> mapDifference = SchemaKeyspace.triggersDiff(oldTable.getTriggers(), newTable.getTriggers());
        for (TriggerMetadata trigger : mapDifference.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropTriggerFromSchemaMutation(oldTable, trigger, builder);
        }
        for (TriggerMetadata trigger : mapDifference.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addTriggerToSchemaMutation(newTable, trigger, builder);
        }
        MapDifference<String, IndexMetadata> mapDifference2 = SchemaKeyspace.indexesDiff(oldTable.getIndexes(), newTable.getIndexes());
        for (IndexMetadata indexMetadata : mapDifference2.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropIndexFromSchemaMutation(oldTable, indexMetadata, builder);
        }
        for (IndexMetadata indexMetadata : mapDifference2.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addIndexToSchemaMutation(newTable, indexMetadata, builder);
        }
        for (MapDifference.ValueDifference valueDifference : mapDifference2.entriesDiffering().values()) {
            SchemaKeyspace.addUpdatedIndexToSchemaMutation(newTable, (IndexMetadata)valueDifference.rightValue(), builder);
        }
        return builder;
    }

    private static MapDifference<String, IndexMetadata> indexesDiff(Indexes before, Indexes after) {
        HashMap beforeMap = new HashMap();
        before.forEach(i -> beforeMap.put(i.name, i));
        HashMap afterMap = new HashMap();
        after.forEach(i -> afterMap.put(i.name, i));
        return Maps.difference(beforeMap, afterMap);
    }

    private static MapDifference<String, TriggerMetadata> triggersDiff(Triggers before, Triggers after) {
        HashMap beforeMap = new HashMap();
        before.forEach(t -> beforeMap.put(t.name, t));
        HashMap afterMap = new HashMap();
        after.forEach(t -> afterMap.put(t.name, t));
        return Maps.difference(beforeMap, afterMap);
    }

    public static Mutation.SimpleBuilder makeDropTableMutation(KeyspaceMetadata keyspace, CFMetaData table, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        builder.update(Tables).row(table.cfName).delete();
        for (ColumnDefinition columnDefinition : table.allColumns()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(table, columnDefinition, builder);
        }
        for (CFMetaData.DroppedColumn droppedColumn : table.getDroppedColumns().values()) {
            SchemaKeyspace.dropDroppedColumnFromSchemaMutation(table, droppedColumn, timestamp, builder);
        }
        for (TriggerMetadata triggerMetadata : table.getTriggers()) {
            SchemaKeyspace.dropTriggerFromSchemaMutation(table, triggerMetadata, builder);
        }
        for (IndexMetadata indexMetadata : table.getIndexes()) {
            SchemaKeyspace.dropIndexFromSchemaMutation(table, indexMetadata, builder);
        }
        return builder;
    }

    private static void addColumnToSchemaMutation(CFMetaData table, ColumnDefinition column, Mutation.SimpleBuilder builder) {
        AbstractType type = column.type;
        if (type instanceof ReversedType) {
            type = ((ReversedType)type).baseType;
        }
        builder.update(Columns).row(table.cfName, column.name.toString()).add("column_name_bytes", column.name.bytes).add("kind", column.kind.toString().toLowerCase()).add("position", column.position()).add("clustering_order", column.clusteringOrder().toString().toLowerCase()).add("type", type.asCQL3Type().toString());
    }

    private static void dropColumnFromSchemaMutation(CFMetaData table, ColumnDefinition column, Mutation.SimpleBuilder builder) {
        builder.update(Columns).row(table.cfName, column.name.toString()).delete();
    }

    private static void addDroppedColumnToSchemaMutation(CFMetaData table, CFMetaData.DroppedColumn column, Mutation.SimpleBuilder builder) {
        builder.update(DroppedColumns).row(table.cfName, column.name).add("dropped_time", new Date(TimeUnit.MICROSECONDS.toMillis(column.droppedTime))).add("type", SchemaKeyspace.expandUserTypes(column.type).asCQL3Type().toString());
    }

    private static void dropDroppedColumnFromSchemaMutation(CFMetaData table, CFMetaData.DroppedColumn column, long timestamp, Mutation.SimpleBuilder builder) {
        builder.update(DroppedColumns).row(table.cfName, column.name).delete();
    }

    private static void addTriggerToSchemaMutation(CFMetaData table, TriggerMetadata trigger, Mutation.SimpleBuilder builder) {
        builder.update(Triggers).row(table.cfName, trigger.name).add("options", Collections.singletonMap("class", trigger.classOption));
    }

    private static void dropTriggerFromSchemaMutation(CFMetaData table, TriggerMetadata trigger, Mutation.SimpleBuilder builder) {
        builder.update(Triggers).row(table.cfName, trigger.name).delete();
    }

    public static Mutation.SimpleBuilder makeCreateViewMutation(KeyspaceMetadata keyspace, ViewDefinition view, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addViewToSchemaMutation(view, true, builder);
        return builder;
    }

    private static void addViewToSchemaMutation(ViewDefinition view, boolean includeColumns, Mutation.SimpleBuilder builder) {
        CFMetaData table = view.metadata;
        Row.SimpleBuilder rowBuilder = builder.update(Views).row(view.viewName).add("include_all_columns", view.includeAllColumns).add("base_table_id", view.baseTableId).add("base_table_name", view.baseTableMetadata().cfName).add("where_clause", view.whereClause).add("id", table.cfId);
        SchemaKeyspace.addTableParamsToRowBuilder(table.params, rowBuilder);
        if (includeColumns) {
            for (ColumnDefinition columnDefinition : table.allColumns()) {
                SchemaKeyspace.addColumnToSchemaMutation(table, columnDefinition, builder);
            }
            for (CFMetaData.DroppedColumn droppedColumn : table.getDroppedColumns().values()) {
                SchemaKeyspace.addDroppedColumnToSchemaMutation(table, droppedColumn, builder);
            }
        }
    }

    public static Mutation.SimpleBuilder makeDropViewMutation(KeyspaceMetadata keyspace, ViewDefinition view, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        builder.update(Views).row(view.viewName).delete();
        CFMetaData table = view.metadata;
        for (ColumnDefinition column : table.allColumns()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(table, column, builder);
        }
        for (IndexMetadata index : table.getIndexes()) {
            SchemaKeyspace.dropIndexFromSchemaMutation(table, index, builder);
        }
        return builder;
    }

    public static Mutation.SimpleBuilder makeUpdateViewMutation(Mutation.SimpleBuilder builder, ViewDefinition oldView, ViewDefinition newView) {
        SchemaKeyspace.addViewToSchemaMutation(newView, false, builder);
        MapDifference<ByteBuffer, ColumnDefinition> columnDiff = Maps.difference(oldView.metadata.getColumnMetadata(), newView.metadata.getColumnMetadata());
        for (ColumnDefinition column : columnDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(oldView.metadata, column, builder);
        }
        for (ColumnDefinition column : columnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addColumnToSchemaMutation(newView.metadata, column, builder);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addColumnToSchemaMutation(newView.metadata, newView.metadata.getColumnDefinition(name), builder);
        }
        MapDifference<ByteBuffer, CFMetaData.DroppedColumn> droppedColumnDiff = Maps.difference(oldView.metadata.getDroppedColumns(), oldView.metadata.getDroppedColumns());
        for (CFMetaData.DroppedColumn column : droppedColumnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(oldView.metadata, column, builder);
        }
        for (ByteBuffer name : droppedColumnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(newView.metadata, newView.metadata.getDroppedColumns().get(name), builder);
        }
        return builder;
    }

    private static void addIndexToSchemaMutation(CFMetaData table, IndexMetadata index, Mutation.SimpleBuilder builder) {
        builder.update(Indexes).row(table.cfName, index.name).add("kind", index.kind.toString()).add("options", index.options);
    }

    private static void dropIndexFromSchemaMutation(CFMetaData table, IndexMetadata index, Mutation.SimpleBuilder builder) {
        builder.update(Indexes).row(table.cfName, index.name).delete();
    }

    private static void addUpdatedIndexToSchemaMutation(CFMetaData table, IndexMetadata index, Mutation.SimpleBuilder builder) {
        SchemaKeyspace.addIndexToSchemaMutation(table, index, builder);
    }

    public static Mutation.SimpleBuilder makeCreateFunctionMutation(KeyspaceMetadata keyspace, UDFunction function, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addFunctionToSchemaMutation(function, builder);
        return builder;
    }

    static void addFunctionToSchemaMutation(UDFunction function, Mutation.SimpleBuilder builder) {
        builder.update(Functions).row(function.name().name, SchemaKeyspace.functionArgumentsList(function)).add("body", function.body()).add("language", function.language()).add("return_type", function.returnType().asCQL3Type().toString()).add("called_on_null_input", function.isCalledOnNullInput()).add("argument_names", function.argNames().stream().map(c -> SchemaKeyspace.bbToString(c.bytes)).collect(Collectors.toList()));
    }

    private static String bbToString(ByteBuffer bb) {
        try {
            return ByteBufferUtil.string(bb);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> functionArgumentsList(AbstractFunction fun) {
        return fun.argTypes().stream().map(AbstractType::asCQL3Type).map(Object::toString).collect(Collectors.toList());
    }

    public static Mutation.SimpleBuilder makeDropFunctionMutation(KeyspaceMetadata keyspace, UDFunction function, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        builder.update(Functions).row(function.name().name, SchemaKeyspace.functionArgumentsList(function)).delete();
        return builder;
    }

    public static Mutation.SimpleBuilder makeCreateAggregateMutation(KeyspaceMetadata keyspace, UDAggregate aggregate, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addAggregateToSchemaMutation(aggregate, builder);
        return builder;
    }

    static void addAggregateToSchemaMutation(UDAggregate aggregate, Mutation.SimpleBuilder builder) {
        builder.update(Aggregates).row(aggregate.name().name, SchemaKeyspace.functionArgumentsList(aggregate)).add("return_type", aggregate.returnType().asCQL3Type().toString()).add("state_func", aggregate.stateFunction().name().name).add("state_type", aggregate.stateType().asCQL3Type().toString()).add("final_func", aggregate.finalFunction() != null ? aggregate.finalFunction().name().name : null).add("initcond", aggregate.initialCondition() != null ? aggregate.stateType().freeze().asCQL3Type().toCQLLiteral(aggregate.initialCondition(), ProtocolVersion.CURRENT) : null);
    }

    public static Mutation.SimpleBuilder makeDropAggregateMutation(KeyspaceMetadata keyspace, UDAggregate aggregate, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        builder.update(Aggregates).row(aggregate.name().name, SchemaKeyspace.functionArgumentsList(aggregate)).delete();
        return builder;
    }

    public static Keyspaces fetchNonSystemKeyspaces() {
        return SchemaKeyspace.fetchKeyspacesWithout(SchemaConstants.LOCAL_SYSTEM_KEYSPACE_NAMES);
    }

    private static Keyspaces fetchKeyspacesWithout(Set<String> excludedKeyspaceNames) {
        String query = String.format("SELECT keyspace_name FROM %s.%s", "system_schema", KEYSPACES);
        Keyspaces.Builder keyspaces = org.apache.cassandra.schema.Keyspaces.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, new Object[0])) {
            String keyspaceName = row.getString("keyspace_name");
            if (excludedKeyspaceNames.contains(keyspaceName)) continue;
            keyspaces.add(SchemaKeyspace.fetchKeyspace(keyspaceName));
        }
        return keyspaces.build();
    }

    private static Keyspaces fetchKeyspacesOnly(Set<String> includedKeyspaceNames) {
        String query = String.format("SELECT keyspace_name FROM %s.%s WHERE keyspace_name IN ?", "system_schema", KEYSPACES);
        Keyspaces.Builder keyspaces = org.apache.cassandra.schema.Keyspaces.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, new ArrayList<String>(includedKeyspaceNames))) {
            keyspaces.add(SchemaKeyspace.fetchKeyspace(row.getString("keyspace_name")));
        }
        return keyspaces.build();
    }

    private static KeyspaceMetadata fetchKeyspace(String keyspaceName) {
        KeyspaceParams params = SchemaKeyspace.fetchKeyspaceParams(keyspaceName);
        Types types = SchemaKeyspace.fetchTypes(keyspaceName);
        Tables tables = SchemaKeyspace.fetchTables(keyspaceName, types);
        Views views = SchemaKeyspace.fetchViews(keyspaceName, types);
        Functions functions = SchemaKeyspace.fetchFunctions(keyspaceName, types);
        return KeyspaceMetadata.create(keyspaceName, params, tables, views, types, functions);
    }

    private static KeyspaceParams fetchKeyspaceParams(String keyspaceName) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", KEYSPACES);
        UntypedResultSet.Row row = SchemaKeyspace.query(query, keyspaceName).one();
        boolean durableWrites = row.getBoolean(KeyspaceParams.Option.DURABLE_WRITES.toString());
        Map<String, String> replication = row.getFrozenTextMap(KeyspaceParams.Option.REPLICATION.toString());
        return KeyspaceParams.create(durableWrites, replication);
    }

    private static Types fetchTypes(String keyspaceName) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", TYPES);
        Types.RawBuilder types = org.apache.cassandra.schema.Types.rawBuilder(keyspaceName);
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            String name = row.getString("type_name");
            List<String> fieldNames = row.getFrozenList("field_names", UTF8Type.instance);
            List<String> fieldTypes = row.getFrozenList("field_types", UTF8Type.instance);
            types.add(name, fieldNames, fieldTypes);
        }
        return types.build();
    }

    private static Tables fetchTables(String keyspaceName, Types types) {
        String query = String.format("SELECT table_name FROM %s.%s WHERE keyspace_name = ?", "system_schema", TABLES);
        Tables.Builder tables = org.apache.cassandra.schema.Tables.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            String tableName = row.getString("table_name");
            try {
                tables.add(SchemaKeyspace.fetchTable(keyspaceName, tableName, types));
            }
            catch (MissingColumns exc) {
                if (IGNORE_CORRUPTED_SCHEMA_TABLES) continue;
                logger.error("No columns found for table {}.{} in {}.{}.  This may be due to corruption or concurrent dropping and altering of a table.  If this table is supposed to be dropped, restart cassandra with -Dcassandra.ignore_corrupted_schema_tables=true and run the following query: \"DELETE FROM {}.{} WHERE keyspace_name = '{}' AND table_name = '{}';\".If the table is not supposed to be dropped, restore {}.{} sstables from backups.", new Object[]{keyspaceName, tableName, "system_schema", COLUMNS, "system_schema", TABLES, keyspaceName, tableName, "system_schema", COLUMNS});
                throw exc;
            }
        }
        return tables.build();
    }

    private static CFMetaData fetchTable(String keyspaceName, String tableName, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", TABLES);
        UntypedResultSet rows = SchemaKeyspace.query(query, keyspaceName, tableName);
        if (rows.isEmpty()) {
            throw new RuntimeException(String.format("%s:%s not found in the schema definitions keyspace.", keyspaceName, tableName));
        }
        UntypedResultSet.Row row = rows.one();
        UUID id = row.getUUID("id");
        Set<CFMetaData.Flag> flags = CFMetaData.flagsFromStrings(row.getFrozenSet("flags", UTF8Type.instance));
        boolean isSuper = flags.contains((Object)CFMetaData.Flag.SUPER);
        boolean isCounter = flags.contains((Object)CFMetaData.Flag.COUNTER);
        boolean isDense = flags.contains((Object)CFMetaData.Flag.DENSE);
        boolean isCompound = flags.contains((Object)CFMetaData.Flag.COMPOUND);
        List<ColumnDefinition> columns = SchemaKeyspace.fetchColumns(keyspaceName, tableName, types);
        if (!columns.stream().anyMatch(ColumnDefinition::isPartitionKey)) {
            String msg = String.format("Table %s.%s did not have any partition key columns in the schema tables", keyspaceName, tableName);
            throw new AssertionError((Object)msg);
        }
        Map<ByteBuffer, CFMetaData.DroppedColumn> droppedColumns = SchemaKeyspace.fetchDroppedColumns(keyspaceName, tableName);
        Indexes indexes = SchemaKeyspace.fetchIndexes(keyspaceName, tableName);
        Triggers triggers = SchemaKeyspace.fetchTriggers(keyspaceName, tableName);
        return CFMetaData.create(keyspaceName, tableName, id, isDense, isCompound, isSuper, isCounter, false, columns, DatabaseDescriptor.getPartitioner()).params(SchemaKeyspace.createTableParamsFromRow(row)).droppedColumns(droppedColumns).indexes(indexes).triggers(triggers);
    }

    public static TableParams createTableParamsFromRow(UntypedResultSet.Row row) {
        return TableParams.builder().bloomFilterFpChance(row.getDouble("bloom_filter_fp_chance")).caching(CachingParams.fromMap(row.getFrozenTextMap("caching"))).comment(row.getString("comment")).compaction(CompactionParams.fromMap(row.getFrozenTextMap("compaction"))).compression(CompressionParams.fromMap(row.getFrozenTextMap("compression"))).dcLocalReadRepairChance(row.getDouble("dclocal_read_repair_chance")).defaultTimeToLive(row.getInt("default_time_to_live")).extensions(row.getFrozenMap("extensions", UTF8Type.instance, BytesType.instance)).gcGraceSeconds(row.getInt("gc_grace_seconds")).maxIndexInterval(row.getInt("max_index_interval")).memtableFlushPeriodInMs(row.getInt("memtable_flush_period_in_ms")).minIndexInterval(row.getInt("min_index_interval")).readRepairChance(row.getDouble("read_repair_chance")).crcCheckChance(row.getDouble("crc_check_chance")).speculativeRetry(SpeculativeRetryParam.fromString(row.getString("speculative_retry"))).cdc(row.has("cdc") ? row.getBoolean("cdc") : false).build();
    }

    private static List<ColumnDefinition> fetchColumns(String keyspace, String table, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", COLUMNS);
        UntypedResultSet columnRows = SchemaKeyspace.query(query, keyspace, table);
        if (columnRows.isEmpty()) {
            throw new MissingColumns("Columns not found in schema table for " + keyspace + "." + table);
        }
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
        columnRows.forEach(row -> columns.add(SchemaKeyspace.createColumnFromRow(row, types)));
        return columns;
    }

    public static ColumnDefinition createColumnFromRow(UntypedResultSet.Row row, Types types) {
        String keyspace = row.getString("keyspace_name");
        String table = row.getString("table_name");
        ColumnDefinition.Kind kind = ColumnDefinition.Kind.valueOf(row.getString("kind").toUpperCase());
        int position = row.getInt("position");
        ColumnDefinition.ClusteringOrder order = ColumnDefinition.ClusteringOrder.valueOf(row.getString("clustering_order").toUpperCase());
        AbstractType<?> type = CQLTypeParser.parse(keyspace, row.getString("type"), types);
        if (order == ColumnDefinition.ClusteringOrder.DESC) {
            type = ReversedType.getInstance(type);
        }
        ColumnIdentifier name = ColumnIdentifier.getInterned(type, row.getBytes("column_name_bytes"), row.getString("column_name"));
        return new ColumnDefinition(keyspace, table, name, type, position, kind);
    }

    private static Map<ByteBuffer, CFMetaData.DroppedColumn> fetchDroppedColumns(String keyspace, String table) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", DROPPED_COLUMNS);
        HashMap<ByteBuffer, CFMetaData.DroppedColumn> columns = new HashMap<ByteBuffer, CFMetaData.DroppedColumn>();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspace, table)) {
            CFMetaData.DroppedColumn column = SchemaKeyspace.createDroppedColumnFromRow(row);
            columns.put(UTF8Type.instance.decompose(column.name), column);
        }
        return columns;
    }

    private static CFMetaData.DroppedColumn createDroppedColumnFromRow(UntypedResultSet.Row row) {
        String keyspace = row.getString("keyspace_name");
        String name = row.getString("column_name");
        AbstractType<?> type = CQLTypeParser.parse(keyspace, row.getString("type"), org.apache.cassandra.schema.Types.none());
        long droppedTime = TimeUnit.MILLISECONDS.toMicros(row.getLong("dropped_time"));
        return new CFMetaData.DroppedColumn(name, type, droppedTime);
    }

    private static Indexes fetchIndexes(String keyspace, String table) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", INDEXES);
        Indexes.Builder indexes = org.apache.cassandra.schema.Indexes.builder();
        SchemaKeyspace.query(query, keyspace, table).forEach(row -> indexes.add(SchemaKeyspace.createIndexMetadataFromRow(row)));
        return indexes.build();
    }

    private static IndexMetadata createIndexMetadataFromRow(UntypedResultSet.Row row) {
        String name = row.getString("index_name");
        IndexMetadata.Kind type = IndexMetadata.Kind.valueOf(row.getString("kind"));
        Map<String, String> options = row.getFrozenTextMap("options");
        return IndexMetadata.fromSchemaMetadata(name, type, options);
    }

    private static Triggers fetchTriggers(String keyspace, String table) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", TRIGGERS);
        Triggers.Builder triggers = org.apache.cassandra.schema.Triggers.builder();
        SchemaKeyspace.query(query, keyspace, table).forEach(row -> triggers.add(SchemaKeyspace.createTriggerFromRow(row)));
        return triggers.build();
    }

    private static TriggerMetadata createTriggerFromRow(UntypedResultSet.Row row) {
        String name = row.getString("trigger_name");
        String classOption = row.getFrozenTextMap("options").get("class");
        return new TriggerMetadata(name, classOption);
    }

    private static Views fetchViews(String keyspaceName, Types types) {
        String query = String.format("SELECT view_name FROM %s.%s WHERE keyspace_name = ?", "system_schema", VIEWS);
        Views.Builder views = org.apache.cassandra.schema.Views.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            views.add(SchemaKeyspace.fetchView(keyspaceName, row.getString("view_name"), types));
        }
        return views.build();
    }

    private static ViewDefinition fetchView(String keyspaceName, String viewName, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND view_name = ?", "system_schema", VIEWS);
        UntypedResultSet rows = SchemaKeyspace.query(query, keyspaceName, viewName);
        if (rows.isEmpty()) {
            throw new RuntimeException(String.format("%s:%s not found in the schema definitions keyspace.", keyspaceName, viewName));
        }
        UntypedResultSet.Row row = rows.one();
        UUID id = row.getUUID("id");
        UUID baseTableId = row.getUUID("base_table_id");
        String baseTableName = row.getString("base_table_name");
        boolean includeAll = row.getBoolean("include_all_columns");
        String whereClause = row.getString("where_clause");
        List<ColumnDefinition> columns = SchemaKeyspace.fetchColumns(keyspaceName, viewName, types);
        Map<ByteBuffer, CFMetaData.DroppedColumn> droppedColumns = SchemaKeyspace.fetchDroppedColumns(keyspaceName, viewName);
        CFMetaData cfm = CFMetaData.create(keyspaceName, viewName, id, false, true, false, false, true, columns, DatabaseDescriptor.getPartitioner()).params(SchemaKeyspace.createTableParamsFromRow(row)).droppedColumns(droppedColumns);
        String rawSelect = View.buildSelectStatement(baseTableName, columns, whereClause);
        SelectStatement.RawStatement rawStatement = (SelectStatement.RawStatement)QueryProcessor.parseStatement(rawSelect);
        return new ViewDefinition(keyspaceName, viewName, baseTableId, baseTableName, includeAll, rawStatement, whereClause, cfm);
    }

    private static Functions fetchFunctions(String keyspaceName, Types types) {
        Functions udfs = SchemaKeyspace.fetchUDFs(keyspaceName, types);
        Functions udas = SchemaKeyspace.fetchUDAs(keyspaceName, udfs, types);
        return org.apache.cassandra.schema.Functions.builder().add(udfs).add(udas).build();
    }

    private static Functions fetchUDFs(String keyspaceName, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", FUNCTIONS);
        Functions.Builder functions = org.apache.cassandra.schema.Functions.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            functions.add((Function)SchemaKeyspace.createUDFFromRow(row, types));
        }
        return functions.build();
    }

    private static UDFunction createUDFFromRow(UntypedResultSet.Row row, Types types) {
        UDFunction udf;
        String ksName = row.getString("keyspace_name");
        String functionName = row.getString("function_name");
        FunctionName name = new FunctionName(ksName, functionName);
        ArrayList<ColumnIdentifier> argNames = new ArrayList<ColumnIdentifier>();
        for (String string : row.getFrozenList("argument_names", UTF8Type.instance)) {
            argNames.add(new ColumnIdentifier(string, true));
        }
        ArrayList argTypes = new ArrayList();
        for (String type : row.getFrozenList("argument_types", UTF8Type.instance)) {
            argTypes.add(CQLTypeParser.parse(ksName, type, types));
        }
        AbstractType<?> abstractType = CQLTypeParser.parse(ksName, row.getString("return_type"), types);
        String language = row.getString("language");
        String body = row.getString("body");
        boolean calledOnNullInput = row.getBoolean("called_on_null_input");
        Function existing = Schema.instance.findFunction(name, argTypes).orElse(null);
        if (existing instanceof UDFunction && (udf = (UDFunction)existing).argNames().equals(argNames) && udf.returnType().equals(abstractType) && !udf.isAggregate() && udf.language().equals(language) && udf.body().equals(body) && udf.isCalledOnNullInput() == calledOnNullInput) {
            logger.trace("Skipping duplicate compilation of already existing UDF {}", (Object)name);
            return udf;
        }
        try {
            return UDFunction.create(name, argNames, argTypes, abstractType, calledOnNullInput, language, body);
        }
        catch (InvalidRequestException e) {
            logger.error(String.format("Cannot load function '%s' from schema: this function won't be available (on this node)", name), (Throwable)e);
            return UDFunction.createBrokenFunction(name, argNames, argTypes, abstractType, calledOnNullInput, language, body, e);
        }
    }

    private static Functions fetchUDAs(String keyspaceName, Functions udfs, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", AGGREGATES);
        Functions.Builder aggregates = org.apache.cassandra.schema.Functions.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            aggregates.add((Function)SchemaKeyspace.createUDAFromRow(row, udfs, types));
        }
        return aggregates.build();
    }

    private static UDAggregate createUDAFromRow(UntypedResultSet.Row row, Functions functions, Types types) {
        String ksName = row.getString("keyspace_name");
        String functionName = row.getString("aggregate_name");
        FunctionName name = new FunctionName(ksName, functionName);
        List<AbstractType<?>> argTypes = row.getFrozenList("argument_types", UTF8Type.instance).stream().map(t -> CQLTypeParser.parse(ksName, t, types)).collect(Collectors.toList());
        AbstractType<?> returnType = CQLTypeParser.parse(ksName, row.getString("return_type"), types);
        FunctionName stateFunc = new FunctionName(ksName, row.getString("state_func"));
        FunctionName finalFunc = row.has("final_func") ? new FunctionName(ksName, row.getString("final_func")) : null;
        AbstractType<?> stateType = row.has("state_type") ? CQLTypeParser.parse(ksName, row.getString("state_type"), types) : null;
        ByteBuffer initcond = row.has("initcond") ? Terms.asBytes(ksName, row.getString("initcond"), stateType) : null;
        try {
            return UDAggregate.create(functions, name, argTypes, returnType, stateFunc, finalFunc, stateType, initcond);
        }
        catch (InvalidRequestException reason) {
            return UDAggregate.createBroken(name, argTypes, returnType, initcond, reason);
        }
    }

    private static UntypedResultSet query(String query, Object ... variables) {
        return QueryProcessor.executeInternal(query, variables);
    }

    public static synchronized void reloadSchemaAndAnnounceVersion() {
        Keyspaces before = Schema.instance.getReplicatedKeyspaces();
        Keyspaces after = SchemaKeyspace.fetchNonSystemKeyspaces();
        SchemaKeyspace.mergeSchema(before, after);
        Schema.instance.updateVersionAndAnnounce();
    }

    public static synchronized void mergeSchemaAndAnnounceVersion(Collection<Mutation> mutations) throws ConfigurationException {
        SchemaKeyspace.mergeSchema(mutations);
        Schema.instance.updateVersionAndAnnounce();
    }

    public static synchronized void mergeSchema(Collection<Mutation> mutations) {
        Set<String> affectedKeyspaces = mutations.stream().map(m -> (String)UTF8Type.instance.compose(m.key().getKey())).collect(Collectors.toSet());
        Keyspaces before = Schema.instance.getKeyspaces(affectedKeyspaces);
        mutations.forEach(Mutation::apply);
        if (FLUSH_SCHEMA_TABLES) {
            SchemaKeyspace.flush();
        }
        Keyspaces after = SchemaKeyspace.fetchKeyspacesOnly(affectedKeyspaces);
        SchemaKeyspace.mergeSchema(before, after);
    }

    private static synchronized void mergeSchema(Keyspaces before, Keyspaces after) {
        MapDifference<String, KeyspaceMetadata> keyspacesDiff = before.diff(after);
        for (KeyspaceMetadata keyspaceMetadata : keyspacesDiff.entriesOnlyOnLeft().values()) {
            keyspaceMetadata.functions.udas().forEach(Schema.instance::dropAggregate);
            keyspaceMetadata.functions.udfs().forEach(Schema.instance::dropFunction);
            keyspaceMetadata.views.forEach(v -> Schema.instance.dropView(v.ksName, v.viewName));
            keyspaceMetadata.tables.forEach(t -> Schema.instance.dropTable(t.ksName, t.cfName));
            keyspaceMetadata.types.forEach(Schema.instance::dropType);
            Schema.instance.dropKeyspace(keyspaceMetadata.name);
        }
        for (KeyspaceMetadata keyspaceMetadata : keyspacesDiff.entriesOnlyOnRight().values()) {
            Schema.instance.addKeyspace(KeyspaceMetadata.create(keyspaceMetadata.name, keyspaceMetadata.params));
            keyspaceMetadata.types.forEach(Schema.instance::addType);
            keyspaceMetadata.tables.forEach(Schema.instance::addTable);
            keyspaceMetadata.views.forEach(Schema.instance::addView);
            keyspaceMetadata.functions.udfs().forEach(Schema.instance::addFunction);
            keyspaceMetadata.functions.udas().forEach(Schema.instance::addAggregate);
        }
        for (Map.Entry entry : keyspacesDiff.entriesDiffering().entrySet()) {
            SchemaKeyspace.updateKeyspace((String)entry.getKey(), (KeyspaceMetadata)((MapDifference.ValueDifference)entry.getValue()).leftValue(), (KeyspaceMetadata)((MapDifference.ValueDifference)entry.getValue()).rightValue());
        }
    }

    private static void updateKeyspace(String keyspaceName, KeyspaceMetadata keyspaceBefore, KeyspaceMetadata keyspaceAfter) {
        MapDifference<String, CFMetaData> tablesDiff = keyspaceBefore.tables.diff(keyspaceAfter.tables);
        MapDifference<String, ViewDefinition> viewsDiff = keyspaceBefore.views.diff(keyspaceAfter.views);
        MapDifference<ByteBuffer, UserType> typesDiff = keyspaceBefore.types.diff(keyspaceAfter.types);
        HashMap udfsBefore = new HashMap();
        keyspaceBefore.functions.udfs().forEach(f -> udfsBefore.put(Pair.create(f.name(), SchemaKeyspace.functionArgumentsList(f)), f));
        HashMap udfsAfter = new HashMap();
        keyspaceAfter.functions.udfs().forEach(f -> udfsAfter.put(Pair.create(f.name(), SchemaKeyspace.functionArgumentsList(f)), f));
        MapDifference udfsDiff = Maps.difference(udfsBefore, udfsAfter);
        HashMap udasBefore = new HashMap();
        keyspaceBefore.functions.udas().forEach(f -> udasBefore.put(Pair.create(f.name(), SchemaKeyspace.functionArgumentsList(f)), f));
        HashMap udasAfter = new HashMap();
        keyspaceAfter.functions.udas().forEach(f -> udasAfter.put(Pair.create(f.name(), SchemaKeyspace.functionArgumentsList(f)), f));
        MapDifference udasDiff = Maps.difference(udasBefore, udasAfter);
        if (!keyspaceBefore.params.equals(keyspaceAfter.params)) {
            Schema.instance.updateKeyspace(keyspaceName, keyspaceAfter.params);
        }
        udasDiff.entriesOnlyOnLeft().values().forEach(Schema.instance::dropAggregate);
        udfsDiff.entriesOnlyOnLeft().values().forEach(Schema.instance::dropFunction);
        viewsDiff.entriesOnlyOnLeft().values().forEach(v -> Schema.instance.dropView(v.ksName, v.viewName));
        tablesDiff.entriesOnlyOnLeft().values().forEach(t -> Schema.instance.dropTable(t.ksName, t.cfName));
        typesDiff.entriesOnlyOnLeft().values().forEach(Schema.instance::dropType);
        typesDiff.entriesOnlyOnRight().values().forEach(Schema.instance::addType);
        tablesDiff.entriesOnlyOnRight().values().forEach(Schema.instance::addTable);
        viewsDiff.entriesOnlyOnRight().values().forEach(Schema.instance::addView);
        udfsDiff.entriesOnlyOnRight().values().forEach(Schema.instance::addFunction);
        udasDiff.entriesOnlyOnRight().values().forEach(Schema.instance::addAggregate);
        for (MapDifference.ValueDifference<UserType> valueDifference : typesDiff.entriesDiffering().values()) {
            Schema.instance.updateType(valueDifference.rightValue());
        }
        for (MapDifference.ValueDifference<Object> valueDifference : tablesDiff.entriesDiffering().values()) {
            Schema.instance.updateTable((CFMetaData)valueDifference.rightValue());
        }
        for (MapDifference.ValueDifference<Object> valueDifference : viewsDiff.entriesDiffering().values()) {
            Schema.instance.updateView((ViewDefinition)valueDifference.rightValue());
        }
        for (MapDifference.ValueDifference<Object> valueDifference : udfsDiff.entriesDiffering().values()) {
            Schema.instance.updateFunction((UDFunction)valueDifference.rightValue());
        }
        for (MapDifference.ValueDifference<Object> valueDifference : udasDiff.entriesDiffering().values()) {
            Schema.instance.updateAggregate((UDAggregate)valueDifference.rightValue());
        }
    }

    private static AbstractType<?> expandUserTypes(AbstractType<?> original) {
        if (original instanceof UserType) {
            return new TupleType(SchemaKeyspace.expandUserTypes(((UserType)original).fieldTypes()));
        }
        if (original instanceof TupleType) {
            return new TupleType(SchemaKeyspace.expandUserTypes(((TupleType)original).allTypes()));
        }
        if (original instanceof ListType) {
            return ListType.getInstance(SchemaKeyspace.expandUserTypes(((ListType)original).getElementsType()), original.isMultiCell());
        }
        if (original instanceof MapType) {
            MapType mt = (MapType)original;
            return MapType.getInstance(SchemaKeyspace.expandUserTypes(mt.getKeysType()), SchemaKeyspace.expandUserTypes(mt.getValuesType()), mt.isMultiCell());
        }
        if (original instanceof SetType) {
            return SetType.getInstance(SchemaKeyspace.expandUserTypes(((SetType)original).getElementsType()), original.isMultiCell());
        }
        if (original instanceof ReversedType) {
            return ReversedType.getInstance(SchemaKeyspace.expandUserTypes(((ReversedType)original).baseType));
        }
        if (original instanceof CompositeType) {
            return CompositeType.getInstance(SchemaKeyspace.expandUserTypes(original.getComponents()));
        }
        return original;
    }

    private static List<AbstractType<?>> expandUserTypes(List<AbstractType<?>> types) {
        return types.stream().map(SchemaKeyspace::expandUserTypes).collect(Collectors.toList());
    }

    private static class MissingColumns
    extends RuntimeException {
        MissingColumns(String message) {
            super(message);
        }
    }
}

