/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.UUID;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.ColumnConditions;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Conditions;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Operations;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.CQL3CasRequest;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.cql3.statements.StatementType;
import org.apache.cassandra.cql3.statements.UpdatesCollector;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.partitions.FilteredPartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.triggers.TriggerExecutor;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.ThriftValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModificationStatement
implements CQLStatement {
    protected static final Logger logger = LoggerFactory.getLogger(ModificationStatement.class);
    public static final String CUSTOM_EXPRESSIONS_NOT_ALLOWED = "Custom index expressions cannot be used in WHERE clauses for UPDATE or DELETE statements";
    private static final ColumnIdentifier CAS_RESULT_COLUMN = new ColumnIdentifier("[applied]", false);
    protected final StatementType type;
    private final int boundTerms;
    public final CFMetaData cfm;
    private final Attributes attrs;
    private final StatementRestrictions restrictions;
    private final Operations operations;
    private final PartitionColumns updatedColumns;
    private final Conditions conditions;
    private final PartitionColumns conditionColumns;
    private final PartitionColumns requiresRead;

    public ModificationStatement(StatementType type, int boundTerms, CFMetaData cfm, Operations operations, StatementRestrictions restrictions, Conditions conditions, Attributes attrs) {
        this.type = type;
        this.boundTerms = boundTerms;
        this.cfm = cfm;
        this.restrictions = restrictions;
        this.operations = operations;
        this.conditions = conditions;
        this.attrs = attrs;
        if (!conditions.isEmpty()) {
            RequestValidations.checkFalse(cfm.isCounter(), "Conditional updates are not supported on counter tables");
            RequestValidations.checkFalse(attrs.isTimestampSet(), "Cannot provide custom timestamp for conditional updates");
        }
        PartitionColumns.Builder conditionColumnsBuilder = PartitionColumns.builder();
        Iterable<ColumnDefinition> columns = conditions.getColumns();
        if (columns != null) {
            conditionColumnsBuilder.addAll(columns);
        }
        PartitionColumns.Builder updatedColumnsBuilder = PartitionColumns.builder();
        PartitionColumns.Builder requiresReadBuilder = PartitionColumns.builder();
        for (Operation operation : operations) {
            updatedColumnsBuilder.add(operation.column);
            if (!operation.requiresRead()) continue;
            conditionColumnsBuilder.add(operation.column);
            requiresReadBuilder.add(operation.column);
        }
        PartitionColumns modifiedColumns = updatedColumnsBuilder.build();
        if (cfm.isCompactTable() && modifiedColumns.isEmpty() && this.updatesRegularRows()) {
            modifiedColumns = cfm.partitionColumns();
        }
        this.updatedColumns = modifiedColumns;
        this.conditionColumns = conditionColumnsBuilder.build();
        this.requiresRead = requiresReadBuilder.build();
    }

    @Override
    public Iterable<Function> getFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        this.addFunctionsTo(functions);
        return functions;
    }

    public void addFunctionsTo(List<Function> functions) {
        this.attrs.addFunctionsTo(functions);
        this.restrictions.addFunctionsTo(functions);
        this.operations.addFunctionsTo(functions);
        this.conditions.addFunctionsTo(functions);
    }

    public StatementRestrictions getRestrictions() {
        return this.restrictions;
    }

    public abstract void addUpdateForKey(PartitionUpdate var1, Clustering var2, UpdateParameters var3);

    public abstract void addUpdateForKey(PartitionUpdate var1, Slice var2, UpdateParameters var3);

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    public boolean isCounter() {
        return this.cfm.isCounter();
    }

    public boolean isView() {
        return this.cfm.isView();
    }

    public long getTimestamp(long now, QueryOptions options) throws InvalidRequestException {
        return this.attrs.getTimestamp(now, options);
    }

    public boolean isTimestampSet() {
        return this.attrs.isTimestampSet();
    }

    public int getTimeToLive(QueryOptions options) throws InvalidRequestException {
        return this.attrs.getTimeToLive(options, this.cfm);
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        Iterator<ViewDefinition> views;
        state.hasColumnFamilyAccess(this.cfm, Permission.MODIFY);
        if (this.hasConditions()) {
            state.hasColumnFamilyAccess(this.cfm, Permission.SELECT);
        }
        if ((views = View.findAll(this.keyspace(), this.columnFamily()).iterator()).hasNext()) {
            state.hasColumnFamilyAccess(this.cfm, Permission.SELECT);
            do {
                state.hasColumnFamilyAccess(views.next().metadata, Permission.MODIFY);
            } while (views.hasNext());
        }
        for (Function function : this.getFunctions()) {
            state.ensureHasPermission(Permission.EXECUTE, function);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        RequestValidations.checkFalse(this.hasConditions() && this.attrs.isTimestampSet(), "Cannot provide custom timestamp for conditional updates");
        RequestValidations.checkFalse(this.isCounter() && this.attrs.isTimestampSet(), "Cannot provide custom timestamp for counter updates");
        RequestValidations.checkFalse(this.isCounter() && this.attrs.isTimeToLiveSet(), "Cannot provide custom TTL for counter updates");
        RequestValidations.checkFalse(this.isView(), "Cannot directly modify a materialized view");
    }

    public PartitionColumns updatedColumns() {
        return this.updatedColumns;
    }

    public PartitionColumns conditionColumns() {
        return this.conditionColumns;
    }

    public boolean updatesRegularRows() {
        return this.cfm.clusteringColumns().isEmpty() || this.restrictions.hasClusteringColumnsRestrictions();
    }

    public boolean updatesStaticRow() {
        return this.operations.appliesToStaticColumns();
    }

    public List<Operation> getRegularOperations() {
        return this.operations.regularOperations();
    }

    public List<Operation> getStaticOperations() {
        return this.operations.staticOperations();
    }

    public Iterable<Operation> allOperations() {
        return this.operations;
    }

    public Iterable<ColumnDefinition> getColumnsWithConditions() {
        return this.conditions.getColumns();
    }

    public boolean hasIfNotExistCondition() {
        return this.conditions.isIfNotExists();
    }

    public boolean hasIfExistCondition() {
        return this.conditions.isIfExists();
    }

    public List<ByteBuffer> buildPartitionKeyNames(QueryOptions options) throws InvalidRequestException {
        List<ByteBuffer> partitionKeys = this.restrictions.getPartitionKeys(options);
        for (ByteBuffer key : partitionKeys) {
            QueryProcessor.validateKey(key);
        }
        return partitionKeys;
    }

    public NavigableSet<Clustering> createClustering(QueryOptions options) throws InvalidRequestException {
        if (this.appliesOnlyToStaticColumns() && !this.restrictions.hasClusteringColumnsRestrictions()) {
            return FBUtilities.singleton(CBuilder.STATIC_BUILDER.build(), this.cfm.comparator);
        }
        return this.restrictions.getClusteringColumns(options);
    }

    private boolean appliesOnlyToStaticColumns() {
        return ModificationStatement.appliesOnlyToStaticColumns(this.operations, this.conditions);
    }

    public static boolean appliesOnlyToStaticColumns(Operations operation, Conditions conditions) {
        return !operation.appliesToRegularColumns() && !conditions.appliesToRegularColumns() && (operation.appliesToStaticColumns() || conditions.appliesToStaticColumns());
    }

    public boolean requiresRead() {
        for (Operation op : this.allOperations()) {
            if (!op.requiresRead()) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private Map<DecoratedKey, Partition> readRequiredLists(Collection<ByteBuffer> partitionKeys, ClusteringIndexFilter filter, DataLimits limits, boolean local, ConsistencyLevel cl, long queryStartNanoTime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<DecoratedKey, Partition> asMaterializedMap(PartitionIterator iterator) {
        HashMap<DecoratedKey, Partition> map = new HashMap<DecoratedKey, Partition>();
        while (iterator.hasNext()) {
            RowIterator partition = (RowIterator)iterator.next();
            Throwable throwable = null;
            try {
                map.put(partition.partitionKey(), FilteredPartition.create(partition));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
        return map;
    }

    public boolean hasConditions() {
        return !this.conditions.isEmpty();
    }

    public boolean hasSlices() {
        return this.type.allowClusteringColumnSlices() && this.getRestrictions().hasClusteringColumnsRestrictions() && this.getRestrictions().isColumnRange();
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        return this.hasConditions() ? this.executeWithCondition(queryState, options, queryStartNanoTime) : this.executeWithoutCondition(queryState, options, queryStartNanoTime);
    }

    private ResultMessage executeWithoutCondition(QueryState queryState, QueryOptions options, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        ConsistencyLevel cl = options.getConsistency();
        if (this.isCounter()) {
            cl.validateCounterForWrite(this.cfm);
        } else {
            cl.validateForWrite(this.cfm.ksName);
        }
        Collection<? extends IMutation> mutations = this.getMutations(options, false, options.getTimestamp(queryState), queryStartNanoTime);
        if (!mutations.isEmpty()) {
            StorageProxy.mutateWithTriggers(mutations, cl, false, queryStartNanoTime);
        }
        return null;
    }

    public ResultMessage executeWithCondition(QueryState queryState, QueryOptions options, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        CQL3CasRequest request = this.makeCasRequest(queryState, options);
        try (RowIterator result = StorageProxy.cas(this.keyspace(), this.columnFamily(), request.key, request, options.getSerialConsistency(), options.getConsistency(), queryState.getClientState(), queryStartNanoTime);){
            ResultMessage.Rows rows = new ResultMessage.Rows(this.buildCasResultSet(result, options));
            return rows;
        }
    }

    private CQL3CasRequest makeCasRequest(QueryState queryState, QueryOptions options) {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(options);
        RequestValidations.checkFalse(this.restrictions.keyIsInRelation(), "IN on the partition key is not supported with conditional %s", this.type.isUpdate() ? "updates" : "deletions");
        DecoratedKey key = this.cfm.decorateKey(keys.get(0));
        long now = options.getTimestamp(queryState);
        RequestValidations.checkFalse(this.restrictions.clusteringKeyRestrictionsHasIN(), "IN on the clustering key columns is not supported with conditional %s", this.type.isUpdate() ? "updates" : "deletions");
        Clustering clustering = Iterables.getOnlyElement(this.createClustering(options));
        CQL3CasRequest request = new CQL3CasRequest(this.cfm, key, false, this.conditionColumns(), this.updatesRegularRows(), this.updatesStaticRow());
        this.addConditions(clustering, request, options);
        request.addRowUpdate(clustering, this, options, now);
        return request;
    }

    public void addConditions(Clustering clustering, CQL3CasRequest request, QueryOptions options) throws InvalidRequestException {
        this.conditions.addConditionsTo(request, clustering, options);
    }

    private ResultSet buildCasResultSet(RowIterator partition, QueryOptions options) throws InvalidRequestException {
        return ModificationStatement.buildCasResultSet(this.keyspace(), this.columnFamily(), partition, this.getColumnsWithConditions(), false, options);
    }

    public static ResultSet buildCasResultSet(String ksName, String tableName, RowIterator partition, Iterable<ColumnDefinition> columnsWithConditions, boolean isBatch, QueryOptions options) throws InvalidRequestException {
        boolean success = partition == null;
        ColumnSpecification spec = new ColumnSpecification(ksName, tableName, CAS_RESULT_COLUMN, BooleanType.instance);
        ResultSet.ResultMetadata metadata = new ResultSet.ResultMetadata(Collections.singletonList(spec));
        List<List<ByteBuffer>> rows = Collections.singletonList(Collections.singletonList(BooleanType.instance.decompose(success)));
        ResultSet rs = new ResultSet(metadata, rows);
        return success ? rs : ModificationStatement.merge(rs, ModificationStatement.buildCasFailureResultSet(partition, columnsWithConditions, isBatch, options));
    }

    private static ResultSet merge(ResultSet left, ResultSet right) {
        if (left.size() == 0) {
            return right;
        }
        if (right.size() == 0) {
            return left;
        }
        assert (left.size() == 1);
        int size = left.metadata.names.size() + right.metadata.names.size();
        ArrayList<ColumnSpecification> specs = new ArrayList<ColumnSpecification>(size);
        specs.addAll(left.metadata.names);
        specs.addAll(right.metadata.names);
        ArrayList<List<ByteBuffer>> rows = new ArrayList<List<ByteBuffer>>(right.size());
        for (int i = 0; i < right.size(); ++i) {
            ArrayList row = new ArrayList(size);
            row.addAll(left.rows.get(0));
            row.addAll(right.rows.get(i));
            rows.add(row);
        }
        return new ResultSet(new ResultSet.ResultMetadata(specs), rows);
    }

    private static ResultSet buildCasFailureResultSet(RowIterator partition, Iterable<ColumnDefinition> columnsWithConditions, boolean isBatch, QueryOptions options) throws InvalidRequestException {
        Selection selection;
        CFMetaData cfm = partition.metadata();
        if (columnsWithConditions == null) {
            selection = Selection.wildcard(cfm);
        } else {
            LinkedHashSet<ColumnDefinition> defs = new LinkedHashSet<ColumnDefinition>();
            if (isBatch) {
                defs.addAll(cfm.partitionKeyColumns());
                defs.addAll(cfm.clusteringColumns());
            }
            if (cfm.isSuper() && cfm.isDense()) {
                defs.add(cfm.superColumnValueColumn());
            } else {
                for (ColumnDefinition def : columnsWithConditions) {
                    defs.add(def);
                }
            }
            selection = Selection.forColumns(cfm, new ArrayList<ColumnDefinition>(defs));
        }
        Selection.ResultSetBuilder builder = selection.resultSetBuilder(options, false);
        SelectStatement.forSelection(cfm, selection).processPartition(partition, options, builder, FBUtilities.nowInSeconds());
        return builder.build();
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        return this.hasConditions() ? this.executeInternalWithCondition(queryState, options) : this.executeInternalWithoutCondition(queryState, options, System.nanoTime());
    }

    public ResultMessage executeInternalWithoutCondition(QueryState queryState, QueryOptions options, long queryStartNanoTime) throws RequestValidationException, RequestExecutionException {
        for (IMutation iMutation : this.getMutations(options, true, queryState.getTimestamp(), queryStartNanoTime)) {
            iMutation.apply();
        }
        return null;
    }

    public ResultMessage executeInternalWithCondition(QueryState state, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        CQL3CasRequest request = this.makeCasRequest(state, options);
        try (RowIterator result = ModificationStatement.casInternal(request, state);){
            ResultMessage.Rows rows = new ResultMessage.Rows(this.buildCasResultSet(result, options));
            return rows;
        }
    }

    static RowIterator casInternal(CQL3CasRequest request, QueryState state) {
        FilteredPartition current;
        UUID ballot = UUIDGen.getTimeUUIDFromMicros(state.getTimestamp());
        SinglePartitionReadCommand readCommand = request.readCommand(FBUtilities.nowInSeconds());
        try (ReadExecutionController executionController = readCommand.executionController();
             PartitionIterator iter = readCommand.executeInternal(executionController);){
            current = FilteredPartition.create(PartitionIterators.getOnlyElement(iter, readCommand));
        }
        if (!request.appliesTo(current)) {
            return current.rowIterator();
        }
        PartitionUpdate updates = request.makeUpdates(current);
        updates = TriggerExecutor.instance.execute(updates);
        Commit proposal = Commit.newProposal(ballot, updates);
        proposal.makeMutation().apply();
        return null;
    }

    private Collection<? extends IMutation> getMutations(QueryOptions options, boolean local, long now, long queryStartNanoTime) {
        UpdatesCollector collector = new UpdatesCollector(Collections.singletonMap(this.cfm.cfId, this.updatedColumns), 1);
        this.addUpdates(collector, options, local, now, queryStartNanoTime);
        collector.validateIndexedColumns();
        return collector.toMutations();
    }

    final void addUpdates(UpdatesCollector collector, QueryOptions options, boolean local, long now, long queryStartNanoTime) {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(options);
        if (this.hasSlices()) {
            Slices slices = this.createSlices(options);
            if (slices.isEmpty()) {
                return;
            }
            UpdateParameters params = this.makeUpdateParameters(keys, new ClusteringIndexSliceFilter(slices, false), options, DataLimits.NONE, local, now, queryStartNanoTime);
            for (ByteBuffer key : keys) {
                ThriftValidation.validateKey(this.cfm, key);
                DecoratedKey dk = this.cfm.decorateKey(key);
                PartitionUpdate upd = collector.getPartitionUpdate(this.cfm, dk, options.getConsistency());
                for (Slice slice : slices) {
                    this.addUpdateForKey(upd, slice, params);
                }
            }
        } else {
            NavigableSet<Clustering> clusterings = this.createClustering(options);
            if (this.restrictions.hasClusteringColumnsRestrictions() && clusterings.isEmpty()) {
                return;
            }
            UpdateParameters params = this.makeUpdateParameters(keys, clusterings, options, local, now, queryStartNanoTime);
            for (ByteBuffer key : keys) {
                ThriftValidation.validateKey(this.cfm, key);
                DecoratedKey dk = this.cfm.decorateKey(key);
                PartitionUpdate upd = collector.getPartitionUpdate(this.cfm, dk, options.getConsistency());
                if (!this.restrictions.hasClusteringColumnsRestrictions()) {
                    this.addUpdateForKey(upd, Clustering.EMPTY, params);
                    continue;
                }
                for (Clustering clustering : clusterings) {
                    for (ByteBuffer c : clustering.getRawValues()) {
                        if (c == null || c.remaining() <= 65535) continue;
                        throw new InvalidRequestException(String.format("Key length of %d is longer than maximum of %d", clustering.dataSize(), 65535));
                    }
                    this.addUpdateForKey(upd, clustering, params);
                }
            }
        }
    }

    Slices createSlices(QueryOptions options) {
        NavigableSet<ClusteringBound> startBounds = this.restrictions.getClusteringColumnsBounds(Bound.START, options);
        NavigableSet<ClusteringBound> endBounds = this.restrictions.getClusteringColumnsBounds(Bound.END, options);
        return this.toSlices(startBounds, endBounds);
    }

    private UpdateParameters makeUpdateParameters(Collection<ByteBuffer> keys, NavigableSet<Clustering> clusterings, QueryOptions options, boolean local, long now, long queryStartNanoTime) {
        if (clusterings.contains(Clustering.STATIC_CLUSTERING)) {
            return this.makeUpdateParameters(keys, new ClusteringIndexSliceFilter(Slices.ALL, false), options, DataLimits.cqlLimits(1), local, now, queryStartNanoTime);
        }
        return this.makeUpdateParameters(keys, new ClusteringIndexNamesFilter(clusterings, false), options, DataLimits.NONE, local, now, queryStartNanoTime);
    }

    private UpdateParameters makeUpdateParameters(Collection<ByteBuffer> keys, ClusteringIndexFilter filter, QueryOptions options, DataLimits limits, boolean local, long now, long queryStartNanoTime) {
        Map<DecoratedKey, Partition> lists = this.readRequiredLists(keys, filter, limits, local, options.getConsistency(), queryStartNanoTime);
        return new UpdateParameters(this.cfm, this.updatedColumns(), options, this.getTimestamp(now, options), this.getTimeToLive(options), lists);
    }

    private Slices toSlices(SortedSet<ClusteringBound> startBounds, SortedSet<ClusteringBound> endBounds) {
        assert (startBounds.size() == endBounds.size());
        Slices.Builder builder = new Slices.Builder(this.cfm.comparator);
        Iterator starts = startBounds.iterator();
        Iterator ends = endBounds.iterator();
        while (starts.hasNext()) {
            Slice slice = Slice.make((ClusteringBound)starts.next(), (ClusteringBound)ends.next());
            if (slice.isEmpty(this.cfm.comparator)) continue;
            builder.add(slice);
        }
        return builder.build();
    }

    public static abstract class Parsed
    extends CFStatement {
        protected final StatementType type;
        private final Attributes.Raw attrs;
        private final List<Pair<ColumnDefinition.Raw, ColumnCondition.Raw>> conditions;
        private final boolean ifNotExists;
        private final boolean ifExists;

        protected Parsed(CFName name, StatementType type, Attributes.Raw attrs, List<Pair<ColumnDefinition.Raw, ColumnCondition.Raw>> conditions, boolean ifNotExists, boolean ifExists) {
            super(name);
            this.type = type;
            this.attrs = attrs;
            this.conditions = conditions == null ? Collections.emptyList() : conditions;
            this.ifNotExists = ifNotExists;
            this.ifExists = ifExists;
        }

        @Override
        public ParsedStatement.Prepared prepare(ClientState clientState) {
            VariableSpecifications boundNames = this.getBoundVariables();
            ModificationStatement statement = this.prepare(boundNames, clientState);
            return new ParsedStatement.Prepared((CQLStatement)statement, boundNames, boundNames.getPartitionKeyBindIndexes(statement.cfm));
        }

        public ModificationStatement prepare(VariableSpecifications boundNames, ClientState clientState) {
            CFMetaData metadata = ThriftValidation.validateColumnFamilyWithCompactMode(this.keyspace(), this.columnFamily(), clientState.isNoCompactMode());
            Attributes preparedAttributes = this.attrs.prepare(this.keyspace(), this.columnFamily());
            preparedAttributes.collectMarkerSpecification(boundNames);
            Conditions preparedConditions = this.prepareConditions(metadata, boundNames);
            return this.prepareInternal(metadata, boundNames, preparedConditions, preparedAttributes);
        }

        private Conditions prepareConditions(CFMetaData metadata, VariableSpecifications boundNames) {
            if (this.ifExists) {
                assert (this.conditions.isEmpty());
                assert (!this.ifNotExists);
                return Conditions.IF_EXISTS_CONDITION;
            }
            if (this.ifNotExists) {
                assert (this.conditions.isEmpty());
                assert (!this.ifExists);
                return Conditions.IF_NOT_EXISTS_CONDITION;
            }
            if (this.conditions.isEmpty()) {
                return Conditions.EMPTY_CONDITION;
            }
            return this.prepareColumnConditions(metadata, boundNames);
        }

        private ColumnConditions prepareColumnConditions(CFMetaData metadata, VariableSpecifications boundNames) {
            RequestValidations.checkNull(this.attrs.timestamp, "Cannot provide custom timestamp for conditional updates");
            ColumnConditions.Builder builder = ColumnConditions.newBuilder();
            for (Pair<ColumnDefinition.Raw, ColumnCondition.Raw> entry : this.conditions) {
                ColumnDefinition def = ((ColumnDefinition.Raw)entry.left).prepare(metadata);
                ColumnCondition condition = ((ColumnCondition.Raw)entry.right).prepare(this.keyspace(), def, metadata);
                condition.collectMarkerSpecification(boundNames);
                RequestValidations.checkFalse(def.isPrimaryKeyColumn(), "PRIMARY KEY column '%s' cannot have IF conditions", def.name);
                builder.add(condition);
            }
            return builder.build();
        }

        protected abstract ModificationStatement prepareInternal(CFMetaData var1, VariableSpecifications var2, Conditions var3, Attributes var4);

        protected StatementRestrictions newRestrictions(CFMetaData cfm, VariableSpecifications boundNames, Operations operations, WhereClause where, Conditions conditions) {
            if (where.containsCustomExpressions()) {
                throw new InvalidRequestException(ModificationStatement.CUSTOM_EXPRESSIONS_NOT_ALLOWED);
            }
            boolean applyOnlyToStaticColumns = ModificationStatement.appliesOnlyToStaticColumns(operations, conditions);
            return new StatementRestrictions(this.type, cfm, where, boundNames, applyOnlyToStaticColumns, false, false, false);
        }

        protected static ColumnDefinition getColumnDefinition(CFMetaData cfm, ColumnDefinition.Raw rawId) {
            return rawId.prepare(cfm);
        }
    }
}

