/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.AggregateFunctionSelector;
import org.apache.cassandra.cql3.selection.ScalarFunctionSelector;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.commons.lang3.text.StrBuilder;

abstract class AbstractFunctionSelector<T extends Function>
extends Selector {
    protected final T fun;
    private final List<ByteBuffer> args;
    protected final List<Selector> argSelectors;

    public static Selector.Factory newFactory(final Function fun, final SelectorFactories factories) throws InvalidRequestException {
        if (fun.isAggregate() && factories.doesAggregation()) {
            throw new InvalidRequestException("aggregate functions cannot be used as arguments of aggregate functions");
        }
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return fun.columnName(factories.getColumnNames());
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return fun.returnType();
            }

            @Override
            protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
                SelectionColumnMapping tmpMapping = SelectionColumnMapping.newMapping();
                for (Selector.Factory factory : factories) {
                    factory.addColumnMapping(tmpMapping, resultsColumn);
                }
                if (tmpMapping.getMappings().get(resultsColumn).isEmpty()) {
                    mapping.addMapping(resultsColumn, (ColumnDefinition)null);
                } else {
                    mapping.addMapping(resultsColumn, tmpMapping.getMappings().values());
                }
            }

            @Override
            public void addFunctionsTo(List<Function> functions) {
                fun.addFunctionsTo(functions);
                factories.addFunctionsTo(functions);
            }

            @Override
            public Selector newInstance(QueryOptions options) throws InvalidRequestException {
                return fun.isAggregate() ? new AggregateFunctionSelector(fun, factories.newInstances(options)) : new ScalarFunctionSelector(fun, factories.newInstances(options));
            }

            @Override
            public boolean isWritetimeSelectorFactory() {
                return factories.containsWritetimeSelectorFactory();
            }

            @Override
            public boolean isTTLSelectorFactory() {
                return factories.containsTTLSelectorFactory();
            }

            @Override
            public boolean isAggregateSelectorFactory() {
                return fun.isAggregate() || factories.doesAggregation();
            }
        };
    }

    protected AbstractFunctionSelector(T fun, List<Selector> argSelectors) {
        this.fun = fun;
        this.argSelectors = argSelectors;
        this.args = Arrays.asList(new ByteBuffer[argSelectors.size()]);
    }

    protected void setArg(int i, ByteBuffer value) throws InvalidRequestException {
        RequestValidations.checkBindValueSet(value, "Invalid unset value for argument in call to function %s", this.fun.name().name);
        this.args.set(i, value);
    }

    protected List<ByteBuffer> args() {
        return this.args;
    }

    @Override
    public AbstractType<?> getType() {
        return this.fun.returnType();
    }

    public String toString() {
        return new StrBuilder().append((Object)this.fun.name()).append("(").appendWithSeparators(this.argSelectors, ", ").append(")").toString();
    }
}

