/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.restrictions.PartitionKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.RestrictionSet;
import org.apache.cassandra.cql3.restrictions.RestrictionSetWrapper;
import org.apache.cassandra.cql3.restrictions.SingleRestriction;
import org.apache.cassandra.cql3.restrictions.TokenFilter;
import org.apache.cassandra.cql3.restrictions.TokenRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.MultiCBuilder;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.index.SecondaryIndexManager;

final class PartitionKeySingleRestrictionSet
extends RestrictionSetWrapper
implements PartitionKeyRestrictions {
    protected final ClusteringComparator comparator;

    public PartitionKeySingleRestrictionSet(ClusteringComparator comparator) {
        super(new RestrictionSet());
        this.comparator = comparator;
    }

    private PartitionKeySingleRestrictionSet(PartitionKeySingleRestrictionSet restrictionSet, SingleRestriction restriction) {
        super(restrictionSet.restrictions.addRestriction(restriction));
        this.comparator = restrictionSet.comparator;
    }

    private List<ByteBuffer> toByteBuffers(SortedSet<? extends ClusteringPrefix> clusterings) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>(clusterings.size());
        for (ClusteringPrefix clusteringPrefix : clusterings) {
            l.add(CFMetaData.serializePartitionKey(clusteringPrefix));
        }
        return l;
    }

    @Override
    public PartitionKeyRestrictions mergeWith(Restriction restriction) {
        if (restriction.isOnToken()) {
            if (this.isEmpty()) {
                return (PartitionKeyRestrictions)restriction;
            }
            return new TokenFilter(this, (TokenRestriction)restriction);
        }
        return new PartitionKeySingleRestrictionSet(this, (SingleRestriction)restriction);
    }

    @Override
    public List<ByteBuffer> values(QueryOptions options) {
        MultiCBuilder builder = MultiCBuilder.create(this.comparator, this.hasIN());
        for (SingleRestriction r : this.restrictions) {
            r.appendTo(builder, options);
            if (!builder.hasMissingElements()) continue;
            break;
        }
        return this.toByteBuffers(builder.build());
    }

    @Override
    public List<ByteBuffer> bounds(Bound bound, QueryOptions options) {
        MultiCBuilder builder = MultiCBuilder.create(this.comparator, this.hasIN());
        for (SingleRestriction r : this.restrictions) {
            r.appendBoundTo(builder, bound, options);
            if (!builder.hasMissingElements()) continue;
            return Collections.emptyList();
        }
        return this.toByteBuffers(builder.buildBound(bound.isStart(), true));
    }

    @Override
    public boolean hasBound(Bound b) {
        if (this.isEmpty()) {
            return false;
        }
        return this.restrictions.lastRestriction().hasBound(b);
    }

    @Override
    public boolean isInclusive(Bound b) {
        if (this.isEmpty()) {
            return false;
        }
        return this.restrictions.lastRestriction().isInclusive(b);
    }

    @Override
    public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) {
        for (SingleRestriction restriction : this.restrictions) {
            restriction.addRowFilterTo(filter, indexManager, options);
        }
    }

    @Override
    public boolean needFiltering(CFMetaData cfm) {
        if (this.isEmpty()) {
            return false;
        }
        return this.hasUnrestrictedPartitionKeyComponents(cfm) || this.hasSlice() || this.hasContains();
    }

    @Override
    public boolean hasUnrestrictedPartitionKeyComponents(CFMetaData cfm) {
        return this.size() < cfm.partitionKeyColumns().size();
    }

    @Override
    public boolean hasSlice() {
        for (SingleRestriction restriction : this.restrictions) {
            if (!restriction.isSlice()) continue;
            return true;
        }
        return false;
    }
}

