/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.TurboFilterList;
import ch.qos.logback.classic.turbo.ReconfigureOnChangeFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.cassandra.cql3.functions.SecurityThreadGroup;
import org.cassandraunit.shaded.io.netty.util.concurrent.FastThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadAwareSecurityManager
extends SecurityManager {
    static final PermissionCollection noPermissions = new PermissionCollection(){

        @Override
        public void add(Permission permission) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean implies(Permission permission) {
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.emptyEnumeration();
        }
    };
    private static final RuntimePermission CHECK_MEMBER_ACCESS_PERMISSION = new RuntimePermission("accessDeclaredMembers");
    private static final RuntimePermission MODIFY_THREAD_PERMISSION = new RuntimePermission("modifyThread");
    private static final RuntimePermission MODIFY_THREADGROUP_PERMISSION = new RuntimePermission("modifyThreadGroup");
    private static volatile boolean installed;
    private static final FastThreadLocal<Boolean> initializedThread;

    public static void install() {
        if (installed) {
            return;
        }
        System.setSecurityManager(new ThreadAwareSecurityManager());
        Logger l = LoggerFactory.getLogger(ThreadAwareSecurityManager.class);
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)l;
        LoggerContext ctx = logbackLogger.getLoggerContext();
        TurboFilterList turboFilterList = ctx.getTurboFilterList();
        for (int i = 0; i < turboFilterList.size(); ++i) {
            TurboFilter turboFilter = (TurboFilter)turboFilterList.get(i);
            if (!(turboFilter instanceof ReconfigureOnChangeFilter)) continue;
            ReconfigureOnChangeFilter reconfigureOnChangeFilter = (ReconfigureOnChangeFilter)turboFilter;
            turboFilterList.set(i, (Object)new SMAwareReconfigureOnChangeFilter(reconfigureOnChangeFilter));
            break;
        }
        installed = true;
    }

    private ThreadAwareSecurityManager() {
    }

    private static boolean isSecuredThread() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        if (!(tg instanceof SecurityThreadGroup)) {
            return false;
        }
        Boolean threadInitialized = initializedThread.get();
        if (threadInitialized == null) {
            initializedThread.set(false);
            ((SecurityThreadGroup)tg).initializeThread();
            initializedThread.set(true);
            threadInitialized = true;
        }
        return threadInitialized;
    }

    @Override
    public void checkAccess(Thread t) {
        if (ThreadAwareSecurityManager.isSecuredThread()) {
            throw new AccessControlException("access denied: " + MODIFY_THREAD_PERMISSION, MODIFY_THREAD_PERMISSION);
        }
        super.checkAccess(t);
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (ThreadAwareSecurityManager.isSecuredThread()) {
            throw new AccessControlException("access denied: " + MODIFY_THREADGROUP_PERMISSION, MODIFY_THREADGROUP_PERMISSION);
        }
        super.checkAccess(g);
    }

    @Override
    public void checkPermission(Permission perm) {
        if (!ThreadAwareSecurityManager.isSecuredThread()) {
            return;
        }
        if (CHECK_MEMBER_ACCESS_PERMISSION.equals(perm)) {
            return;
        }
        super.checkPermission(perm);
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (ThreadAwareSecurityManager.isSecuredThread()) {
            super.checkPermission(perm, context);
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (!ThreadAwareSecurityManager.isSecuredThread()) {
            return;
        }
        if (!((SecurityThreadGroup)Thread.currentThread().getThreadGroup()).isPackageAllowed(pkg)) {
            RuntimePermission perm = new RuntimePermission("accessClassInPackage." + pkg);
            throw new AccessControlException("access denied: " + perm, perm);
        }
        super.checkPackageAccess(pkg);
    }

    static {
        Policy.setPolicy(new Policy(){

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                Permissions perms = new Permissions();
                if (codesource == null || codesource.getLocation() == null) {
                    return perms;
                }
                switch (codesource.getLocation().getProtocol()) {
                    case "file": {
                        perms.add(new AllPermission());
                        return perms;
                    }
                }
                return perms;
            }

            @Override
            public PermissionCollection getPermissions(ProtectionDomain domain) {
                return this.getPermissions(domain.getCodeSource());
            }

            @Override
            public boolean implies(ProtectionDomain domain, Permission permission) {
                CodeSource codesource = domain.getCodeSource();
                if (codesource == null || codesource.getLocation() == null) {
                    return false;
                }
                switch (codesource.getLocation().getProtocol()) {
                    case "file": {
                        return true;
                    }
                }
                return false;
            }
        });
        initializedThread = new FastThreadLocal();
    }

    private static class SMAwareReconfigureOnChangeFilter
    extends ReconfigureOnChangeFilter {
        SMAwareReconfigureOnChangeFilter(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
            this.setRefreshPeriod(reconfigureOnChangeFilter.getRefreshPeriod());
            this.setName(reconfigureOnChangeFilter.getName());
            this.setContext(reconfigureOnChangeFilter.getContext());
            if (reconfigureOnChangeFilter.isStarted()) {
                reconfigureOnChangeFilter.stop();
                this.start();
            }
        }

        protected boolean changeDetected(long now) {
            if (ThreadAwareSecurityManager.isSecuredThread()) {
                return false;
            }
            return super.changeDetected(now);
        }
    }
}

