/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.lang.management.ManagementFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.auth.AuthCacheMBean;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.cassandraunit.shaded.com.google.common.cache.CacheBuilder;
import org.cassandraunit.shaded.com.google.common.cache.CacheLoader;
import org.cassandraunit.shaded.com.google.common.cache.LoadingCache;
import org.cassandraunit.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.cassandraunit.shaded.com.google.common.util.concurrent.ListenableFutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthCache<K, V>
implements AuthCacheMBean {
    private static final Logger logger = LoggerFactory.getLogger(AuthCache.class);
    private static final String MBEAN_NAME_BASE = "org.apache.cassandra.auth:type=";
    private volatile LoadingCache<K, V> cache;
    private ThreadPoolExecutor cacheRefreshExecutor;
    private final String name;
    private final Consumer<Integer> setValidityDelegate;
    private final Supplier<Integer> getValidityDelegate;
    private final Consumer<Integer> setUpdateIntervalDelegate;
    private final Supplier<Integer> getUpdateIntervalDelegate;
    private final Consumer<Integer> setMaxEntriesDelegate;
    private final Supplier<Integer> getMaxEntriesDelegate;
    private final Function<K, V> loadFunction;
    private final Supplier<Boolean> enableCache;

    protected AuthCache(String name, Consumer<Integer> setValidityDelegate, Supplier<Integer> getValidityDelegate, Consumer<Integer> setUpdateIntervalDelegate, Supplier<Integer> getUpdateIntervalDelegate, Consumer<Integer> setMaxEntriesDelegate, Supplier<Integer> getMaxEntriesDelegate, Function<K, V> loadFunction, Supplier<Boolean> enableCache) {
        this.name = name;
        this.setValidityDelegate = setValidityDelegate;
        this.getValidityDelegate = getValidityDelegate;
        this.setUpdateIntervalDelegate = setUpdateIntervalDelegate;
        this.getUpdateIntervalDelegate = getUpdateIntervalDelegate;
        this.setMaxEntriesDelegate = setMaxEntriesDelegate;
        this.getMaxEntriesDelegate = getMaxEntriesDelegate;
        this.loadFunction = loadFunction;
        this.enableCache = enableCache;
        this.init();
    }

    protected void init() {
        this.cacheRefreshExecutor = new DebuggableThreadPoolExecutor(this.name + "Refresh", 5);
        this.cache = this.initCache(null);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, this.getObjectName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName(MBEAN_NAME_BASE + this.name);
    }

    public V get(K k) throws ExecutionException {
        if (this.cache == null) {
            return this.loadFunction.apply(k);
        }
        return this.cache.get(k);
    }

    @Override
    public void invalidate() {
        this.cache = this.initCache(null);
    }

    public void invalidate(K k) {
        if (this.cache != null) {
            this.cache.invalidate(k);
        }
    }

    @Override
    public void setValidity(int validityPeriod) {
        if (Boolean.getBoolean("cassandra.disable_auth_caches_remote_configuration")) {
            throw new UnsupportedOperationException("Remote configuration of auth caches is disabled");
        }
        this.setValidityDelegate.accept(validityPeriod);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getValidity() {
        return this.getValidityDelegate.get();
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        if (Boolean.getBoolean("cassandra.disable_auth_caches_remote_configuration")) {
            throw new UnsupportedOperationException("Remote configuration of auth caches is disabled");
        }
        this.setUpdateIntervalDelegate.accept(updateInterval);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getUpdateInterval() {
        return this.getUpdateIntervalDelegate.get();
    }

    @Override
    public void setMaxEntries(int maxEntries) {
        if (Boolean.getBoolean("cassandra.disable_auth_caches_remote_configuration")) {
            throw new UnsupportedOperationException("Remote configuration of auth caches is disabled");
        }
        this.setMaxEntriesDelegate.accept(maxEntries);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getMaxEntries() {
        return this.getMaxEntriesDelegate.get();
    }

    private LoadingCache<K, V> initCache(LoadingCache<K, V> existing) {
        if (!this.enableCache.get().booleanValue()) {
            return null;
        }
        if (this.getValidity() <= 0) {
            return null;
        }
        logger.info("(Re)initializing {} (validity period/update interval/max entries) ({}/{}/{})", new Object[]{this.name, this.getValidity(), this.getUpdateInterval(), this.getMaxEntries()});
        LoadingCache newcache = CacheBuilder.newBuilder().refreshAfterWrite(this.getUpdateInterval(), TimeUnit.MILLISECONDS).expireAfterWrite(this.getValidity(), TimeUnit.MILLISECONDS).maximumSize(this.getMaxEntries()).build(new CacheLoader<K, V>(){

            @Override
            public V load(K k) {
                return AuthCache.this.loadFunction.apply(k);
            }

            @Override
            public ListenableFuture<V> reload(K k, V oldV) {
                ListenableFutureTask<Object> task = ListenableFutureTask.create(() -> {
                    try {
                        return AuthCache.this.loadFunction.apply(k);
                    }
                    catch (Exception e) {
                        logger.trace("Error performing async refresh of auth data in {}", (Object)AuthCache.this.name, (Object)e);
                        throw e;
                    }
                });
                AuthCache.this.cacheRefreshExecutor.execute(task);
                return task;
            }
        });
        if (existing != null) {
            newcache.putAll(existing.asMap());
        }
        return newcache;
    }
}

