/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.org.apache.cassandra.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.ColumnOrSuperColumn;

public class KeySlice
implements TBase<KeySlice, _Fields>,
Serializable,
Cloneable,
Comparable<KeySlice> {
    private static final TStruct STRUCT_DESC = new TStruct("KeySlice");
    private static final TField KEY_FIELD_DESC = new TField("key", 11, 1);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer key;
    public List<ColumnOrSuperColumn> columns;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public KeySlice() {
    }

    public KeySlice(ByteBuffer key, List<ColumnOrSuperColumn> columns) {
        this();
        this.key = key;
        this.columns = columns;
    }

    public KeySlice(KeySlice other) {
        if (other.isSetKey()) {
            this.key = TBaseHelper.copyBinary((ByteBuffer)other.key);
        }
        if (other.isSetColumns()) {
            ArrayList<ColumnOrSuperColumn> __this__columns = new ArrayList<ColumnOrSuperColumn>(other.columns.size());
            for (ColumnOrSuperColumn other_element : other.columns) {
                __this__columns.add(new ColumnOrSuperColumn(other_element));
            }
            this.columns = __this__columns;
        }
    }

    public KeySlice deepCopy() {
        return new KeySlice(this);
    }

    public void clear() {
        this.key = null;
        this.columns = null;
    }

    public byte[] getKey() {
        this.setKey(TBaseHelper.rightSize((ByteBuffer)this.key));
        return this.key == null ? null : this.key.array();
    }

    public ByteBuffer bufferForKey() {
        return this.key;
    }

    public KeySlice setKey(byte[] key) {
        this.setKey(key == null ? (ByteBuffer)null : ByteBuffer.wrap(key));
        return this;
    }

    public KeySlice setKey(ByteBuffer key) {
        this.key = key;
        return this;
    }

    public void unsetKey() {
        this.key = null;
    }

    public boolean isSetKey() {
        return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
        if (!value) {
            this.key = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public Iterator<ColumnOrSuperColumn> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(ColumnOrSuperColumn elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnOrSuperColumn>();
        }
        this.columns.add(elem);
    }

    public List<ColumnOrSuperColumn> getColumns() {
        return this.columns;
    }

    public KeySlice setColumns(List<ColumnOrSuperColumn> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case KEY: {
                if (value == null) {
                    this.unsetKey();
                    break;
                }
                this.setKey((ByteBuffer)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case KEY: {
                return this.getKey();
            }
            case COLUMNS: {
                return this.getColumns();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case KEY: {
                return this.isSetKey();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof KeySlice) {
            return this.equals((KeySlice)that);
        }
        return false;
    }

    public boolean equals(KeySlice that) {
        if (that == null) {
            return false;
        }
        boolean this_present_key = this.isSetKey();
        boolean that_present_key = that.isSetKey();
        if (this_present_key || that_present_key) {
            if (!this_present_key || !that_present_key) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!this.columns.equals(that.columns)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_key = this.isSetKey();
        builder.append(present_key);
        if (present_key) {
            builder.append((Object)this.key);
        }
        boolean present_columns = this.isSetColumns();
        builder.append(present_columns);
        if (present_columns) {
            builder.append(this.columns);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(KeySlice other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(other.isSetKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey() && (lastComparison = TBaseHelper.compareTo((Comparable)this.key, (Comparable)other.key)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(other.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, other.columns)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KeySlice(");
        boolean first = true;
        sb.append("key:");
        if (this.key == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.key, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.key == null) {
            throw new TProtocolException("Required field 'key' was not present! Struct: " + this.toString());
        }
        if (this.columns == null) {
            throw new TProtocolException("Required field 'columns' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new KeySliceStandardSchemeFactory());
        schemes.put(TupleScheme.class, new KeySliceTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.KEY, new FieldMetaData("key", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ColumnOrSuperColumn.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(KeySlice.class, metaDataMap);
    }

    private static class KeySliceTupleScheme
    extends TupleScheme<KeySlice> {
        private KeySliceTupleScheme() {
        }

        public void write(TProtocol prot, KeySlice struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeBinary(struct.key);
            oprot.writeI32(struct.columns.size());
            for (ColumnOrSuperColumn _iter44 : struct.columns) {
                _iter44.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, KeySlice struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.key = iprot.readBinary();
            struct.setKeyIsSet(true);
            TList _list45 = new TList(12, iprot.readI32());
            struct.columns = new ArrayList<ColumnOrSuperColumn>(_list45.size);
            for (int _i46 = 0; _i46 < _list45.size; ++_i46) {
                ColumnOrSuperColumn _elem47 = new ColumnOrSuperColumn();
                _elem47.read((TProtocol)iprot);
                struct.columns.add(_elem47);
            }
            struct.setColumnsIsSet(true);
        }
    }

    private static class KeySliceTupleSchemeFactory
    implements SchemeFactory {
        private KeySliceTupleSchemeFactory() {
        }

        public KeySliceTupleScheme getScheme() {
            return new KeySliceTupleScheme();
        }
    }

    private static class KeySliceStandardScheme
    extends StandardScheme<KeySlice> {
        private KeySliceStandardScheme() {
        }

        public void read(TProtocol iprot, KeySlice struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.key = iprot.readBinary();
                            struct.setKeyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list40 = iprot.readListBegin();
                            struct.columns = new ArrayList<ColumnOrSuperColumn>(_list40.size);
                            for (int _i41 = 0; _i41 < _list40.size; ++_i41) {
                                ColumnOrSuperColumn _elem42 = new ColumnOrSuperColumn();
                                _elem42.read(iprot);
                                struct.columns.add(_elem42);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, KeySlice struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.key != null) {
                oprot.writeFieldBegin(KEY_FIELD_DESC);
                oprot.writeBinary(struct.key);
                oprot.writeFieldEnd();
            }
            if (struct.columns != null) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (ColumnOrSuperColumn _iter43 : struct.columns) {
                    _iter43.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class KeySliceStandardSchemeFactory
    implements SchemeFactory {
        private KeySliceStandardSchemeFactory() {
        }

        public KeySliceStandardScheme getScheme() {
            return new KeySliceStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        KEY(1, "key"),
        COLUMNS(2, "columns");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return KEY;
                }
                case 2: {
                    return COLUMNS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

