/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.addthis.metrics3.reporter.config;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import io.github.hengyunabc.zabbix.sender.ZabbixSender;
import java.util.ArrayList;
import java.util.List;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.AbstractZabbixReporterConfig;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.HostPort;
import org.cassandraunit.shaded.com.addthis.metrics3.reporter.config.MetricFilterTransformer;
import org.cassandraunit.shaded.com.addthis.metrics3.reporter.config.MetricsReporterConfigThree;
import org.cassandraunit.shaded.com.addthis.metrics3.reporter.config.ZabbixReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZabbixReporterConfig
extends AbstractZabbixReporterConfig
implements MetricsReporterConfigThree {
    private static final Logger log = LoggerFactory.getLogger(ZabbixReporterConfig.class);
    private static final String SENDER_CLASS = "io.github.hengyunabc.zabbix.sender.ZabbixSender";
    private final List<ZabbixReporter> reporters = new ArrayList<ZabbixReporter>();
    private MetricRegistry registry;

    @Override
    public boolean enable(MetricRegistry registry) {
        if (!this.isClassAvailable(SENDER_CLASS)) {
            log.error("Tried to enable Zabbix Reporter, but class {} was not found", (Object)SENDER_CLASS);
            return false;
        }
        this.registry = registry;
        if (this.hostName == null) {
            this.hostName = System.getenv("COMPUTERNAME");
        }
        if (this.hostName == null) {
            this.hostName = System.getenv("HOSTNAME");
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
        for (HostPort hostPort : this.getFullHostList()) {
            ZabbixSender sender = new ZabbixSender(hostPort.getHost(), hostPort.getPort(), this.connectTimeout, this.socketTimeout);
            MetricFilter filter = MetricFilterTransformer.generateFilter(this.getPredicate());
            ZabbixReporter reporter = new ZabbixReporter(sender, this.hostName, this.prefix, registry, this.name, filter, this.getRealRateunit(), this.getRealDurationunit());
            this.reporters.add(reporter);
        }
        return true;
    }

    @Override
    public List<HostPort> getFullHostList() {
        return this.getHostListAndStringList();
    }

    @Override
    public void report() {
    }
}

