/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.addthis.metrics.reporter.config;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.AbstractHostPortReporterConfig;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.GmondConfigParser;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.HostPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractGangliaReporterConfig
extends AbstractHostPortReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractGangliaReporterConfig.class);
    @NotNull
    protected String groupPrefix = "";
    @NotNull
    protected boolean compressPackageNames = false;
    protected String gmondConf;

    public boolean getCompressPackageNames() {
        return this.compressPackageNames;
    }

    public void setCompressPackageNames(boolean compressPackageNames) {
        this.compressPackageNames = compressPackageNames;
    }

    public String getGmondConf() {
        return this.gmondConf;
    }

    public void setGmondConf(String gmondConf) {
        this.gmondConf = gmondConf;
    }

    public String getGroupPrefix() {
        return this.groupPrefix;
    }

    public void setGroupPrefix(String groupPrefix) {
        this.groupPrefix = groupPrefix;
    }

    @Override
    public List<HostPort> getFullHostList() {
        if (this.gmondConf != null) {
            GmondConfigParser gcp = new GmondConfigParser();
            List<HostPort> confHosts = gcp.getGmondSendChannels(this.gmondConf);
            if (confHosts == null || confHosts.isEmpty()) {
                log.warn("No send channels found after reading {}", (Object)this.gmondConf);
            }
            return confHosts;
        }
        return this.getHostListAndStringList();
    }

    protected boolean setup(String className) {
        if (!this.isClassAvailable(className)) {
            log.error("Tried to enable GangliaReporter, but class {} was not found", (Object)className);
            return false;
        }
        List<HostPort> hosts = this.getFullHostList();
        if (hosts == null || hosts.isEmpty()) {
            log.error("No hosts specified, cannot enable GangliaReporter");
            return false;
        }
        return true;
    }
}

